/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.util.Arrays;
import org.apache.tika.mime.Clause;

class AndClause
implements Clause {
    private final Clause[] clauses;

    AndClause(Clause ... clauses) {
        this.clauses = clauses;
    }

    public boolean eval(byte[] data) {
        Clause[] clauseArray = this.clauses;
        int n = this.clauses.length;
        int n2 = 0;
        while (n2 < n) {
            Clause clause = clauseArray[n2];
            if (!clause.eval(data)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int size() {
        int size = 0;
        Clause[] clauseArray = this.clauses;
        int n = this.clauses.length;
        int n2 = 0;
        while (n2 < n) {
            Clause clause = clauseArray[n2];
            size += clause.size();
            ++n2;
        }
        return size;
    }

    public String toString() {
        return "and" + Arrays.toString(this.clauses);
    }
}

