/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.tika.metadata.Metadata;

public class MetadataHelper {
    private MetadataHelper() {
    }

    public static InputStream getInputStream(URL url, Metadata metadata) throws IOException {
        int length;
        String encoding;
        String type;
        URLConnection connection = url.openConnection();
        String path = url.getPath();
        int slash = path.lastIndexOf(47);
        if (slash + 1 < path.length()) {
            metadata.set("resourceName", path.substring(slash + 1));
        }
        if ((type = connection.getContentType()) != null) {
            metadata.set("Content-Type", type);
        }
        if ((encoding = connection.getContentEncoding()) != null) {
            metadata.set("Content-Type", encoding);
        }
        if ((length = connection.getContentLength()) >= 0) {
            metadata.set("Content-Length", Integer.toString(length));
        }
        return connection.getInputStream();
    }
}

