/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.language;

import java.io.IOException;
import java.io.Writer;
import org.apache.tika.language.LanguageIdentifier;
import org.apache.tika.language.LanguageProfile;

public class ProfilingWriter
extends Writer {
    private final LanguageProfile profile;
    private char[] buffer;
    private int n;

    public ProfilingWriter(LanguageProfile profile) {
        char[] cArray = new char[3];
        cArray[2] = 95;
        this.buffer = cArray;
        this.n = 1;
        this.profile = profile;
    }

    public ProfilingWriter() {
        this(new LanguageProfile());
    }

    public LanguageProfile getProfile() {
        return this.profile;
    }

    public LanguageIdentifier getLanguage() {
        return new LanguageIdentifier(this.profile);
    }

    public void write(char[] cbuf, int off, int len) {
        int i = 0;
        while (i < len) {
            char c = Character.toLowerCase(cbuf[off + i]);
            if (Character.isLetter(c)) {
                this.addLetter(c);
            } else {
                this.addSeparator();
            }
            ++i;
        }
    }

    private void addLetter(char c) {
        System.arraycopy(this.buffer, 1, this.buffer, 0, this.buffer.length - 1);
        this.buffer[this.buffer.length - 1] = c;
        ++this.n;
        if (this.n >= this.buffer.length) {
            this.profile.add(new String(this.buffer));
        }
    }

    private void addSeparator() {
        this.addLetter('_');
        this.n = 1;
    }

    public void close() throws IOException {
        this.addSeparator();
    }

    public void flush() {
    }
}

