/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.language;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.tika.language.LanguageProfile;

public class LanguageIdentifier {
    private static final Map<String, LanguageProfile> PROFILES = new HashMap<String, LanguageProfile>();
    private final String language;
    private final double distance;

    static {
        LanguageIdentifier.addProfile("da");
        LanguageIdentifier.addProfile("de");
        LanguageIdentifier.addProfile("ee");
        LanguageIdentifier.addProfile("el");
        LanguageIdentifier.addProfile("en");
        LanguageIdentifier.addProfile("es");
        LanguageIdentifier.addProfile("fi");
        LanguageIdentifier.addProfile("fr");
        LanguageIdentifier.addProfile("hu");
        LanguageIdentifier.addProfile("is");
        LanguageIdentifier.addProfile("it");
        LanguageIdentifier.addProfile("nl");
        LanguageIdentifier.addProfile("no");
        LanguageIdentifier.addProfile("pl");
        LanguageIdentifier.addProfile("pt");
        LanguageIdentifier.addProfile("ru");
        LanguageIdentifier.addProfile("sv");
        LanguageIdentifier.addProfile("th");
    }

    private static void addProfile(String language) {
        try {
            LanguageProfile profile = new LanguageProfile();
            InputStream stream = LanguageIdentifier.class.getResourceAsStream(String.valueOf(language) + ".ngp");
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                String line = reader.readLine();
                while (line != null) {
                    if (line.length() > 0 && !line.startsWith("#")) {
                        int space = line.indexOf(32);
                        profile.add(line.substring(0, space), Long.parseLong(line.substring(space + 1)));
                    }
                    line = reader.readLine();
                }
            }
            finally {
                stream.close();
            }
            PROFILES.put(language, profile);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public LanguageIdentifier(LanguageProfile profile) {
        String minLanguage = "unknown";
        double minDistance = 1.0;
        for (Map.Entry<String, LanguageProfile> entry : PROFILES.entrySet()) {
            double distance = profile.distance(entry.getValue());
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            minLanguage = entry.getKey();
        }
        this.language = minLanguage;
        this.distance = minDistance;
    }

    public LanguageIdentifier(String content) {
        this(new LanguageProfile(content));
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean isReasonablyCertain() {
        return this.distance < 0.022;
    }

    public String toString() {
        return String.valueOf(this.language) + " (" + this.distance + ")";
    }
}

