/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public class TextDetector
implements Detector {
    private static final int NUMBER_OF_BYTES_TO_TEST = 512;
    private static final boolean[] IS_CONTROL_BYTE = new boolean[32];

    static {
        Arrays.fill(IS_CONTROL_BYTE, true);
        TextDetector.IS_CONTROL_BYTE[9] = false;
        TextDetector.IS_CONTROL_BYTE[10] = false;
        TextDetector.IS_CONTROL_BYTE[12] = false;
        TextDetector.IS_CONTROL_BYTE[13] = false;
        TextDetector.IS_CONTROL_BYTE[27] = false;
    }

    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        if (input == null) {
            return MediaType.OCTET_STREAM;
        }
        input.mark(512);
        try {
            int i = 0;
            while (i < 512) {
                int ch = input.read();
                if (ch == -1) {
                    MediaType mediaType = MediaType.TEXT_PLAIN;
                    return mediaType;
                }
                if (ch < IS_CONTROL_BYTE.length && IS_CONTROL_BYTE[ch]) {
                    MediaType mediaType = MediaType.OCTET_STREAM;
                    return mediaType;
                }
                ++i;
            }
            MediaType mediaType = MediaType.TEXT_PLAIN;
            return mediaType;
        }
        finally {
            input.reset();
        }
    }
}

