/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public class MagicDetector
implements Detector {
    private final MediaType type;
    private final int length;
    private final byte[] pattern;
    private final byte[] mask;
    private final int offsetRangeBegin;
    private final int offsetRangeEnd;

    public MagicDetector(MediaType type, byte[] pattern) {
        this(type, pattern, 0);
    }

    public MagicDetector(MediaType type, byte[] pattern, int offset) {
        this(type, pattern, null, offset, offset);
    }

    public MagicDetector(MediaType type, byte[] pattern, byte[] mask, int offsetRangeBegin, int offsetRangeEnd) {
        if (type == null) {
            throw new IllegalArgumentException("Matching media type is null");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("Magic match pattern is null");
        }
        if (offsetRangeBegin < 0 || offsetRangeEnd < offsetRangeBegin) {
            throw new IllegalArgumentException("Invalid offset range: [" + offsetRangeBegin + "," + offsetRangeEnd + "]");
        }
        this.type = type;
        this.length = Math.max(pattern.length, mask != null ? mask.length : 0);
        this.mask = new byte[this.length];
        this.pattern = new byte[this.length];
        int i = 0;
        while (i < this.length) {
            this.mask[i] = mask != null && i < mask.length ? mask[i] : -1;
            this.pattern[i] = i < pattern.length ? (byte)(pattern[i] & this.mask[i]) : (byte)0;
            ++i;
        }
        this.offsetRangeBegin = offsetRangeBegin;
        this.offsetRangeEnd = offsetRangeEnd;
    }

    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        if (input == null) {
            return MediaType.OCTET_STREAM;
        }
        input.mark(this.offsetRangeEnd + this.length);
        try {
            int offset = 0;
            while (offset < this.offsetRangeBegin) {
                long n = input.skip(this.offsetRangeBegin - offset);
                if (n > 0L) {
                    offset = (int)((long)offset + n);
                    continue;
                }
                if (input.read() != -1) {
                    ++offset;
                    continue;
                }
                MediaType mediaType = MediaType.OCTET_STREAM;
                return mediaType;
            }
            byte[] buffer = new byte[this.length + (this.offsetRangeEnd - this.offsetRangeBegin)];
            int n = input.read(buffer);
            if (n > 0) {
                offset += n;
            }
            while (n != -1 && offset < this.offsetRangeEnd + this.length) {
                int bufferOffset = offset - this.offsetRangeBegin;
                n = input.read(buffer, bufferOffset, buffer.length - bufferOffset);
            }
            if (offset < this.offsetRangeBegin + this.length) {
                MediaType mediaType = MediaType.OCTET_STREAM;
                return mediaType;
            }
            int i = 0;
            while (i <= this.offsetRangeEnd - this.offsetRangeBegin) {
                boolean match = true;
                int j = 0;
                while (match && j < this.length) {
                    match = (buffer[i + j] & this.mask[j]) == this.pattern[j];
                    ++j;
                }
                if (match) {
                    MediaType mediaType = this.type;
                    return mediaType;
                }
                ++i;
            }
            MediaType mediaType = MediaType.OCTET_STREAM;
            return mediaType;
        }
        finally {
            input.reset();
        }
    }
}

