/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.MetadataHelper;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParsingReader;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.WriteOutContentHandler;
import org.xml.sax.SAXException;

public class Tika {
    private final Detector detector;
    private final Parser parser;
    private int maxStringLength = 100000;

    public Tika(TikaConfig config) {
        this.detector = config.getMimeRepository();
        this.parser = new AutoDetectParser(config);
    }

    public Tika() {
        this(TikaConfig.getDefaultConfig());
    }

    public String detect(InputStream stream, Metadata metadata) throws IOException {
        if (stream == null || stream.markSupported()) {
            return this.detector.detect(stream, metadata).toString();
        }
        return this.detector.detect(new BufferedInputStream(stream), metadata).toString();
    }

    public String detect(InputStream stream) throws IOException {
        return this.detect(stream, new Metadata());
    }

    public String detect(File file) throws IOException {
        return this.detect(file.toURI().toURL());
    }

    public String detect(URL url) throws IOException {
        Metadata metadata = new Metadata();
        InputStream stream = MetadataHelper.getInputStream(url, metadata);
        try {
            String string = this.detect(stream, metadata);
            return string;
        }
        finally {
            stream.close();
        }
    }

    public String detect(String name) {
        Metadata metadata = new Metadata();
        metadata.set("resourceName", name);
        try {
            return this.detect(null, metadata);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException", e);
        }
    }

    public Reader parse(InputStream stream, Metadata metadata) throws IOException {
        ParseContext context = new ParseContext();
        context.set(Parser.class, this.parser);
        return new ParsingReader(this.parser, stream, metadata, context);
    }

    public Reader parse(InputStream stream) throws IOException {
        return this.parse(stream, new Metadata());
    }

    public Reader parse(File file) throws IOException {
        return this.parse(file.toURI().toURL());
    }

    public Reader parse(URL url) throws IOException {
        Metadata metadata = new Metadata();
        InputStream stream = MetadataHelper.getInputStream(url, metadata);
        return this.parse(stream, metadata);
    }

    public String parseToString(InputStream stream, Metadata metadata) throws IOException, TikaException {
        WriteOutContentHandler handler;
        block6: {
            handler = new WriteOutContentHandler(this.maxStringLength);
            try {
                try {
                    ParseContext context = new ParseContext();
                    context.set(Parser.class, this.parser);
                    this.parser.parse(stream, new BodyContentHandler(handler), metadata, context);
                }
                catch (SAXException e) {
                    if (!handler.isWriteLimitReached(e)) {
                        throw new TikaException("Unexpected SAX processing failure", e);
                    }
                    stream.close();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                stream.close();
                throw throwable;
            }
            stream.close();
        }
        return handler.toString();
    }

    public String parseToString(InputStream stream) throws IOException, TikaException {
        return this.parseToString(stream, new Metadata());
    }

    public String parseToString(File file) throws IOException, TikaException {
        return this.parseToString(file.toURI().toURL());
    }

    public String parseToString(URL url) throws IOException, TikaException {
        Metadata metadata = new Metadata();
        InputStream stream = MetadataHelper.getInputStream(url, metadata);
        return this.parseToString(stream, metadata);
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public void setMaxStringLength(int maxStringLength) {
        this.maxStringLength = maxStringLength;
    }
}

