/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.felix.utils.filter.FilterImpl;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.apache.felix.utils.properties.Properties$Layout;
import org.apache.felix.utils.properties.Properties$PropertiesReader;
import org.apache.felix.utils.properties.Properties$PropertiesWriter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Properties
extends AbstractMap<String, String> {
    private static final char[] a;
    private static final char[] b;
    private static final String c;
    private Map<String, String> d = new LinkedHashMap<String, String>();
    private Map<String, Properties$Layout> e = new LinkedHashMap<String, Properties$Layout>();
    private List<String> f;
    private List<String> g;
    private File h;
    public static boolean i;
    private static final String[] z;

    public Properties() {
    }

    public Properties(File file) throws IOException {
        this.h = file;
        if (file.exists()) {
            this.load(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.load(fileInputStream);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        try {
            this.load(inputStream);
        }
        finally {
            inputStream.close();
        }
    }

    public void load(InputStream inputStream) throws IOException {
        this.load(new InputStreamReader(inputStream, z[6]));
    }

    public void load(Reader reader) throws IOException {
        this.loadLayout(reader);
    }

    public void save() throws IOException {
        this.save(this.h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            this.save(fileOutputStream);
        }
        finally {
            ((OutputStream)fileOutputStream).close();
        }
    }

    public void save(OutputStream outputStream) throws IOException {
        this.save(new OutputStreamWriter(outputStream, z[6]));
    }

    public void save(Writer writer) throws IOException {
        this.saveLayout(writer);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.d.entrySet();
    }

    @Override
    public String put(String string, String string2) {
        Properties$Layout properties$Layout;
        String string3 = this.d.put(string, string2);
        if (!(string3 != null && string3.equals(string2) || (properties$Layout = this.e.get(string)) == null)) {
            properties$Layout.clearValue();
        }
        return string3;
    }

    @Override
    public String remove(Object object) {
        Properties$Layout properties$Layout = this.e.get(object);
        if (properties$Layout != null) {
            properties$Layout.clearValue();
        }
        return this.d.remove(object);
    }

    @Override
    public void clear() {
        boolean bl = i;
        for (Properties$Layout properties$Layout : this.e.values()) {
            properties$Layout.clearValue();
            if (!bl) continue;
        }
        this.d.clear();
    }

    public List<String> getHeader() {
        return this.f;
    }

    public void setHeader(List<String> list) {
        this.f = list;
    }

    public List<String> getFooter() {
        return this.g;
    }

    public void setFooter(List<String> list) {
        this.g = list;
    }

    protected void loadLayout(Reader reader) throws IOException {
        boolean bl = i;
        Properties$PropertiesReader properties$PropertiesReader = new Properties$PropertiesReader(reader);
        while (properties$PropertiesReader.nextProperty()) {
            this.d.put(properties$PropertiesReader.getPropertyName(), properties$PropertiesReader.getPropertyValue());
            int n = this.a(properties$PropertiesReader.getCommentLines());
            this.e.put(properties$PropertiesReader.getPropertyName(), new Properties$Layout((List<String>)(n < properties$PropertiesReader.getCommentLines().size() ? new ArrayList<String>(properties$PropertiesReader.getCommentLines().subList(n, properties$PropertiesReader.getCommentLines().size())) : null), new ArrayList<String>(properties$PropertiesReader.getValueLines())));
            if (!bl) continue;
        }
        this.g = new ArrayList<String>(properties$PropertiesReader.getCommentLines());
        InterpolationHelper.performSubstitution(this.d);
    }

    protected void saveLayout(Writer writer) throws IOException {
        boolean bl = i;
        Properties$PropertiesWriter properties$PropertiesWriter = new Properties$PropertiesWriter(writer);
        if (this.f != null) {
            for (String string : this.f) {
                properties$PropertiesWriter.writeln(string);
                if (!bl) continue;
            }
        }
        for (String string : this.d.keySet()) {
            block13: {
                block12: {
                    Properties$Layout properties$Layout = this.e.get(string);
                    if (properties$Layout != null && properties$Layout.getCommentLines() != null) {
                        for (String string2 : properties$Layout.getCommentLines()) {
                            properties$PropertiesWriter.writeln(string2);
                            if (!bl) continue;
                        }
                    }
                    if (properties$Layout == null || properties$Layout.getValueLines() == null) break block12;
                    for (String string2 : properties$Layout.getValueLines()) {
                        properties$PropertiesWriter.writeln(string2);
                        if (!bl) continue;
                    }
                    if (!bl) break block13;
                }
                properties$PropertiesWriter.writeProperty(string, this.d.get(string));
            }
            if (!bl) continue;
        }
        if (this.g != null) {
            for (String string : this.g) {
                properties$PropertiesWriter.writeln(string);
                if (!bl) continue;
            }
        }
        properties$PropertiesWriter.flush();
        if (FilterImpl.h != 0) {
            i = !bl;
        }
    }

    private int a(List<String> list) {
        boolean bl = i;
        if (this.getHeader() == null && this.e.isEmpty()) {
            int n;
            for (n = list.size() - 1; n >= 0 && list.get(n).length() > 0; --n) {
                if (!bl) continue;
            }
            this.setHeader(new ArrayList<String>(list.subList(0, n + 1)));
            return n + 1;
        }
        return 0;
    }

    static boolean a(String string) {
        String string2 = string.trim();
        return string2.length() < 1 || z[0].indexOf(string2.charAt(0)) >= 0;
    }

    protected static String unescapeJava(String string) {
        boolean bl = i;
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        StringBuffer stringBuffer2 = new StringBuffer(4);
        boolean bl2 = false;
        boolean bl3 = false;
        block13: for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (bl3) {
                stringBuffer2.append(c2);
                if (stringBuffer2.length() != 4) continue;
                try {
                    int n2 = Integer.parseInt(stringBuffer2.toString(), 16);
                    stringBuffer.append((char)n2);
                    stringBuffer2.setLength(0);
                    bl3 = false;
                    bl2 = false;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(new StringBuffer().append(z[5]).append((Object)stringBuffer2).toString(), numberFormatException);
                }
            }
            if (bl2) {
                bl2 = false;
                switch (c2) {
                    case '\\': {
                        stringBuffer.append('\\');
                        if (!bl) continue block13;
                    }
                    case '\'': {
                        stringBuffer.append('\'');
                        if (!bl) continue block13;
                    }
                    case '\"': {
                        stringBuffer.append('\"');
                        if (!bl) continue block13;
                    }
                    case 'r': {
                        stringBuffer.append('\r');
                        if (!bl) continue block13;
                    }
                    case 'f': {
                        stringBuffer.append('\f');
                        if (!bl) continue block13;
                    }
                    case 't': {
                        stringBuffer.append('\t');
                        if (!bl) continue block13;
                    }
                    case 'n': {
                        stringBuffer.append('\n');
                        if (!bl) continue block13;
                    }
                    case 'b': {
                        stringBuffer.append('\b');
                        if (!bl) continue block13;
                    }
                    case 'u': {
                        bl3 = true;
                        if (!bl) continue block13;
                    }
                    default: {
                        stringBuffer.append(c2);
                        if (!bl) continue block13;
                    }
                }
            }
            if (c2 == '\\') {
                bl2 = true;
                if (!bl) continue;
            }
            stringBuffer.append(c2);
            if (!bl) continue;
        }
        if (bl2) {
            stringBuffer.append('\\');
        }
        return stringBuffer.toString();
    }

    protected static String escapeJava(String string) {
        boolean bl = i;
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        block11: for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 > '\u0fff') {
                stringBuffer.append(z[3]).append(Properties.hex(c2));
                if (!bl) continue;
            }
            if (c2 > '\u00ff') {
                stringBuffer.append(z[1]).append(Properties.hex(c2));
                if (!bl) continue;
            }
            if (c2 > '\u007f') {
                stringBuffer.append(z[2]).append(Properties.hex(c2));
                if (!bl) continue;
            }
            if (c2 < ' ') {
                switch (c2) {
                    case '\b': {
                        stringBuffer.append('\\');
                        stringBuffer.append('b');
                        if (!bl) continue block11;
                    }
                    case '\n': {
                        stringBuffer.append('\\');
                        stringBuffer.append('n');
                        if (!bl) continue block11;
                    }
                    case '\t': {
                        stringBuffer.append('\\');
                        stringBuffer.append('t');
                        if (!bl) continue block11;
                    }
                    case '\f': {
                        stringBuffer.append('\\');
                        stringBuffer.append('f');
                        if (!bl) continue block11;
                    }
                    case '\r': {
                        stringBuffer.append('\\');
                        stringBuffer.append('r');
                        if (!bl) continue block11;
                    }
                    default: {
                        if (c2 > '\u000f') {
                            stringBuffer.append(z[2]).append(Properties.hex(c2));
                            if (!bl) continue block11;
                        }
                        stringBuffer.append(z[4]).append(Properties.hex(c2));
                        if (!bl) continue block11;
                    }
                }
            }
            switch (c2) {
                case '\"': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\"');
                    if (!bl) continue block11;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    if (!bl) continue block11;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
            if (!bl) continue;
        }
        return stringBuffer.toString();
    }

    protected static String hex(char c2) {
        return Integer.toHexString(c2).toUpperCase(Locale.ENGLISH);
    }

    public static boolean contains(char[] cArray, char c2) {
        boolean bl = i;
        if (cArray == null) {
            return false;
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (c2 != cArray[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object remove(Object object) {
        return this.remove(object);
    }

    @Override
    public Object put(Object object, Object object2) {
        return this.put((String)object, (String)object2);
    }

    static char[] a() {
        return b;
    }

    static char[] b() {
        return a;
    }

    static String c() {
        return c;
    }

    static {
        String[] stringArray = new String[7];
        Object var0 = null;
        stringArray[0] = Properties.z(Properties.z("\u0000\u000b"));
        var0 = null;
        stringArray[1] = Properties.z(Properties.z("\u007f_O"));
        var0 = null;
        stringArray[2] = Properties.z(Properties.z("\u007f_O8"));
        var0 = null;
        stringArray[3] = Properties.z(Properties.z("\u007f_"));
        var0 = null;
        stringArray[4] = Properties.z(Properties.z("\u007f_O8\u0019"));
        var0 = null;
        stringArray[5] = Properties.z(Properties.z("vD\u001ejEF\n\u000bg\tSK\r{L\u0003_\u0011aJLN\u001a(_BF\nm\u0013\u0003"));
        var0 = null;
        stringArray[6] = Properties.z(Properties.z("jy0%\u0011\u001b\u001fF%\u0018"));
        z = stringArray;
        a = new char[]{'=', ':'};
        b = new char[]{' ', '\t', '\f'};
        var0 = null;
        c = System.getProperty(Properties.z(Properties.z("OC\u0011m\u0007PO\u000fi[B^\u0010z")));
    }

    private static char[] z(String string) {
        char[] cArray;
        block1: {
            int n;
            char[] cArray2 = string.toCharArray();
            char[] cArray3 = cArray2;
            char[] cArray4 = cArray2;
            do {
                int n2 = cArray3.length;
                cArray = cArray4;
                n = n2;
                if (n2 >= 2) break block1;
                cArray4 = cArray;
                cArray3 = cArray;
            } while (n == 0);
            cArray = cArray4;
            n = 0;
            cArray3[0] = (char)(cArray3[0] ^ 0x29);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block10: {
            int n;
            int n2;
            char[] cArray3;
            int n3;
            block9: {
                n3 = 0;
                int n4 = cArray.length;
                cArray3 = cArray;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray2 = cArray3;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray3;
                char[] cArray5 = cArray3;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c2 = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 35;
                            break;
                        }
                        case 1: {
                            n6 = 42;
                            break;
                        }
                        case 2: {
                            n6 = 127;
                            break;
                        }
                        case 3: {
                            n6 = 8;
                            break;
                        }
                        default: {
                            n6 = 41;
                        }
                    }
                    cArray4[n5] = (char)(c2 ^ n6);
                    ++n3;
                    cArray3 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray3;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray3;
                }
                cArray2 = cArray3;
                n = n2;
            } while (n2 > n3);
        }
        return new String(cArray2).intern();
    }
}

