/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class ReaderInputStream
extends InputStream {
    private Reader reader;

    public ReaderInputStream(Reader reader) {
        this.reader = reader;
    }

    @Override
    public int read() throws IOException {
        return this.reader.read() & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        char[] c = new char[len];
        int result = this.reader.read(c, 0, len);
        int i = 0;
        while (i < len) {
            b[off + i] = (byte)(c[i] & 0xFF);
            ++i;
        }
        return result;
    }

    @Override
    public int available() throws IOException {
        return 0;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public void mark(int readAheadLimit) {
        try {
            this.reader.mark(readAheadLimit);
        }
        catch (IOException iOException) {}
    }

    @Override
    public boolean markSupported() {
        return this.reader.markSupported();
    }

    @Override
    public void reset() throws IOException {
        this.reader.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.reader.skip(n);
    }
}

