/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.Writer;
import java.util.EventListener;
import java.util.EventObject;
import java.util.TooManyListenersException;

public class LineNumberWriter
extends Writer {
    private static final int UNKNOWN = 0;
    private static final int CR = 1;
    private static final int CRLF = 2;
    private static final int LF = 3;
    private static final int LFCR = 4;
    private int lineSeparator = 0;
    private Writer out;
    private int lineNo = 0;
    private LineNumberListener listener;
    private int lineNoLimit;
    private int previous = -1;

    public LineNumberWriter(Writer out) {
        this.out = out;
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int i = 0;
        while (i < len) {
            this.write(cbuf[off + i]);
            ++i;
        }
    }

    @Override
    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        int i = 0;
        while (i < len) {
            this.write(str.charAt(off + i));
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int c) throws IOException {
        boolean newLine = false;
        Object object = this.lock;
        synchronized (object) {
            this.out.write(c);
            block2 : switch (this.lineSeparator) {
                default: {
                    switch (this.previous) {
                        case 13: {
                            ++this.lineNo;
                            int n = this.lineSeparator = c == 10 ? 2 : 1;
                            if (c != 13) break block2;
                            ++this.lineNo;
                            break;
                        }
                        case 10: {
                            ++this.lineNo;
                            int n = this.lineSeparator = c == 13 ? 4 : 3;
                            if (c != 10) break block2;
                            ++this.lineNo;
                            break;
                        }
                    }
                    break;
                }
                case 1: {
                    if (c != 13) break;
                    ++this.lineNo;
                    newLine = true;
                    break;
                }
                case 2: {
                    if (this.previous != 13 || c != 10) break;
                    ++this.lineNo;
                    newLine = true;
                    break;
                }
                case 3: {
                    if (c != 10) break;
                    ++this.lineNo;
                    newLine = true;
                    break;
                }
                case 4: {
                    if (this.previous != 10 || c != 13) break;
                    ++this.lineNo;
                    newLine = true;
                }
            }
            this.previous = c;
        }
        if (this.listener != null && newLine && this.lineNo >= this.lineNoLimit) {
            this.listener.lineNumberReached(new LineNumberEvent(this, this.lineNo));
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    public int getLineNumber() {
        return this.lineNo;
    }

    public void setLineNumber(int lineNo) {
        this.lineNo = lineNo;
    }

    public void addLineNumberListener(LineNumberListener listener, int lineNoLimit) throws TooManyListenersException {
        if (this.listener != null) {
            throw new TooManyListenersException();
        }
        if (lineNoLimit < 2) {
            throw new IllegalArgumentException("LineNoLimit cannot be less than 2");
        }
        this.listener = listener;
        this.lineNoLimit = lineNoLimit;
    }

    public static class LineNumberEvent
    extends EventObject {
        private static final long serialVersionUID = 2821724279014031198L;
        private int lineNo;

        public LineNumberEvent(Object source, int lineNo) {
            super(source);
            this.lineNo = lineNo;
        }

        public int getLineNumber() {
            return this.lineNo;
        }

        @Override
        public String toString() {
            return "LineNumberEvent: line=" + this.lineNo + "; " + this.getSource().toString();
        }
    }

    public static interface LineNumberListener
    extends EventListener {
        public void lineNumberReached(LineNumberEvent var1);
    }
}

