/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.freehep.util.io.ASCIIHexInputStream;
import org.freehep.util.io.EEXECConstants;

public class EEXECDecryption
extends InputStream
implements EEXECConstants {
    private int n;
    private int c1;
    private int c2;
    private int r;
    private InputStream in;
    private boolean first = true;

    public EEXECDecryption(InputStream in) {
        this(in, 55665, 4);
    }

    public EEXECDecryption(InputStream in, int r, int n) {
        this.in = in;
        this.r = r;
        this.n = n;
        this.c1 = 52845;
        this.c2 = 22719;
    }

    private int decrypt(int cipher) {
        int plain = (cipher ^ this.r >>> 8) % 256;
        this.r = ((cipher + this.r) * this.c1 + this.c2) % 65536;
        return plain;
    }

    @Override
    public int read() throws IOException {
        int b;
        if (this.first) {
            byte[] bytes = new byte[this.n];
            boolean notHex = false;
            int i = 0;
            while (i < bytes.length) {
                int c = this.in.read();
                bytes[i] = (byte)c;
                if (!(Character.isDigit((char)c) || c >= 97 && c <= 102 || c >= 65 && c <= 70)) {
                    notHex = true;
                }
                ++i;
            }
            if (notHex) {
                i = 0;
                while (i < bytes.length) {
                    this.decrypt(bytes[i] & 0xFF);
                    ++i;
                }
            } else {
                int asciiDecoded;
                ASCIIHexInputStream tempIn = new ASCIIHexInputStream(new ByteArrayInputStream(bytes), true);
                int byteCount = 0;
                while ((asciiDecoded = ((InputStream)tempIn).read()) >= 0) {
                    this.decrypt(asciiDecoded);
                    ++byteCount;
                }
                this.in = new ASCIIHexInputStream(this.in, true);
                while (byteCount < this.n) {
                    this.decrypt(this.in.read());
                    ++byteCount;
                }
            }
            this.first = false;
        }
        if ((b = this.in.read()) == -1) {
            return -1;
        }
        return this.decrypt(b);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.in.close();
    }
}

