/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.ps;

import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import org.freehep.graphics2d.GenericTagHandler;
import org.freehep.graphicsbase.util.ScientificFormat;
import org.freehep.graphicsbase.util.Value;

public class PSStringStyler {
    private static final float FONTSIZE_CORRECTION = 0.8333333f;
    private static final String BOLD_CHAR = "\\340\\001";
    private static final String ITALIC_CHAR = "\\340\\002";
    private static final String BOLD_ITALIC_CHAR = "\\340\\003";
    private static final String STRIKEOUT_FLAG = "\\360\\001";
    private static final String UNDERLINE_FLAG = "\\360\\002";
    private static final String DASHED_UNDERLINE_FLAG = "\\360\\003";
    private static final String DOTTED_UNDERLINE_FLAG = "\\360\\004";
    private static final String GRAY_UNDERLINE_FLAG = "\\360\\005";
    private static final String THICK_UNDERLINE_FLAG = "\\360\\006";
    private static final String OVERLINE_FLAG = "\\360\\007";
    private static final String BEGIN_GROUP = "\\360\\376";
    private static final String END_GROUP = "\\360\\377";

    public static String getStyledString(Map<AttributedCharacterIterator.Attribute, Object> attributes, String string) {
        Object posture;
        StringBuffer result = new StringBuffer();
        Float size = (Float)attributes.get(TextAttribute.SIZE);
        result.append(new ScientificFormat(6, 9, false).format(size.floatValue() * 0.8333333f));
        result.append(" ");
        result.append("cfont");
        String fontName = ((String)attributes.get(TextAttribute.FAMILY)).toLowerCase();
        if (fontName.indexOf("helvetica") != -1) {
            result.append("H");
        } else if (fontName.indexOf("dialog") != -1) {
            result.append("H");
        } else if (fontName.indexOf("dialoginput") != -1) {
            result.append("H");
        } else if (fontName.indexOf("sansserif") != -1) {
            result.append("H");
        } else if (fontName.indexOf("times") != -1) {
            result.append("T");
        } else if (fontName.indexOf("serif") != -1) {
            result.append("T");
        } else if (fontName.indexOf("courier") != -1) {
            result.append("C");
        } else if (fontName.indexOf("monospaced") != -1) {
            result.append("C");
        } else if (fontName.indexOf("typewriter") != -1) {
            result.append("C");
        } else {
            result.append("H");
        }
        Object weight = attributes.get(TextAttribute.WEIGHT);
        if (TextAttribute.WEIGHT_BOLD.equals(weight)) {
            result.append("B");
        }
        if (TextAttribute.POSTURE_OBLIQUE.equals(posture = attributes.get(TextAttribute.POSTURE))) {
            result.append("I");
        }
        result.append("\n(");
        Value openGroups = new Value();
        openGroups.set(0);
        result.append(PSStringStyler.getOpenTag(attributes, openGroups));
        result.append(PSStringStyler.getUnicodes(string));
        result.append(PSStringStyler.getCloseTag(openGroups));
        result.append(")");
        return result.toString();
    }

    public static String getUnicodes(String str) {
        StringBuffer codedString = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char chr = str.charAt(i);
            int cvalue = chr & 0xFF;
            int fvalue = (chr & 0xFF00) >>> 8;
            String cbyte = Integer.toOctalString(cvalue);
            String fbyte = Integer.toOctalString(fvalue);
            codedString.append('\\');
            int j = 0;
            while (j < 3 - fbyte.length()) {
                codedString.append('0');
                ++j;
            }
            codedString.append(fbyte);
            if (cvalue < 32 || cvalue > 126 || cvalue == 92 || cvalue == 37 || cvalue == 40 || cvalue == 41) {
                codedString.append('\\');
                j = 0;
                while (j < 3 - cbyte.length()) {
                    codedString.append('0');
                    ++j;
                }
                codedString.append(cbyte);
            } else {
                codedString.append((char)cvalue);
            }
            ++i;
        }
        return codedString.toString();
    }

    public static String getEscaped(String str) {
        StringBuffer result = new StringBuffer();
        result.append("(");
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '(' || c == ')' || c == '\\' || c == '%') {
                result.append('\\');
                result.append(c);
            } else if (c == '\u0000') {
                result.append('?');
            } else {
                result.append(c);
            }
            ++i;
        }
        result.append(")");
        return result.toString();
    }

    private static String getOpenTag(Map<AttributedCharacterIterator.Attribute, Object> attributes, Value open) {
        int openGroups = open.getInt();
        StringBuffer result = new StringBuffer();
        Object weight = attributes.get(TextAttribute.WEIGHT);
        Object posture = attributes.get(TextAttribute.POSTURE);
        if (weight != null && !TextAttribute.WEIGHT_REGULAR.equals(weight)) {
            if (TextAttribute.POSTURE_OBLIQUE.equals(posture)) {
                result.append(BOLD_ITALIC_CHAR);
            } else {
                result.append(BOLD_CHAR);
            }
            ++openGroups;
            result.append(BEGIN_GROUP);
        } else if (TextAttribute.POSTURE_OBLIQUE.equals(posture)) {
            result.append(ITALIC_CHAR);
            ++openGroups;
            result.append(BEGIN_GROUP);
        }
        Object underline = attributes.get(TextAttribute.UNDERLINE);
        if (TextAttribute.UNDERLINE_LOW_DASHED.equals(underline)) {
            result.append(DASHED_UNDERLINE_FLAG);
            ++openGroups;
            result.append(BEGIN_GROUP);
        } else if (TextAttribute.UNDERLINE_ON.equals(underline)) {
            result.append(UNDERLINE_FLAG);
            ++openGroups;
            result.append(BEGIN_GROUP);
        } else if (TextAttribute.UNDERLINE_LOW_DOTTED.equals(underline)) {
            result.append(DOTTED_UNDERLINE_FLAG);
            ++openGroups;
            result.append(BEGIN_GROUP);
        } else if (TextAttribute.UNDERLINE_LOW_TWO_PIXEL.equals(underline)) {
            result.append(THICK_UNDERLINE_FLAG);
            ++openGroups;
            result.append(BEGIN_GROUP);
        } else if (TextAttribute.UNDERLINE_LOW_GRAY.equals(underline)) {
            result.append(GRAY_UNDERLINE_FLAG);
            ++openGroups;
            result.append(BEGIN_GROUP);
        } else if (TextAttribute.UNDERLINE_LOW_DASHED.equals(underline)) {
            result.append(DASHED_UNDERLINE_FLAG);
            ++openGroups;
            result.append(BEGIN_GROUP);
        } else if (GenericTagHandler.UNDERLINE_OVERLINE.equals(underline)) {
            result.append(OVERLINE_FLAG);
            result.append(BEGIN_GROUP);
        }
        Object strike = attributes.get(TextAttribute.STRIKETHROUGH);
        if (TextAttribute.STRIKETHROUGH_ON.equals(strike)) {
            result.append(STRIKEOUT_FLAG);
            ++openGroups;
            result.append(BEGIN_GROUP);
        }
        open.set(openGroups);
        return result.toString();
    }

    private static String getCloseTag(Value open) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < open.getInt()) {
            result.append(END_GROUP);
            ++i;
        }
        open.set(0);
        return result.toString();
    }
}

