/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.freehep.graphicsio.pdf.PDF;
import org.freehep.graphicsio.pdf.PDFByteWriter;
import org.freehep.graphicsio.pdf.PDFCatalog;
import org.freehep.graphicsio.pdf.PDFConstants;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFDocInfo;
import org.freehep.graphicsio.pdf.PDFObject;
import org.freehep.graphicsio.pdf.PDFOutline;
import org.freehep.graphicsio.pdf.PDFOutlineList;
import org.freehep.graphicsio.pdf.PDFPage;
import org.freehep.graphicsio.pdf.PDFPageTree;
import org.freehep.graphicsio.pdf.PDFRef;
import org.freehep.graphicsio.pdf.PDFStream;
import org.freehep.graphicsio.pdf.PDFViewerPreferences;

public class PDFWriter
extends PDF
implements PDFConstants {
    private String open = null;
    private static final String lengthSuffix = "-length";
    private String catalogName;
    private String docInfoName;

    public PDFWriter(OutputStream out) throws IOException {
        this(out, "1.3");
    }

    public PDFWriter(OutputStream writer, String version) throws IOException {
        super(new PDFByteWriter(writer));
        this.out.println("%PDF-" + version);
        this.out.print("%");
        this.out.write(226);
        this.out.write(227);
        this.out.write(207);
        this.out.write(211);
        this.out.println();
        this.out.println();
    }

    public void close(String catalogName, String docInfoName) throws IOException {
        this.xref();
        this.trailer(catalogName, docInfoName);
        this.startxref();
        this.out.printPlain("%%EOF");
        this.out.println();
        this.out.close();
    }

    public void comment(String comment) throws IOException {
        this.out.println("% " + comment);
    }

    public void object(String name, Object[] objs) throws IOException {
        PDFObject object = this.openObject(name);
        object.entry(objs);
        this.close(object);
    }

    public void object(String name, int number) throws IOException {
        PDFObject object = this.openObject(name);
        object.entry(number);
        this.close(object);
    }

    public PDFObject openObject(String name) throws IOException {
        if (this.open != null) {
            System.err.println("PDFWriter error: '" + this.open + "' was not closed");
        }
        this.open = "PDFObject: " + name;
        PDFRef ref = this.ref(name);
        int objectNumber = ref.getObjectNumber();
        this.setXRef(objectNumber, this.out.getCount());
        PDFObject obj = new PDFObject(this, this.out, objectNumber, ref.getGenerationNumber());
        return obj;
    }

    public void close(PDFObject object) throws IOException {
        object.close();
        this.open = null;
    }

    public PDFDictionary openDictionary(String name) throws IOException {
        PDFObject object = this.openObject(name);
        PDFDictionary dictionary = object.openDictionary();
        return dictionary;
    }

    public void close(PDFDictionary dictionary) throws IOException {
        dictionary.close();
        this.open = null;
    }

    public PDFStream openStream(String name) throws IOException {
        return this.openStream(name, null);
    }

    public PDFStream openStream(String name, String[] encode) throws IOException {
        PDFObject object = this.openObject(name);
        PDFStream stream = object.openStream(name, encode);
        stream.entry("Length", this.ref(String.valueOf(name) + lengthSuffix));
        return stream;
    }

    public void close(PDFStream stream) throws IOException {
        stream.close();
        this.open = null;
        this.object(String.valueOf(stream.getName()) + lengthSuffix, stream.getLength());
    }

    public void close() throws IOException {
        this.close(this.catalogName, this.docInfoName);
    }

    public PDFDocInfo openDocInfo(String name) throws IOException {
        this.docInfoName = name;
        PDFObject object = this.openObject(name);
        PDFDocInfo info = object.openDocInfo(this);
        return info;
    }

    public void close(PDFDocInfo info) throws IOException {
        info.close();
        this.open = null;
    }

    public PDFCatalog openCatalog(String name, String pageTree) throws IOException {
        this.catalogName = name;
        PDFObject object = this.openObject(name);
        PDFCatalog catalog = object.openCatalog(this, this.ref(pageTree));
        return catalog;
    }

    public void close(PDFCatalog catalog) throws IOException {
        catalog.close();
        this.open = null;
    }

    public PDFPageTree openPageTree(String name, String parent) throws IOException {
        PDFObject object = this.openObject(name);
        PDFPageTree tree = object.openPageTree(this, this.ref(parent));
        return tree;
    }

    public void close(PDFPageTree tree) throws IOException {
        tree.close();
        this.open = null;
    }

    public PDFPage openPage(String name, String parent) throws IOException {
        PDFObject object = this.openObject(name);
        PDFPage page = object.openPage(this, this.ref(parent));
        return page;
    }

    public void close(PDFPage page) throws IOException {
        page.close();
        this.open = null;
    }

    public PDFViewerPreferences openViewerPreferences(String name) throws IOException {
        PDFObject object = this.openObject(name);
        PDFViewerPreferences prefs = object.openViewerPreferences(this);
        return prefs;
    }

    public void close(PDFViewerPreferences prefs) throws IOException {
        prefs.close();
        this.open = null;
    }

    public PDFOutlineList openOutlineList(String name, String first, String next) throws IOException {
        PDFObject object = this.openObject(name);
        PDFOutlineList list = object.openOutlineList(this, this.ref(first), this.ref(next));
        return list;
    }

    public void close(PDFOutlineList list) throws IOException {
        list.close();
        this.open = null;
    }

    public PDFOutline openOutline(String name, String title, String parent, String prev, String next) throws IOException {
        PDFObject object = this.openObject(name);
        PDFOutline outline = object.openOutline(this, this.ref(parent), title, this.ref(prev), this.ref(next));
        return outline;
    }

    public void close(PDFOutline outline) throws IOException {
        outline.close();
        this.open = null;
    }
}

