/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.freehep.graphicsio.pdf.PDFConstants;
import org.freehep.util.io.CountedByteOutputStream;

public class PDFByteWriter
extends CountedByteOutputStream
implements PDFConstants {
    private int indent = 0;
    private String indentString = "   ";

    PDFByteWriter(OutputStream out) {
        super(out);
    }

    public void write(String s) throws IOException {
        this.write(s.getBytes("ISO-8859-1"));
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        super.close();
    }

    public void print(String string) throws IOException {
        int i = 0;
        while (i < this.indent) {
            this.write(this.indentString);
            ++i;
        }
        this.printPlain(string);
    }

    public void printPlain(String string) throws IOException {
        this.write(string);
    }

    public void println() throws IOException {
        this.write(EOL);
    }

    public void indent() {
        ++this.indent;
    }

    public void outdent() {
        if (this.indent > 0) {
            --this.indent;
        }
    }

    public void println(String string) throws IOException {
        this.print(string);
        this.println();
    }

    public void print(int number) throws IOException {
        this.print(Integer.toString(number));
    }

    public void println(int number) throws IOException {
        this.print(number);
        this.println();
    }

    public void printPlain(int number) throws IOException {
        this.printPlain(Integer.toString(number));
    }

    public void print(double number) throws IOException {
        this.print(Double.toString(number));
    }

    public void println(double number) throws IOException {
        this.print(number);
        this.println();
    }

    public void printPlain(double number) throws IOException {
        this.printPlain(Double.toString(number));
    }

    public void print(Object object) throws IOException {
        this.print(object.toString());
    }

    public void println(Object object) throws IOException {
        this.print(object);
        this.println();
    }

    public void printPlain(Object object) throws IOException {
        this.printPlain(object.toString());
    }
}

