/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.truetype;

import java.io.IOException;
import org.freehep.graphicsio.font.truetype.TTFHHeaTable;
import org.freehep.graphicsio.font.truetype.TTFMaxPTable;
import org.freehep.graphicsio.font.truetype.TTFTable;

public class TTFHMtxTable
extends TTFTable {
    public int[] advanceWidth;
    public short[] leftSideBearing;
    public short[] leftSideBearing2;

    @Override
    public String getTag() {
        return "hmtx";
    }

    @Override
    public void readTable() throws IOException {
        int numberOfHMetrics = ((TTFHHeaTable)this.getTable((String)"hhea")).numberOfHMetrics;
        int numGlyphs = ((TTFMaxPTable)this.getTable((String)"maxp")).numGlyphs;
        this.advanceWidth = new int[numberOfHMetrics];
        this.leftSideBearing = new short[numberOfHMetrics];
        int i = 0;
        while (i < numberOfHMetrics) {
            this.advanceWidth[i] = this.ttf.readUFWord();
            this.leftSideBearing[i] = this.ttf.readFWord();
            ++i;
        }
        this.leftSideBearing2 = this.ttf.readShortArray(numGlyphs - numberOfHMetrics);
    }

    @Override
    public String toString() {
        String str = super.toString();
        str = String.valueOf(str) + "\n  hMetrics[" + this.advanceWidth.length + "] = {";
        int i = 0;
        while (i < this.advanceWidth.length) {
            if (i % 8 == 0) {
                str = String.valueOf(str) + "\n    ";
            }
            str = String.valueOf(str) + "(" + this.advanceWidth[i] + "," + this.leftSideBearing[i] + ") ";
            ++i;
        }
        str = String.valueOf(str) + "\n  }";
        str = String.valueOf(str) + "\n  lsb[" + this.leftSideBearing2.length + "] = {";
        i = 0;
        while (i < this.leftSideBearing2.length) {
            if (i % 16 == 0) {
                str = String.valueOf(str) + "\n    ";
            }
            str = String.valueOf(str) + this.leftSideBearing2[i] + " ";
            ++i;
        }
        str = String.valueOf(str) + "\n  }";
        return str;
    }
}

