/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.truetype;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.freehep.graphicsio.font.truetype.TTFInput;

public class TTFFileInput
extends TTFInput {
    private RandomAccessFile ttf;
    private long offset;
    private long length;
    private long checksum;

    public TTFFileInput(RandomAccessFile file, long offset, long length, long checksum) throws IOException {
        this.ttf = file;
        this.offset = offset;
        this.length = length;
        this.checksum = checksum;
    }

    @Override
    public void seek(long offset) throws IOException {
        this.ttf.seek(this.offset + offset);
    }

    @Override
    long getPointer() throws IOException {
        return this.ttf.getFilePointer() - this.offset;
    }

    @Override
    public int readByte() throws IOException {
        return this.ttf.readUnsignedByte();
    }

    @Override
    public int readRawByte() throws IOException {
        return this.ttf.readByte() & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        return this.ttf.readShort();
    }

    @Override
    public int readUShort() throws IOException {
        return this.ttf.readUnsignedShort();
    }

    @Override
    public int readLong() throws IOException {
        return this.ttf.readInt();
    }

    @Override
    public long readULong() throws IOException {
        byte[] temp = new byte[4];
        this.ttf.readFully(temp);
        long l = 0L;
        long weight = 1L;
        int i = 0;
        while (i < temp.length) {
            l += (long)(temp[3 - i] & 0xFF) * weight;
            weight *= 256L;
            ++i;
        }
        return l;
    }

    @Override
    public byte readChar() throws IOException {
        return this.ttf.readByte();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.ttf.readFully(b);
    }

    public String toString() {
        return String.valueOf(this.offset) + "-" + (this.offset + this.length - 1L) + " - " + this.checksum;
    }
}

