/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.truetype;

import java.io.IOException;
import org.freehep.graphicsio.font.truetype.TTFTable;

public class TTFCMapTable
extends TTFTable {
    public int version;
    public EncodingTable[] encodingTable;

    @Override
    public String getTag() {
        return "cmap";
    }

    @Override
    public void readTable() throws IOException {
        this.version = this.ttf.readUShort();
        this.encodingTable = new EncodingTable[this.ttf.readUShort()];
        int i = 0;
        while (i < this.encodingTable.length) {
            this.encodingTable[i] = new EncodingTable();
            this.encodingTable[i].readHeader();
            ++i;
        }
        i = 0;
        while (i < this.encodingTable.length) {
            this.encodingTable[i].readBody();
            ++i;
        }
    }

    @Override
    public String toString() {
        String str = String.valueOf(super.toString()) + " v" + this.version;
        int i = 0;
        while (i < this.encodingTable.length) {
            str = String.valueOf(str) + "\n  " + this.encodingTable[i];
            ++i;
        }
        return str;
    }

    public class EncodingTable {
        public int platformID;
        public int encodingID;
        public long offset;
        public int format;
        public int length;
        public int version;
        public TableFormat tableFormat;

        public void readHeader() throws IOException {
            this.platformID = TTFCMapTable.this.ttf.readUShort();
            this.encodingID = TTFCMapTable.this.ttf.readUShort();
            this.offset = TTFCMapTable.this.ttf.readULong();
        }

        public void readBody() throws IOException {
            TTFCMapTable.this.ttf.seek(this.offset);
            this.format = TTFCMapTable.this.ttf.readUShort();
            this.length = TTFCMapTable.this.ttf.readUShort();
            this.version = TTFCMapTable.this.ttf.readUShort();
            switch (this.format) {
                case 0: {
                    this.tableFormat = new TableFormat0();
                    break;
                }
                case 4: {
                    this.tableFormat = new TableFormat4();
                    break;
                }
                case 2: 
                case 6: {
                    System.err.println("Unimplementet encoding table format: " + this.format);
                    break;
                }
                default: {
                    System.err.println("Illegal value for encoding table format: " + this.format);
                }
            }
            if (this.tableFormat != null) {
                this.tableFormat.read();
            }
        }

        public String toString() {
            String str = "[encoding] PID:" + this.platformID + " EID:" + this.encodingID + " format:" + this.format + " v" + this.version + (this.tableFormat != null ? this.tableFormat.toString() : " [no data read]");
            return str;
        }
    }

    public abstract class TableFormat {
        public abstract void read() throws IOException;

        public abstract int getGlyphIndex(int var1);
    }

    public class TableFormat0
    extends TableFormat {
        public int[] glyphIdArray = new int[256];

        @Override
        public void read() throws IOException {
            int i = 0;
            while (i < this.glyphIdArray.length) {
                this.glyphIdArray[i] = TTFCMapTable.this.ttf.readByte();
                ++i;
            }
        }

        public String toString() {
            String str = "";
            int i = 0;
            while (i < this.glyphIdArray.length) {
                if (i % 16 == 0) {
                    str = String.valueOf(str) + "\n    " + Integer.toHexString(i / 16) + "x: ";
                }
                String number = String.valueOf(this.glyphIdArray[i]);
                while (number.length() < 3) {
                    number = " " + number;
                }
                str = String.valueOf(str) + number + " ";
                ++i;
            }
            return str;
        }

        @Override
        public int getGlyphIndex(int character) {
            return this.glyphIdArray[character];
        }
    }

    public class TableFormat4
    extends TableFormat {
        public int segCount;
        public int[] endCount;
        public int[] startCount;
        public int[] idRangeOffset;
        public short[] idDelta;

        @Override
        public void read() throws IOException {
            this.segCount = TTFCMapTable.this.ttf.readUShort() / 2;
            TTFCMapTable.this.ttf.readUShort();
            TTFCMapTable.this.ttf.readUShort();
            TTFCMapTable.this.ttf.readUShort();
            this.endCount = TTFCMapTable.this.ttf.readUShortArray(this.segCount);
            int reservedPad = TTFCMapTable.this.ttf.readUShort();
            if (reservedPad != 0) {
                System.err.println("reservedPad not 0, but " + reservedPad + ".");
            }
            this.startCount = TTFCMapTable.this.ttf.readUShortArray(this.endCount.length);
            this.idDelta = TTFCMapTable.this.ttf.readShortArray(this.endCount.length);
            this.idRangeOffset = TTFCMapTable.this.ttf.readUShortArray(this.endCount.length);
        }

        public String toString() {
            String str = "\n   " + this.endCount.length + " sections:";
            int i = 0;
            while (i < this.endCount.length) {
                str = String.valueOf(str) + "\n    " + this.startCount[i] + " to " + this.endCount[i] + " : " + this.idDelta[i] + " (" + this.idRangeOffset[i] + ")";
                ++i;
            }
            return str;
        }

        @Override
        public int getGlyphIndex(int character) {
            return 0;
        }
    }
}

