/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsbase.util.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.spi.RegisterableService;
import javax.imageio.spi.ServiceRegistry;
import org.freehep.graphicsbase.util.Service;
import org.freehep.graphicsbase.util.export.ExportFileType;

public class ExportFileTypeRegistry {
    private static ExportFileTypeRegistry registry;
    private static ClassLoader loader;
    private ServiceRegistry service = new ServiceRegistry(categories.iterator());
    private List<ExportFileType> extraTypes = new ArrayList<ExportFileType>();
    private static final Collection<Class<?>> categories;

    static {
        categories = new ArrayList(2);
        categories.add(ExportFileType.class);
        categories.add(RegisterableService.class);
    }

    private ExportFileTypeRegistry() {
    }

    public static synchronized ExportFileTypeRegistry getDefaultInstance(ClassLoader loader) {
        if (loader != null && loader != ExportFileTypeRegistry.loader) {
            if (ExportFileTypeRegistry.loader != null) {
                throw new RuntimeException(String.valueOf(ExportFileTypeRegistry.class.getName()) + ": Different classloader was already used in getDefaultInstance");
            }
            ExportFileTypeRegistry.loader = loader;
        }
        if (registry == null) {
            registry = new ExportFileTypeRegistry();
            ExportFileTypeRegistry.addApplicationClasspathExportFileTypes(registry);
        }
        return registry;
    }

    public List<ExportFileType> get() {
        return this.get(null);
    }

    public List<ExportFileType> get(String format) {
        ArrayList<ExportFileType> export = new ArrayList<ExportFileType>();
        this.addExportFileTypeToList(export, format, this.service.getServiceProviders(ExportFileType.class, true));
        this.addExportFileTypeToList(export, format, this.extraTypes.iterator());
        return export;
    }

    public void add(ExportFileType exportFileType) {
        this.extraTypes.add(exportFileType);
    }

    private void addExportFileTypeToList(List<ExportFileType> list, String format, Iterator<?> iterator) {
        block0: while (iterator.hasNext()) {
            ExportFileType type = (ExportFileType)iterator.next();
            if (format == null) {
                if (list.contains(type)) continue;
                list.add(type);
                continue;
            }
            String[] ext = type.getExtensions();
            int i = 0;
            while (i < ext.length) {
                if (ext[i].equalsIgnoreCase(format)) {
                    if (list.contains(type)) continue block0;
                    list.add(type);
                    continue block0;
                }
                ++i;
            }
        }
    }

    private static void addApplicationClasspathExportFileTypes(ExportFileTypeRegistry registry) {
        ClassLoader classLoader = loader != null ? loader : Thread.currentThread().getContextClassLoader();
        for (Class<?> category : categories) {
            Iterator<Object> providers = Service.providers(category, classLoader).iterator();
            Object previous = null;
            while (providers.hasNext()) {
                Object current = providers.next();
                registry.service.registerServiceProvider(current);
                if (previous != null) {
                    registry.service.setOrdering(category, previous, current);
                }
                previous = current;
            }
        }
    }
}

