/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphics2d.font;

import org.freehep.graphics2d.font.CharTable;
import org.freehep.graphics2d.font.Expert;
import org.freehep.graphics2d.font.ISOLatin;
import org.freehep.graphics2d.font.MACLatin;
import org.freehep.graphics2d.font.PDFLatin;
import org.freehep.graphics2d.font.STDLatin;
import org.freehep.graphics2d.font.Symbol;
import org.freehep.graphics2d.font.WINLatin;
import org.freehep.graphics2d.font.Zapfdingbats;

public class Lookup {
    private static Lookup instance;
    private CharTable[] tables = new CharTable[this.ntables];
    private int ntables = 8;

    public static Lookup getInstance() {
        if (instance == null) {
            instance = new Lookup();
        }
        return instance;
    }

    private Lookup() {
        this.tables[0] = new Symbol();
        this.tables[1] = new Expert();
        this.tables[2] = new Zapfdingbats();
        this.tables[3] = new STDLatin();
        this.tables[4] = new MACLatin();
        this.tables[5] = new WINLatin();
        this.tables[6] = new PDFLatin();
        this.tables[7] = new ISOLatin();
    }

    public char toUnicode(String name) {
        int i = 0;
        while (i < this.ntables) {
            char uc = this.tables[i].toUnicode(name);
            if (uc != '\uffff') {
                return uc;
            }
            ++i;
        }
        return '\uffff';
    }

    public String toName(char uc) {
        int i = 0;
        while (i < this.ntables) {
            String name = this.tables[i].toName(uc);
            if (name != null) {
                return name;
            }
            ++i;
        }
        return null;
    }

    public String toName(Character uc) {
        int i = 0;
        while (i < this.ntables) {
            String name = this.tables[i].toName(uc);
            if (name != null) {
                return name;
            }
            ++i;
        }
        return null;
    }

    public CharTable getTable(String tableName) {
        int i = 0;
        while (i < this.ntables) {
            String tblName = String.valueOf(this.tables[i].getEncoding()) + this.tables[i].getName();
            if (tblName.equalsIgnoreCase(tableName)) {
                return this.tables[i];
            }
            ++i;
        }
        return null;
    }

    public int getNumberOfTables() {
        return this.ntables;
    }

    public String[] getTableNames() {
        String[] tblnames = new String[this.ntables];
        int i = 0;
        while (i < this.ntables) {
            tblnames[i] = String.valueOf(this.tables[i].getEncoding()) + this.tables[i].getName();
            ++i;
        }
        return tblnames;
    }
}

