/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphics2d;

import org.freehep.graphics2d.TagString;

public class TagHandler {
    public String parse(TagString string) {
        String src = string.toString();
        StringBuffer parsedString = new StringBuffer();
        StringBuffer textString = new StringBuffer();
        int i = 0;
        int p = 0;
        try {
            while (i < src.length()) {
                switch (src.charAt(i)) {
                    case '&': {
                        p = ++i;
                        while (src.charAt(i) != ';') {
                            ++i;
                        }
                        String ent = src.substring(p, i);
                        if (ent.equals("amp") || ent.equals("gt") || ent.equals("lt") || ent.equals("quot") || ent.equals("apos")) {
                            textString.append(this.defaultEntity(ent));
                            break;
                        }
                        textString.append(this.entity(ent));
                        break;
                    }
                    case '<': {
                        if (textString.length() > 0) {
                            parsedString.append(this.text(textString.toString()));
                            textString = new StringBuffer();
                        }
                        p = ++i;
                        while (src.charAt(i) != '>') {
                            ++i;
                        }
                        if (src.charAt(p) == '/') {
                            parsedString.append(this.closeTag(src.substring(p + 1, i)));
                            break;
                        }
                        parsedString.append(this.openTag(src.substring(p, i)));
                        break;
                    }
                    default: {
                        textString.append(src.charAt(i));
                    }
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            parsedString.append("!PARSEERROR!");
        }
        if (textString.length() > 0) {
            parsedString.append(this.text(textString.toString()));
        }
        return parsedString.toString();
    }

    protected String defaultEntity(String entity) {
        StringBuffer dst = new StringBuffer();
        if (entity.equals("amp")) {
            dst.append('&');
        } else if (entity.equals("gt")) {
            dst.append('>');
        } else if (entity.equals("lt")) {
            dst.append('<');
        } else if (entity.equals("quot")) {
            dst.append('\"');
        } else if (entity.equals("apos")) {
            dst.append('\'');
        }
        return dst.toString();
    }

    protected String entity(String entity) {
        StringBuffer dst = new StringBuffer();
        dst.append('&');
        dst.append(entity);
        dst.append(';');
        return dst.toString();
    }

    protected String openTag(String tag) {
        StringBuffer dst = new StringBuffer();
        dst.append('<');
        dst.append(tag);
        dst.append('>');
        return dst.toString();
    }

    protected String closeTag(String tag) {
        StringBuffer dst = new StringBuffer();
        dst.append("</");
        dst.append(tag);
        dst.append('>');
        return dst.toString();
    }

    protected String text(String text) {
        return text;
    }

    public static void main(String[] args) {
        String text = "&lt;Vector<sup><b>Graphics</b></sup> &amp; Card<i><sub>Adapter</sub></i>&gt;";
        TagString s = new TagString(text);
        TagHandler handler = new TagHandler();
        System.out.println("\"" + s + "\"");
        System.out.println(handler.parse(s));
    }
}

