/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphics2d;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class SymbolShape
implements Shape {
    private static final double SQRT_2 = Math.sqrt(2.0);
    private static final double SQRT_3 = Math.sqrt(3.0);
    private double[] points;
    private int[] type;
    private ArrayPathIterator pathIterator;
    private double x;
    private double y;
    private double size;
    private int symbol;

    public SymbolShape() {
        this.ensureNumberOfPoints(10);
        this.type[0] = 0;
        int i = 1;
        while (i < this.type.length) {
            this.type[i] = 1;
            ++i;
        }
        this.pathIterator = new ArrayPathIterator(this.points, this.type);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.getBounds2D().contains(x, y);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.contains(x, y) && this.contains(x + w, y) && this.contains(x, y + h) && this.contains(x + w, y + h);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.contains(x, y) || this.contains(x + w, y) || this.contains(x, y + h) || this.contains(x + w, y + h);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.x - this.size / 2.0, this.y - this.size / 2.0, this.size, this.size);
    }

    @Override
    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform t) {
        if (t != null) {
            t.transform(this.points, 0, this.pathIterator.points, 0, this.points.length / 2);
        }
        this.pathIterator.reset();
        return this.pathIterator;
    }

    private void createNew(int n) {
        this.ensureNumberOfPoints(n);
        this.pathIterator.numberOfPoints = n;
        this.pathIterator.done();
    }

    public void create(int symbol, double x, double y, double size) {
        this.symbol = symbol;
        this.x = x;
        this.y = y;
        this.size = size;
        switch (symbol) {
            case 0: {
                this.createVLine(x, y, size);
                break;
            }
            case 1: {
                this.createHLine(x, y, size);
                break;
            }
            case 2: {
                this.createPlus(x, y, size);
                break;
            }
            case 3: {
                this.createCross(x, y, size);
                break;
            }
            case 4: {
                this.createStar(x, y, size);
                break;
            }
            case 6: {
                this.createBox(x, y, size);
                break;
            }
            case 7: {
                this.createUpTriangle(x, y, size);
                break;
            }
            case 8: {
                this.createDownTriangle(x, y, size);
                break;
            }
            case 9: {
                this.createDiamond(x, y, size);
            }
        }
    }

    public String toString() {
        return this.getClass() + ": " + this.symbol + " (" + this.x + ", " + this.y + ") size: " + this.size;
    }

    private void createHLine(double x, double y, double size) {
        this.createNew(2);
        this.type[0] = 0;
        this.points[0] = x - size / 2.0;
        this.points[1] = y;
        this.type[1] = 1;
        this.points[2] = x + size / 2.0;
        this.points[3] = y;
    }

    private void createVLine(double x, double y, double size) {
        this.createNew(2);
        this.type[0] = 0;
        this.points[0] = x;
        this.points[1] = y - size / 2.0;
        this.type[1] = 1;
        this.points[2] = x;
        this.points[3] = y + size / 2.0;
    }

    private void createPlus(double x, double y, double size) {
        this.createNew(4);
        double length = size / 2.0;
        this.type[0] = 0;
        this.points[0] = x + length;
        this.points[1] = y;
        this.type[1] = 1;
        this.points[2] = x - length;
        this.points[3] = y;
        this.type[2] = 0;
        this.points[4] = x;
        this.points[5] = y + length;
        this.type[3] = 1;
        this.points[6] = x;
        this.points[7] = y - length;
    }

    private void createCross(double x, double y, double size) {
        this.createNew(4);
        double side = size / 2.0 / SQRT_2;
        this.type[0] = 0;
        this.points[0] = x - side;
        this.points[1] = y - side;
        this.type[1] = 1;
        this.points[2] = x + side;
        this.points[3] = y + side;
        this.type[2] = 0;
        this.points[4] = x + side;
        this.points[5] = y - side;
        this.type[3] = 1;
        this.points[6] = x - side;
        this.points[7] = y + side;
    }

    private void createStar(double x, double y, double size) {
        this.createNew(8);
        double delta = size / 2.0;
        this.type[0] = 0;
        this.points[0] = x;
        this.points[1] = y - delta;
        this.type[1] = 1;
        this.points[2] = x;
        this.points[3] = y + delta;
        this.type[2] = 0;
        this.points[4] = x - delta;
        this.points[5] = y;
        this.type[3] = 1;
        this.points[6] = x + delta;
        this.points[7] = y;
        delta = size / 2.0 / SQRT_2;
        this.type[4] = 0;
        this.points[8] = x - delta;
        this.points[9] = y - delta;
        this.type[5] = 1;
        this.points[10] = x + delta;
        this.points[11] = y + delta;
        this.type[6] = 0;
        this.points[12] = x + delta;
        this.points[13] = y - delta;
        this.type[7] = 1;
        this.points[14] = x - delta;
        this.points[15] = y + delta;
    }

    private void createUpTriangle(double x, double y, double size) {
        this.createNew(4);
        this.type[0] = 0;
        this.points[0] = x;
        this.points[1] = y - size / SQRT_3;
        this.type[1] = 1;
        this.points[2] = x - size / 2.0;
        this.points[3] = y + (-size / SQRT_3 + size * SQRT_3 / 2.0);
        this.type[2] = 1;
        this.points[4] = x + size / 2.0;
        this.points[5] = y + (-size / SQRT_3 + size * SQRT_3 / 2.0);
        this.type[3] = 4;
    }

    private void createDownTriangle(double x, double y, double size) {
        this.createNew(4);
        this.type[0] = 0;
        this.points[0] = x;
        this.points[1] = y + size / SQRT_3;
        this.type[1] = 1;
        this.points[2] = x - size / 2.0;
        this.points[3] = y - (-size / SQRT_3 + size * SQRT_3 / 2.0);
        this.type[2] = 1;
        this.points[4] = x + size / 2.0;
        this.points[5] = y - (-size / SQRT_3 + size * SQRT_3 / 2.0);
        this.type[3] = 4;
    }

    private void createDiamond(double x, double y, double size) {
        this.createNew(5);
        double length = size / 2.0;
        this.type[0] = 0;
        this.points[0] = x + length;
        this.points[1] = y;
        this.type[1] = 1;
        this.points[2] = x;
        this.points[3] = y + length;
        this.type[2] = 1;
        this.points[4] = x - length;
        this.points[5] = y;
        this.type[3] = 1;
        this.points[6] = x;
        this.points[7] = y - length;
        this.type[4] = 4;
    }

    private void createBox(double x, double y, double size) {
        this.createNew(5);
        double side = size / SQRT_2 / 2.0;
        this.type[0] = 0;
        this.points[0] = x - side;
        this.points[1] = y - side;
        this.type[1] = 1;
        this.points[2] = x + side + 1.0;
        this.points[3] = y - side;
        this.type[2] = 1;
        this.points[4] = x + side + 1.0;
        this.points[5] = y + side + 1.0;
        this.type[3] = 1;
        this.points[6] = x - side;
        this.points[7] = y + side + 1.0;
        this.type[4] = 4;
    }

    private void ensureNumberOfPoints(int n) {
        if (this.type == null || this.type.length < n) {
            this.points = new double[n * 2];
            this.type = new int[n];
        }
    }

    private class ArrayPathIterator
    implements PathIterator {
        private int currentPoint = 0;
        private double[] points;
        private int[] type;
        private int numberOfPoints;

        private ArrayPathIterator(double[] points, int[] type) {
            this.points = points;
            this.type = type;
        }

        @Override
        public boolean isDone() {
            return this.currentPoint >= this.numberOfPoints;
        }

        @Override
        public void next() {
            ++this.currentPoint;
        }

        @Override
        public int currentSegment(double[] coords) {
            coords[0] = this.points[2 * this.currentPoint];
            coords[1] = this.points[2 * this.currentPoint + 1];
            return this.type[this.currentPoint];
        }

        @Override
        public int currentSegment(float[] coords) {
            coords[0] = (float)this.points[2 * this.currentPoint];
            coords[1] = (float)this.points[2 * this.currentPoint + 1];
            return this.type[this.currentPoint];
        }

        @Override
        public int getWindingRule() {
            return 1;
        }

        private void reset() {
            this.currentPoint = 0;
        }

        private void done() {
            this.currentPoint = this.numberOfPoints;
        }
    }
}

