/*
 * Decompiled with CFR 0.152.
 */
package dev.util.prefs;

import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class PreferencesUtil {
    public static Preferences getNode(Preferences aPreferences, String aNode) {
        return PreferencesUtil.getNode(aPreferences, aNode, "[.]");
    }

    public static Preferences getNode(Preferences aPreferences, String aNode, String aDelimiter) {
        Preferences result = aPreferences;
        if (aNode != null) {
            if (aDelimiter == null) {
                result = aPreferences.node(aNode);
            } else {
                String[] nodes = aNode.split(aDelimiter);
                if (nodes.length == 0) {
                    result = aPreferences.node(aNode);
                } else {
                    for (int i = 0; i < nodes.length; ++i) {
                        String node = nodes[i];
                        if ("".equals(node)) continue;
                        result = result.node(node);
                    }
                }
            }
        }
        return result;
    }

    public static void copyNodes(Preferences aSource, Preferences aDesctination, boolean isCopyDescendants) throws BackingStoreException {
        String[] keys = aSource.keys();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            aDesctination.put(key, aSource.get(key, null));
        }
        if (isCopyDescendants) {
            String[] childrenNames = aSource.childrenNames();
            for (int i = 0; i < childrenNames.length; ++i) {
                String childrenName = childrenNames[i];
                PreferencesUtil.copyNodes(aSource.node(childrenName), aDesctination.node(childrenName), true);
            }
        }
    }

    public static void put(Preferences aPrefs, String aName, String aValue) {
        if (aValue != null) {
            aPrefs.put(aName, aValue);
        } else {
            aPrefs.remove(aName);
        }
    }

    public static void toProperties(Preferences aPrefs, Properties aProps) throws BackingStoreException {
        for (String name : aPrefs.keys()) {
            aProps.put(name, aPrefs.get(name, null));
        }
    }

    public static void toPreferences(Properties aProps, Preferences aPrefs) throws BackingStoreException {
        for (Object key : aProps.keySet()) {
            aPrefs.put(key.toString(), aProps.get(key).toString());
        }
    }
}

