/*
 * Decompiled with CFR 0.152.
 */
package dev.util.prefs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class IndexedPreferencesSupport
implements Cloneable {
    protected Preferences fPreferences;
    protected String fIndexName;
    protected String fItemCountPropertyName;
    protected int fIndex;
    protected int fItemCount = 0;

    public int getItemCount() {
        int result = -1;
        result = Integer.parseInt(this.fPreferences.get(this.fItemCountPropertyName, "-1"));
        return result;
    }

    public void setItemCount(int aItemCount) {
        this.putItemCount(aItemCount);
    }

    public int getIndex() {
        return this.fIndex;
    }

    public void setIndex(int aIndex) {
        this.fIndex = aIndex;
    }

    public String getIndexName() {
        return this.fIndexName;
    }

    public void setIndexName(String aIndexName) {
        if (this.fIndexName != aIndexName) {
            this.fIndexName = aIndexName;
            this.fItemCountPropertyName = this.fIndexName + ".count";
            this.setIndex(0);
        }
    }

    protected void putItemCount(int anItemCount) {
        this.fPreferences.put(this.fItemCountPropertyName, String.valueOf(anItemCount));
    }

    public IndexedPreferencesSupport(Preferences aPreferences) {
        this.fPreferences = aPreferences;
    }

    public String getIndexedPropertyName(String aPropertyName) {
        return this.getIndexedPropertyPrefix() + aPropertyName;
    }

    public String getIndexedPropertyPrefix() {
        return this.fIndexName + "[" + this.fIndex + "]" + ".";
    }

    protected Collection getIndexedPropertyNames() throws BackingStoreException {
        ArrayList<String> result = new ArrayList<String>();
        String prefix = this.getIndexedPropertyPrefix();
        String[] keys = this.fPreferences.keys();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (!key.startsWith(prefix)) continue;
            result.add(key);
        }
        return result;
    }

    public String getProperty(String key) {
        return this.fPreferences.get(this.getIndexedPropertyName(key), null);
    }

    public String getProperty(String key, String defaultValue) {
        return this.fPreferences.get(this.getIndexedPropertyName(key), defaultValue);
    }

    public void setProperty(String key, String value) {
        if (value != null) {
            this.fPreferences.put(this.getIndexedPropertyName(key), value);
        } else {
            this.fPreferences.remove(this.getIndexedPropertyName(key));
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

