/*
 * Decompiled with CFR 0.152.
 */
package dev.util.collections;

import dev.util.HashedList;
import dev.util.HashedListStrategy;
import dev.util.collections.BoundList;
import dev.util.collections.ContainedListProvider;
import dev.util.collections.ContainerListener;
import dev.util.collections.ReadOnlyHashedBoundList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class HashedBoundList
extends BoundList
implements HashedList,
ContainerListener {
    public static final long serialVersionUID = -7987271815203275086L;
    protected HashedListStrategy fHashedListStrategy = null;
    protected transient HashMap fElementsHash = new HashMap();
    protected transient ReadOnlyHashedBoundList fReadOnlyHashedBoundList = null;

    public HashMap getElementsHash() {
        if (this.fElementsHash == null) {
            this.fElementsHash = new HashMap();
        }
        return this.fElementsHash;
    }

    public HashedBoundList(List aList, HashedListStrategy aHashedListStrategy) {
        this(aList, aHashedListStrategy, null);
    }

    public HashedBoundList(List aList, HashedListStrategy aHashedListStrategy, ContainerListener aContainerListener) {
        super(aList);
        if (aHashedListStrategy == null) {
            throw new IllegalArgumentException("A hashed list strategy should be specified");
        }
        this.fHashedListStrategy = aHashedListStrategy;
        this.elementsAdded(aList, this);
        this.addContainerListener(this);
        if (aContainerListener != null) {
            this.addContainerListener(aContainerListener);
        }
    }

    public HashedBoundList(ContainedListProvider aProvider, HashedListStrategy aHashedListStrategy) {
        super(aProvider);
        if (aHashedListStrategy == null) {
            throw new IllegalArgumentException("A hashed list strategy should be specified");
        }
        this.fHashedListStrategy = aHashedListStrategy;
        this.elementsAdded(aProvider.getList(), this);
        this.addContainerListener(this);
    }

    public HashedBoundList(HashedListStrategy aHashedListStrategy) {
        this.fHashedListStrategy = aHashedListStrategy;
        if (aHashedListStrategy == null) {
            throw new IllegalArgumentException("A hashed list strategy should be specified");
        }
        this.addContainerListener(this);
    }

    public Object get(Object aKey) {
        HashMap hash = this.getElementsHash();
        if (hash == null || hash.size() != this.getContainedList().size()) {
            this.rebuildHash();
        }
        return hash.get(aKey);
    }

    public HashedListStrategy getHashedListStrategy() {
        return this.fHashedListStrategy;
    }

    public void elementAdded(Object anElement, Object aSource) {
        Object key = this.getHashedListStrategy().getKeyForObject(anElement);
        if (key != null) {
            this.getElementsHash().put(key, anElement);
        }
    }

    public void elementRemoved(Object anElement, Object aSource) {
        this.getElementsHash().remove(this.getHashedListStrategy().getKeyForObject(anElement));
    }

    public void elementsAdded(Collection anElements, Object aSource) {
        for (Object element : anElements) {
            this.getElementsHash().put(this.getHashedListStrategy().getKeyForObject(element), element);
        }
    }

    public void elementsRemoved(Collection anElements, Object aSource) {
        for (Object element : anElements) {
            this.getElementsHash().remove(this.getHashedListStrategy().getKeyForObject(element));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int anIndex, Object anElement) {
        Object result = null;
        Object object = this.fLock;
        synchronized (object) {
            if (!this.fNotifyOnSet) {
                result = this.getContainedList().set(anIndex, anElement);
                this.updateHash(anElement);
            } else {
                super.set(anIndex, anElement);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHash(Object anElement) {
        HashMap hashMap = this.getElementsHash();
        synchronized (hashMap) {
            Iterator iterator = this.getElementsHash().keySet().iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                if (!this.getElementsHash().get(key).equals(anElement)) continue;
                iterator.remove();
                break;
            }
            this.getElementsHash().put(this.getHashedListStrategy().getKeyForObject(anElement), anElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildHash() {
        HashMap hashMap = this.getElementsHash();
        synchronized (hashMap) {
            this.getElementsHash().clear();
            for (Object element : this.getContainedList()) {
                this.getElementsHash().put(this.getHashedListStrategy().getKeyForObject(element), element);
            }
        }
    }

    public boolean contains(Object anElement) {
        return this.getElementsHash().containsKey(this.getHashedListStrategy().getKeyForObject(anElement));
    }

    public boolean containsAll(Collection anElements) {
        if (anElements == null) {
            throw new IllegalArgumentException("Collection should be specified");
        }
        if (!anElements.isEmpty()) {
            Iterator iter = anElements.iterator();
            while (iter.hasNext()) {
                if (this.contains(iter.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ReadOnlyHashedBoundList getReadOnlyHashedBoundList() {
        if (this.fReadOnlyHashedBoundList == null) {
            this.fReadOnlyHashedBoundList = new ReadOnlyHashedBoundList((List)this, this.getHashedListStrategy());
            this.addContainerListener(new ContainerListener(){

                public void elementAdded(Object anElement, Object aSource) {
                    HashedBoundList.this.fReadOnlyHashedBoundList.fireAddElement(anElement);
                }

                public void elementRemoved(Object anElement, Object aSource) {
                    HashedBoundList.this.fReadOnlyHashedBoundList.fireRemoveElement(anElement);
                }

                public void elementsAdded(Collection anElements, Object aSource) {
                    HashedBoundList.this.fReadOnlyHashedBoundList.fireAddElements(anElements);
                }

                public void elementsRemoved(Collection anElements, Object aSource) {
                    HashedBoundList.this.fReadOnlyHashedBoundList.fireRemoveElements(anElements);
                }
            });
        }
        return this.fReadOnlyHashedBoundList;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.addContainerListener(this);
    }

    public static void main(String[] args) {
        HashedBoundList list = new HashedBoundList(new ArrayList(), new HashedListStrategy(){

            public Object getKeyForObject(Object aKey) {
                return aKey.toString();
            }
        });
        System.out.println(list.getReadOnlyHashedBoundList().size());
        list.add("1111111");
        System.out.println(list.getReadOnlyHashedBoundList().size());
    }
}

