/*
 * Decompiled with CFR 0.152.
 */
package dev.util.collections;

import dev.util.collections.ContainedListProvider;
import dev.util.collections.ContainerListener;
import dev.util.collections.ListProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class BoundList
extends ListProxy {
    public static final long serialVersionUID = 3392510652753377744L;
    private transient Vector fListeners = new Vector(2);
    protected Object fEventSource = this;
    protected Object fLock = this;
    protected boolean fNotifyOnSet = true;
    public static final int INITIAL_LISTENERS_COUNT = 2;

    public BoundList(List aList) {
        super(aList);
    }

    public BoundList(List aList, ContainerListener l) {
        this(aList);
        this.addContainerListener(l);
    }

    public BoundList(ContainedListProvider aProvider) {
        super(aProvider);
    }

    public BoundList() {
    }

    public void setLock(Object aLock) {
        if (this.fLock != this) {
            throw new IllegalArgumentException("Lock is already specified");
        }
        this.fLock = aLock;
    }

    public void setEventSource(Object aSource) {
        this.fEventSource = aSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int anIndex, Object anElement) {
        Object object = this.fLock;
        synchronized (object) {
            if (this.beforeAddElement(anElement)) {
                this.getContainedList().add(anIndex, anElement);
                this.fireAddElement(anElement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection anElements) {
        boolean result = false;
        Object object = this.fLock;
        synchronized (object) {
            ArrayList elementsToRemove = new ArrayList();
            for (Object element : anElements) {
                if (this.getContainedList().contains(element)) continue;
                elementsToRemove.add(element);
            }
            if (this.beforeRemoveElements(anElements) && (result = this.getContainedList().retainAll(anElements))) {
                this.fireRemoveElements(elementsToRemove);
            }
        }
        return result;
    }

    public boolean isNotifyOnSet() {
        return this.fNotifyOnSet;
    }

    public void setNotifyOnSet(boolean aNotifyOnSet) {
        this.fNotifyOnSet = aNotifyOnSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int anIndex, Object anElement) {
        Object object = this.fLock;
        synchronized (object) {
            if (this.fNotifyOnSet) {
                Object result = this.getContainedList().get(anIndex);
                if (this.beforeRemoveElement(result) && this.beforeAddElement(anElement)) {
                    this.getContainedList().set(anIndex, anElement);
                    this.fireRemoveElement(result);
                    this.fireAddElement(anElement);
                }
                return result;
            }
            return this.getContainedList().set(anIndex, anElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object anElement) {
        boolean result = false;
        Object object = this.fLock;
        synchronized (object) {
            if (this.beforeAddElement(anElement) && (result = this.getContainedList().add(anElement))) {
                this.fireAddElement(anElement);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection anElements) {
        boolean result = false;
        Object object = this.fLock;
        synchronized (object) {
            if (this.beforeAddElements(anElements) && (result = this.getContainedList().addAll(anElements))) {
                this.fireAddElements(anElements);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveToTail(Object aObject) {
        Object object = this.fLock;
        synchronized (object) {
            int index = this.getContainedList().indexOf(aObject);
            if (index != -1) {
                this.getContainedList().remove(index);
                this.getContainedList().add(aObject);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveToHead(Object aObject) {
        Object object = this.fLock;
        synchronized (object) {
            List containedList = this.getContainedList();
            int index = containedList.indexOf(aObject);
            if (index != -1) {
                containedList.remove(index);
                containedList.add(0, aObject);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection anElements) {
        boolean result = false;
        Object object = this.fLock;
        synchronized (object) {
            if (this.beforeRemoveElements(anElements) && (result = this.getContainedList().removeAll(anElements))) {
                this.fireRemoveElements(anElements);
            }
        }
        return result;
    }

    public void clear() {
        this.removeAll((Collection)new ArrayList(this.getContainedList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int anIndex, Collection anElements) {
        boolean result = false;
        Object object = this.fLock;
        synchronized (object) {
            if (this.beforeAddElements(anElements) && (result = this.getContainedList().addAll(anElements))) {
                this.fireAddElements(anElements);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object anElement) {
        boolean result = false;
        Object object = this.fLock;
        synchronized (object) {
            if (this.beforeRemoveElement(anElement) && (result = this.getContainedList().remove(anElement))) {
                this.fireRemoveElement(anElement);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int anIndex) {
        Object result = null;
        Object object = this.fLock;
        synchronized (object) {
            if (this.beforeRemoveElement(this.getContainedList().get(anIndex))) {
                result = this.getContainedList().remove(anIndex);
                this.fireRemoveElement(result);
            }
        }
        return result;
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public ListIterator listIterator() {
        return new BoundListIterator(this, 0);
    }

    public ListIterator listIterator(int parm1) {
        return new BoundListIterator(this, parm1);
    }

    protected boolean beforeAddElement(Object anElement) {
        return true;
    }

    protected boolean beforeRemoveElement(Object anElement) {
        return true;
    }

    protected boolean beforeAddElements(Collection anElements) {
        return true;
    }

    protected boolean beforeRemoveElements(Collection anElements) {
        return true;
    }

    public synchronized void addContainerListener(ContainerListener aListener) {
        if (this.fListeners == null) {
            this.fListeners = new Vector(2);
        }
        this.fListeners.add(aListener);
    }

    public synchronized void removeContainerListener(ContainerListener aListener) {
        if (this.fListeners == null) {
            return;
        }
        this.fListeners.remove(aListener);
    }

    protected void fireAddElement(Object aElement) {
        if (this.fListeners == null) {
            return;
        }
        int listenersSize = this.fListeners.size();
        for (int i = 0; i < listenersSize; ++i) {
            ContainerListener listener = (ContainerListener)this.fListeners.get(i);
            if (listener == null) continue;
            listener.elementAdded(aElement, this.fEventSource);
        }
    }

    protected void fireRemoveElement(Object aElement) {
        if (this.fListeners == null) {
            return;
        }
        int listenersSize = this.fListeners.size();
        for (int i = 0; i < listenersSize; ++i) {
            ContainerListener listener = (ContainerListener)this.fListeners.get(i);
            if (listener == null) continue;
            listener.elementRemoved(aElement, this.fEventSource);
        }
    }

    protected void fireAddElements(Collection anElements) {
        if (this.fListeners == null) {
            return;
        }
        int listenersSize = this.fListeners.size();
        for (int i = 0; i < listenersSize; ++i) {
            ContainerListener listener = (ContainerListener)this.fListeners.get(i);
            if (listener == null) continue;
            listener.elementsAdded(anElements, this.fEventSource);
        }
    }

    protected void fireRemoveElements(Collection anElements) {
        if (this.fListeners == null) {
            return;
        }
        int listenersSize = this.fListeners.size();
        for (int i = 0; i < listenersSize; ++i) {
            ContainerListener listener = (ContainerListener)this.fListeners.get(i);
            if (listener == null) continue;
            listener.elementsRemoved(anElements, this.fEventSource);
        }
    }

    class BoundListIterator
    implements ListIterator {
        private int fIndex = 0;
        private BoundList fList = null;

        public BoundListIterator(BoundList aList, int aInitialIndex) {
            this.fIndex = aInitialIndex;
            this.fList = aList;
        }

        public void add(Object obj) {
            this.fList.add(obj);
        }

        public boolean hasNext() {
            return this.fIndex <= this.fList.size() - 1;
        }

        public boolean hasPrevious() {
            return this.fIndex > 0;
        }

        public Object next() {
            Object result = this.fList.get(this.fIndex);
            ++this.fIndex;
            return result;
        }

        public int nextIndex() {
            if (this.fIndex == this.fList.size()) {
                return this.fIndex;
            }
            return this.fIndex + 1;
        }

        public Object previous() {
            --this.fIndex;
            Object result = this.fList.get(this.fIndex);
            return result;
        }

        public int previousIndex() {
            int result = this.fIndex - 1;
            if (result < 0) {
                result = -1;
            }
            return result;
        }

        public void remove() {
            this.fList.remove(this.fIndex - 1);
        }

        public void set(Object obj) {
            this.fList.set(this.fIndex, obj);
        }
    }
}

