/*
 * Decompiled with CFR 0.152.
 */
package dev.util;

import dev.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;

public class VersionSupport {
    protected String fVersion;
    protected String fSubVersion;
    protected Properties fProperties;
    public static final String PROPERTY_BUILD_NUMBER = "build_number";
    public static final String PROPERTY_BUILD_DATE = "build_date";
    static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(3, 3);

    public VersionSupport(String aVersion, String aSubVersion) {
        this.fVersion = aVersion;
        this.fSubVersion = aSubVersion;
    }

    public String getVersion() {
        String result = this.fVersion;
        if (!StringUtils.noValue(this.fSubVersion)) {
            result = result + " " + this.fSubVersion;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties() {
        if (this.fProperties == null) {
            this.fProperties = new Properties();
            try {
                InputStream in = this.getClass().getResourceAsStream("Version.properties");
                try {
                    this.fProperties.load(in);
                }
                finally {
                    in.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fProperties;
    }

    public void printVersion() {
        String build_date;
        System.out.println("Version:      " + this.getVersion());
        Properties props = this.getProperties();
        String build_number = props.getProperty(PROPERTY_BUILD_NUMBER);
        if (build_number != null) {
            System.out.println("Build Number: " + build_number);
        }
        if ((build_date = props.getProperty(PROPERTY_BUILD_DATE)) != null) {
            System.out.println("Build Date:   " + build_date);
        }
    }

    public String getFullVersion() {
        return this.getVersion() + this.getBuildVersion();
    }

    public String getBuildVersion() {
        String result = "";
        Properties props = this.getProperties();
        String build_number = props.getProperty(PROPERTY_BUILD_NUMBER, "n/a");
        result = result + " (" + build_number;
        String build_date = props.getProperty(PROPERTY_BUILD_DATE, "n/a");
        result = result + ", " + build_date + ")";
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateVersionProperties(String aFileName) throws FileNotFoundException, IOException {
        Properties props;
        String build_number = "0";
        File file = new File(aFileName);
        if (file.canRead()) {
            try {
                FileInputStream in = new FileInputStream(file);
                try {
                    props = new Properties();
                    props.load(in);
                    build_number = props.getProperty(PROPERTY_BUILD_NUMBER, "0");
                }
                finally {
                    ((InputStream)in).close();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        FileOutputStream out = new FileOutputStream(file);
        try {
            props = new Properties();
            int int_build_number = 0;
            try {
                int_build_number = Integer.parseInt(build_number);
            }
            catch (Exception ex) {
                // empty catch block
            }
            props.put(PROPERTY_BUILD_NUMBER, String.valueOf(int_build_number + 1));
            props.put(PROPERTY_BUILD_DATE, DATE_FORMAT.format(new Date()));
            props.store(out, null);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Version file name should be specified.");
        } else {
            try {
                VersionSupport.updateVersionProperties(args[0]);
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        }
    }
}

