/*
 * Decompiled with CFR 0.152.
 */
package dev.util;

import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static final String MACRO_START = "${";
    public static final String MACRO_END = "}";
    protected static Pattern HTML_CLEANUP_PATTERN;
    protected static Pattern HTML_A_TAGS_PATTERN;
    protected static Pattern HTML_REMOVE_START_END_TAGS;
    public static final String BYTE_DELIMITER = ",";
    public static final String OBJECT_DELIMITER = ",";

    public static String trim(String aString, int aMaxLength) {
        return aString == null || aString.length() <= aMaxLength ? aString : aString.substring(0, aMaxLength);
    }

    public static boolean noValue(String aString) {
        return aString == null || "".equals(aString.trim());
    }

    public static boolean equalsIgnoreEmpty(String aFirst, String aSecond) {
        return StringUtils.equals("".equals(aFirst) ? null : aFirst, "".equals(aSecond) ? null : aSecond);
    }

    public static boolean equals(String aFirst, String aSecond) {
        if (aFirst == null && aSecond == null) {
            return true;
        }
        return aFirst != null ? aFirst.equals(aSecond) : aSecond.equals(aFirst);
    }

    public static boolean equalsIgnoreCase(String aFirst, String aSecond) {
        if (aFirst == null && aSecond == null) {
            return true;
        }
        return aFirst != null ? aFirst.equalsIgnoreCase(aSecond) : aSecond.equalsIgnoreCase(aFirst);
    }

    public static String[] parseString(String aValue, char aDelimiter) {
        if (aValue != null && aValue.length() > 0) {
            char[] chars = aValue.toCharArray();
            int count = 0;
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] != aDelimiter) continue;
                ++count;
            }
            if (count > 0) {
                String[] result = new String[count + 1];
                int arrayInd = 0;
                int start = 0;
                while (true) {
                    int ind;
                    if ((ind = aValue.indexOf(aDelimiter, start)) < 0) break;
                    result[arrayInd++] = aValue.substring(start, ind).trim();
                    start = ind + 1;
                }
                result[arrayInd] = aValue.substring(start).trim();
                return result;
            }
            return new String[]{aValue};
        }
        return null;
    }

    public static String trimLeading(String aString) {
        int st;
        int len = aString.length();
        int off = 0;
        char[] val = aString.toCharArray();
        for (st = 0; st < len && val[off + st] <= ' '; ++st) {
        }
        return st > 0 ? aString.substring(st, len) : aString;
    }

    public static String trimTrailing(String aString) {
        int len;
        int st = 0;
        int off = 0;
        char[] val = aString.toCharArray();
        for (len = aString.length(); st < len && val[off + len - 1] <= ' '; --len) {
        }
        return aString.substring(st, len);
    }

    public static String removeNotSymbols(String aString) {
        char[] val = aString.toCharArray();
        String result = "";
        for (int i = 0; i < val.length; ++i) {
            if (Character.isISOControl(val[i])) continue;
            result = result + val[i];
        }
        return result.trim();
    }

    public static int indexOf(char[] aSrc, char[] aSearch, int aFromIndex) {
        if (aFromIndex >= aSrc.length) {
            if (aSrc.length == 0 && aFromIndex == 0 && aSearch.length == 0) {
                return 0;
            }
            return -1;
        }
        if (aFromIndex < 0) {
            aFromIndex = 0;
        }
        if (aSearch.length == 0) {
            return aFromIndex;
        }
        int max = aSrc.length - aSearch.length;
        int strOffset = 0;
        char first = aSearch[strOffset];
        int i = aFromIndex;
        block0: while (true) {
            if (i <= max && aSrc[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + aSearch.length - 1;
            int k = strOffset + 1;
            while (j < end) {
                if (aSrc[j++] == aSearch[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int indexOf(char[] aSrc, char[] aSearch) {
        return StringUtils.indexOf(aSrc, aSearch, 0);
    }

    public static int indexOf(char[] aSrc, String aSearch, int aFromIndex) {
        return StringUtils.indexOf(aSrc, aSearch.toCharArray(), aFromIndex);
    }

    public static int indexOf(char[] aSrc, String aSearch) {
        return StringUtils.indexOf(aSrc, aSearch, 0);
    }

    public static Pattern getLikePattern(String aPattern) {
        StringBuffer pattern = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(aPattern, "?*", true);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            if (token.equals("?")) {
                pattern.append(".");
                continue;
            }
            if (token.equals("*")) {
                pattern.append(".*");
                continue;
            }
            pattern.append("\\Q");
            pattern.append(token);
            pattern.append("\\E");
        }
        return Pattern.compile(pattern.toString());
    }

    public static boolean like(String aString, String aPattern) {
        if (aString != null) {
            Matcher matcher = StringUtils.getLikePattern(aPattern).matcher(aString);
            return matcher.matches();
        }
        return false;
    }

    public static boolean likeIgnoreCase(String aString, String aPattern) {
        if (aString != null) {
            Matcher matcher = StringUtils.getLikePattern(aPattern.toLowerCase()).matcher(aString.toLowerCase());
            return matcher.matches();
        }
        return false;
    }

    public static String expandMacro(String aMacro, Map aContext) {
        return StringUtils.expandMacro(aMacro, aContext, true);
    }

    public static String[] toMacro(String[] aValues) {
        for (int i = 0; aValues != null && i < aValues.length; ++i) {
            aValues[i] = MACRO_START + aValues[i] + MACRO_END;
        }
        return aValues;
    }

    public static String expandMacro(String aMacro, Map aContext, boolean isAllowNull) {
        return StringUtils.expandMacro(aMacro, aContext, true, new Stack());
    }

    protected static String expandMacro(String aMacro, Map aContext, boolean isAllowNull, Stack aCallStack) {
        StringBuffer result = new StringBuffer();
        boolean macroStarted = false;
        int macroStartIndex = -1;
        char[] chars = aMacro.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            result.append(c);
            if (c == MACRO_START.charAt(0)) {
                if (i >= chars.length - 2 || chars[i + 1] != MACRO_START.charAt(1)) continue;
                macroStarted = true;
                macroStartIndex = i;
                continue;
            }
            if (c != MACRO_END.charAt(0) || !macroStarted) continue;
            String macro = aMacro.substring(macroStartIndex, i + 1);
            String value = StringUtils.getMacroValue(macro.substring(MACRO_START.length(), macro.length() - MACRO_END.length()), aContext, isAllowNull, aCallStack);
            if (value == null) {
                if (isAllowNull) {
                    value = "";
                } else {
                    throw new IllegalStateException("No macro variable found: " + macro);
                }
            }
            result.replace(result.length() - macro.length(), result.length(), value);
            macroStarted = false;
            macroStartIndex = -1;
        }
        return result.toString();
    }

    protected static String getMacroValue(String aName, Map aContext, boolean isAllowNull, Stack aCallStack) {
        if (aCallStack.contains(aName)) {
            throw new IllegalStateException("Circular reference occured for macro variable: " + aName);
        }
        String result = (String)aContext.get(aName);
        if (result != null) {
            aCallStack.push(aName);
            String expanded = StringUtils.expandMacro(result, aContext, isAllowNull, aCallStack);
            aCallStack.pop();
            while (!result.equals(expanded)) {
                result = expanded;
                aCallStack.push(aName);
                expanded = StringUtils.expandMacro(result, aContext, isAllowNull, aCallStack);
                aCallStack.pop();
            }
        }
        return result;
    }

    public static String cleanupHTML(String aValue) {
        Matcher regexMatcher = HTML_CLEANUP_PATTERN.matcher(aValue);
        return regexMatcher.replaceAll("");
    }

    public static String removeHTMLATags(String aValue) {
        Matcher regexMatcher = HTML_A_TAGS_PATTERN.matcher(aValue);
        return regexMatcher.replaceAll("");
    }

    public static String removeHTMLStartEndTags(String aValue) {
        Matcher regexMatcher = HTML_REMOVE_START_END_TAGS.matcher(aValue);
        return regexMatcher.replaceAll("$1");
    }

    public static String toString(byte[] aBytes) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < aBytes.length; ++i) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(aBytes[i]);
        }
        return result.toString();
    }

    public static byte[] toBytes(String aBytes) {
        String[] bytes = aBytes.split(",");
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = Byte.parseByte(bytes[i].trim());
        }
        return result;
    }

    public static String toString(Object[] anObjects) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < anObjects.length; ++i) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(anObjects != null ? anObjects[i].toString() : "");
        }
        return result.toString();
    }

    public static String toHex(String aText) {
        StringBuffer result = new StringBuffer();
        char[] chars = aText.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (new Integer(chars[i]) > 255) {
                result.append("\\u" + Integer.toHexString(chars[i]));
                continue;
            }
            result.append(chars[i]);
        }
        return result.toString();
    }

    static {
        try {
            HTML_CLEANUP_PATTERN = Pattern.compile("</?[a-z][a-z0-9]*[^<>]*>", 66);
            HTML_A_TAGS_PATTERN = Pattern.compile("</?[a][a]*[^<>]*>", 66);
            HTML_REMOVE_START_END_TAGS = Pattern.compile("<HTML[^>]*>(.*?)</HTML>", 98);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

