/*
 * Decompiled with CFR 0.152.
 */
package dev.util;

import dev.util.StringUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class StringConverter {
    static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance();
    static final NumberFormat CURRENCY_FORMAT = NumberFormat.getCurrencyInstance();
    static final NumberFormat PERCENT_FORMAT = NumberFormat.getPercentInstance();
    static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(3);
    static final DateFormat DATE_TIME_FORMAT = DateFormat.getDateInstance(3);
    static final Map VALUE_CONVERTERS = new HashMap();
    static final String DELIMITER = ",";
    public static final String BYTE_DELIMITER = ",";
    public static final String LONG_DELIMITER = ",";

    public static void addValueConverter(Class aClassFrom, Class aClassTo, ValueConverter aConverter) {
        VALUE_CONVERTERS.put(aClassFrom.getName() + aClassTo.getName(), aConverter);
    }

    public static Object convert(Class aClassFrom, Class aClassTo, Object aValue) {
        Object value = aValue;
        ValueConverter converter = StringConverter.getConverter(aClassFrom, aClassTo);
        if (converter != null) {
            value = converter.convert(aValue);
        } else if (aClassTo.equals(String.class)) {
            value = aValue.toString();
        }
        return value;
    }

    public static ValueConverter getConverter(Class aClassFrom, Class aClassTo) {
        return (ValueConverter)VALUE_CONVERTERS.get(aClassFrom.getName() + aClassTo.getName());
    }

    public static int toInt(String aValue) throws ParseException {
        int result;
        try {
            result = Integer.parseInt(aValue);
        }
        catch (NumberFormatException ex) {
            result = NUMBER_FORMAT.parse(aValue).intValue();
        }
        return result;
    }

    public static long toLong(String aValue) throws ParseException {
        long result;
        try {
            result = Long.parseLong(aValue);
        }
        catch (NumberFormatException ex) {
            result = NUMBER_FORMAT.parse(aValue).longValue();
        }
        return result;
    }

    public static float toFloat(String aValue) throws ParseException {
        float result;
        try {
            result = Float.parseFloat(aValue);
        }
        catch (NumberFormatException ex) {
            result = NUMBER_FORMAT.parse(aValue).floatValue();
        }
        return result;
    }

    public static long toCurrency(String aValue) throws ParseException {
        long result;
        try {
            result = (long)(NUMBER_FORMAT.parse(aValue).floatValue() * 100.0f);
        }
        catch (ParseException ex) {
            result = (long)(CURRENCY_FORMAT.parse(aValue).floatValue() * 100.0f);
        }
        return result;
    }

    public static double toDouble(String aValue) throws ParseException {
        double result;
        try {
            result = NUMBER_FORMAT.parse(aValue).doubleValue();
        }
        catch (ParseException ex) {
            try {
                result = CURRENCY_FORMAT.parse(aValue).doubleValue();
            }
            catch (Exception ex2) {
                result = PERCENT_FORMAT.parse(aValue).doubleValue();
            }
        }
        return result;
    }

    public static Date toDate(String aValue) throws ParseException {
        Date result;
        try {
            result = DATE_FORMAT.parse(aValue);
        }
        catch (ParseException ex) {
            result = DATE_TIME_FORMAT.parse(aValue);
        }
        return result;
    }

    public static Color toColor(String aColor) {
        return new Color(Integer.parseInt(aColor));
    }

    public static String fromColor(Color aColor) {
        return String.valueOf(aColor.getRGB());
    }

    public static Rectangle toRectangle(String aRectangle) {
        int[] props = new int[4];
        int i = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(aRectangle, ",");
        while (stringTokenizer.hasMoreTokens() && i < 4) {
            props[i++] = Integer.parseInt(stringTokenizer.nextToken());
        }
        return new Rectangle(props[0], props[1], props[2], props[3]);
    }

    public static String fromRectangle(Rectangle aRectangle) {
        StringBuffer result = new StringBuffer();
        result.append(aRectangle.x);
        result.append(",");
        result.append(aRectangle.y);
        result.append(",");
        result.append(aRectangle.width);
        result.append(",");
        result.append(aRectangle.height);
        return result.toString();
    }

    public static Dimension toDimension(String aDimension) {
        int[] props = new int[2];
        int i = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(aDimension, ",");
        while (stringTokenizer.hasMoreTokens() && i < 2) {
            props[i++] = Integer.parseInt(stringTokenizer.nextToken());
        }
        return new Dimension(props[0], props[1]);
    }

    public static String fromDimension(Dimension aDimension) {
        StringBuffer result = new StringBuffer();
        result.append(aDimension.width);
        result.append(",");
        result.append(aDimension.height);
        return result.toString();
    }

    public static Point toPoint(String aPoint) {
        int[] props = new int[2];
        int i = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(aPoint, ",");
        while (stringTokenizer.hasMoreTokens() && i < 2) {
            props[i++] = Integer.parseInt(stringTokenizer.nextToken());
        }
        return new Point(props[0], props[1]);
    }

    public static String fromPoint(Point aPoint) {
        StringBuffer result = new StringBuffer();
        result.append(aPoint.x);
        result.append(",");
        result.append(aPoint.y);
        return result.toString();
    }

    public static String toString(byte[] aBytes) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < aBytes.length; ++i) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(aBytes[i]);
        }
        return result.toString();
    }

    public static byte[] toBytes(String aBytes) {
        String[] bytes = aBytes.split(",");
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = Byte.parseByte(bytes[i].trim());
        }
        return result;
    }

    public static String toString(long[] aLongs) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < aLongs.length; ++i) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(aLongs[i]);
        }
        return result.toString();
    }

    public static long[] toLongs(String aLongs) {
        String[] longs = aLongs.split(",");
        long[] result = new long[longs.length];
        for (int i = 0; i < longs.length; ++i) {
            result[i] = Long.parseLong(longs[i].trim());
        }
        return result;
    }

    static {
        StringConverter.addValueConverter(String.class, Double.class, new StringToDoubleConverter());
        StringConverter.addValueConverter(String.class, Long.class, new StringToLongConverter());
        StringConverter.addValueConverter(String.class, Integer.class, new StringToIntegerConverter());
        StringConverter.addValueConverter(String.class, Date.class, new StringToDateConverter());
    }

    public static class StringToDateConverter
    implements ValueConverter {
        public Object convert(Object aValue) {
            Date result = null;
            try {
                result = StringConverter.toDate(StringUtils.removeNotSymbols(aValue.toString()));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return result;
        }
    }

    public static class StringToIntegerConverter
    implements ValueConverter {
        public Object convert(Object aValue) {
            Integer result = null;
            try {
                result = new Integer(new Double(StringConverter.toDouble(StringUtils.removeNotSymbols(aValue.toString()))).intValue());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return result;
        }
    }

    public static class StringToLongConverter
    implements ValueConverter {
        public Object convert(Object aValue) {
            Long result = null;
            try {
                result = new Long(new Double(StringConverter.toDouble(StringUtils.removeNotSymbols(aValue.toString()))).longValue());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return result;
        }
    }

    public static class StringToDoubleConverter
    implements ValueConverter {
        public Object convert(Object aValue) {
            Double result = null;
            try {
                result = new Double(StringConverter.toDouble(StringUtils.removeNotSymbols(aValue.toString())));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return result;
        }
    }

    public static interface ValueConverter {
        public Object convert(Object var1);
    }
}

