/*
 * Decompiled with CFR 0.152.
 */
package dev.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.crypto.Cipher;

public final class StreamUtil {
    private static final int MAX_SIZE = 65536;
    private static final int SIZE = 4096;

    public static byte[] readA(InputStream aInputStream) throws IOException {
        ArrayList<byte[]> bufferList = new ArrayList<byte[]>();
        PushbackInputStream bStream = new PushbackInputStream(aInputStream);
        byte[] result = null;
        int size = 0;
        while (true) {
            int available;
            if ((available = bStream.available()) > 0) {
                if (available > 65536) {
                    available = 65536;
                }
                size += available;
                byte[] buffer = new byte[available];
                bStream.read(buffer);
                bufferList.add(buffer);
                continue;
            }
            int count = bStream.read();
            if (count < 0) break;
            bStream.unread(count);
        }
        result = new byte[size];
        Iterator iterator = bufferList.iterator();
        size = 0;
        while (iterator.hasNext()) {
            byte[] buffer = (byte[])iterator.next();
            System.arraycopy(buffer, 0, result, size, buffer.length);
            size += buffer.length;
        }
        return result;
    }

    public static char[] readB(Reader aReader) throws IOException {
        int count;
        char[] tmpBuffer = new char[4096];
        int size = 4096;
        int pos = 0;
        while ((count = aReader.read(tmpBuffer, pos, size - pos)) >= 0) {
            if ((pos += count) != size) continue;
            int newSize = size <= 8192 ? size << 1 : size + 4096;
            char[] newBuffer = new char[newSize];
            System.arraycopy(tmpBuffer, 0, newBuffer, 0, size);
            size = newSize;
            tmpBuffer = newBuffer;
        }
        char[] result = new char[pos];
        System.arraycopy(tmpBuffer, 0, result, 0, pos);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(File aFile) throws IOException {
        FileInputStream in = new FileInputStream(aFile);
        try {
            byte[] byArray = StreamUtil.readB(in);
            return byArray;
        }
        finally {
            in.close();
        }
    }

    public static byte[] readB(InputStream aInputStream) throws IOException {
        int count;
        byte[] tmpBuffer = new byte[4096];
        int size = 4096;
        int pos = 0;
        while ((count = aInputStream.read(tmpBuffer, pos, size - pos)) >= 0) {
            if ((pos += count) != size) continue;
            int newSize = size <= 8192 ? size << 1 : size + 4096;
            byte[] newBuffer = new byte[newSize];
            System.arraycopy(tmpBuffer, 0, newBuffer, 0, size);
            size = newSize;
            tmpBuffer = newBuffer;
        }
        byte[] result = new byte[pos];
        System.arraycopy(tmpBuffer, 0, result, 0, pos);
        return result;
    }

    public static void copy(InputStream aInput, OutputStream aOutput) throws IOException {
        int count;
        byte[] buffer = new byte[4096];
        while ((count = aInput.read(buffer)) >= 0) {
            aOutput.write(buffer, 0, count);
        }
    }

    public static void copySafe(InputStream aInput, OutputStream aOutput) throws IOException {
        aOutput.write(StreamUtil.readB(aInput));
    }

    public static void copy(InputStream aInput, Writer aOutput) throws IOException {
        int count;
        InputStreamReader reader = new InputStreamReader(aInput);
        char[] buffer = new char[4096];
        while ((count = reader.read(buffer)) >= 0) {
            aOutput.write(buffer, 0, count);
        }
    }

    public static byte[] loadResource(String aURL) {
        byte[] result = null;
        try {
            InputStream input = String.class.getResourceAsStream(aURL);
            result = StreamUtil.readB(input);
        }
        catch (Exception ex) {
            System.err.println("Can't load resource " + aURL);
        }
        return result;
    }

    public static String loadText(String aResourceName) {
        return StreamUtil.loadText(aResourceName, String.class);
    }

    public static String loadText(String aResourceName, Class aBaseClass) {
        String result = null;
        try {
            InputStream inputStream = aBaseClass.getResourceAsStream(aResourceName);
            result = StreamUtil.loadText(inputStream);
        }
        catch (Exception ex) {
            System.err.println("Can't load resource " + aResourceName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadText(InputStream anInputStream) {
        StringBuffer result = new StringBuffer();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(anInputStream));
            try {
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    result.append(line);
                    result.append("\n");
                }
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result.toString();
    }

    public static byte[] loadByteArray(ObjectInputStream anInputStream) throws IOException {
        int length = anInputStream.readInt();
        byte[] result = length > 0 ? new byte[length] : null;
        for (int i = 0; result != null && i < result.length; ++i) {
            result[i] = anInputStream.readByte();
        }
        return result;
    }

    public static void storeByteArray(ObjectOutputStream anOutputStream, byte[] anBytes) throws IOException {
        anOutputStream.writeInt(anBytes != null ? anBytes.length : 0);
        for (int i = 0; anBytes != null && i < anBytes.length; ++i) {
            anOutputStream.writeByte(anBytes[i]);
        }
    }

    public static InputStream getDecryptedInputStream(InputStream anInputStream, Cipher aCipher) throws IOException {
        byte[] bytes = StreamUtil.readB(anInputStream);
        try {
            bytes = aCipher.doFinal(bytes);
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
        return new ByteArrayInputStream(bytes);
    }

    public static OutputStream getEncryptedOutputStream(final OutputStream anOutputStream, final Cipher aCipher) {
        OutputStream result = anOutputStream;
        if (aCipher != null) {
            result = new ByteArrayOutputStream(){

                public void close() throws IOException {
                    super.close();
                    try {
                        anOutputStream.write(aCipher.doFinal(this.toByteArray()));
                    }
                    catch (Exception ex) {
                        throw new IOException(ex.getMessage());
                    }
                }
            };
        }
        return result;
    }
}

