/*
 * Decompiled with CFR 0.152.
 */
package dev.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class HashDualMap
extends HashMap {
    private HashMap fHashMap_ValueKey;

    public HashDualMap() {
        this.fHashMap_ValueKey = new HashMap();
    }

    public HashDualMap(int aInitialCapacity) {
        super(aInitialCapacity);
        this.fHashMap_ValueKey = new HashMap(aInitialCapacity);
    }

    public HashDualMap(int aInitialCapacity, float aLoadFactor) {
        super(aInitialCapacity, aLoadFactor);
        this.fHashMap_ValueKey = new HashMap(aInitialCapacity, aLoadFactor);
    }

    public HashDualMap(Map aMap) {
        super(aMap.size());
        this.fHashMap_ValueKey = new HashMap(aMap.size());
        this.putAll(aMap);
    }

    public void clear() {
        super.clear();
        this.fHashMap_ValueKey.clear();
    }

    public Object put(Object aKey, Object aValue) {
        if (aKey == null || aValue == null) {
            throw new IllegalArgumentException("Null values are not supported.");
        }
        this.fHashMap_ValueKey.put(aValue, aKey);
        return super.put(aKey, aValue);
    }

    public void putAll(Map aMap) {
        super.putAll(aMap);
        for (Object key : aMap.keySet()) {
            Object value = aMap.get(key);
            this.fHashMap_ValueKey.put(value, key);
        }
    }

    public Object remove(Object aKey) {
        if (aKey == null) {
            throw new IllegalArgumentException("Key can't be null");
        }
        Object value = this.getValue(aKey);
        this.fHashMap_ValueKey.remove(value);
        return super.remove(aKey);
    }

    public Object removeByValue(Object aValue) {
        if (aValue == null) {
            throw new IllegalArgumentException("Value can't be null");
        }
        Object key = this.getKey(aValue);
        super.remove(key);
        return this.fHashMap_ValueKey.remove(aValue);
    }

    public Object getValue(Object aKey) {
        return super.get(aKey);
    }

    public Object getKey(Object aValue) {
        return this.fHashMap_ValueKey.get(aValue);
    }

    public Set valueSet() {
        return this.fHashMap_ValueKey.keySet();
    }

    public Iterator keyIterator() {
        return this.keySet().iterator();
    }

    public Iterator valueIterator() {
        return this.valueSet().iterator();
    }

    public Object clone() {
        return new HashDualMap((Map)((HashMap)super.clone()));
    }
}

