/*
 * Decompiled with CFR 0.152.
 */
package dev.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;

public class CalendarUtil {
    public static final int FIRST_DAY_OF_WEEK = Calendar.getInstance().getFirstDayOfWeek();
    public static final DateFormat DATE_TIME_FORMAT = DateFormat.getDateTimeInstance(3, 3);
    public static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(3);
    public static final DateFormat TIME_FORMAT = DateFormat.getTimeInstance(3);
    protected static HashMap fMonthNamesMap = new HashMap();
    protected static HashMap fWeekNamesMap = new HashMap();
    protected static HashMap fWeekDaysMap = new HashMap();
    public static final long MILLISECONDS_PER_DAY = 86400000L;
    public static final long MILLISECONDS_PER_HOUR = 3600000L;
    public static final long MILLISECONDS_PER_MIN = 60000L;
    public static final long MILLISECONDS_PER_SEC = 1000L;
    public static final MessageFormat FORMAT_SEC = new MessageFormat("{0} sec.");
    public static final MessageFormat FORMAT_MIN_SEC = new MessageFormat("{0} min. {1} sec.");
    public static final MessageFormat FORMAT_HOUR_MIN = new MessageFormat("{0} hrs. {1} min.");
    public static final MessageFormat FORMAT_DAYS_HOUR_MIN = new MessageFormat("{0} days {1} hrs. {2} min.");

    public static String getMonthName(int aMonth) {
        return CalendarUtil.getMonthName(aMonth, Locale.getDefault());
    }

    public static String getMonthName(int aMonth, Locale aLocale) {
        String[] monthNames = (String[])fMonthNamesMap.get(aLocale);
        if (monthNames == null) {
            monthNames = new String[12];
            fMonthNamesMap.put(aLocale, monthNames);
            SimpleDateFormat monthFormat = new SimpleDateFormat("MMMM", aLocale);
            Calendar calendar = Calendar.getInstance(aLocale);
            StringBuffer stringBuffer = new StringBuffer();
            FieldPosition fieldPosition = new FieldPosition(0);
            for (int i = 0; i < 12; ++i) {
                stringBuffer.setLength(0);
                calendar.set(2, i);
                calendar.set(5, 1);
                monthFormat.format(calendar.getTime(), stringBuffer, fieldPosition);
                monthNames[i] = stringBuffer.toString();
            }
        }
        return monthNames[aMonth];
    }

    public static String getWeekName(int aWeek) {
        return CalendarUtil.getWeekName(aWeek, Locale.getDefault());
    }

    public static String getWeekName(int aWeek, Locale aLocale) {
        String[] weekNames = (String[])fWeekNamesMap.get(aLocale);
        if (weekNames == null) {
            weekNames = new String[8];
            fWeekNamesMap.put(aLocale, weekNames);
            SimpleDateFormat weekFormat = new SimpleDateFormat("EEEE", aLocale);
            Calendar calendar = Calendar.getInstance(aLocale);
            StringBuffer stringBuffer = new StringBuffer();
            FieldPosition fieldPosition = new FieldPosition(0);
            for (int i = 1; i <= 7; ++i) {
                stringBuffer.setLength(0);
                calendar.set(7, i);
                weekFormat.format(calendar.getTime(), stringBuffer, fieldPosition);
                weekNames[i] = stringBuffer.toString();
            }
        }
        return weekNames[aWeek];
    }

    public static int[] getWeekDaysList() {
        return CalendarUtil.getWeekDaysList(Locale.getDefault());
    }

    public static int[] getWeekDaysList(Locale aLocale) {
        int[] weekDays = (int[])fWeekDaysMap.get(aLocale);
        if (weekDays == null) {
            weekDays = new int[7];
            fWeekDaysMap.put(aLocale, weekDays);
            int index = 0;
            if (FIRST_DAY_OF_WEEK == 1) {
                weekDays[index++] = 1;
            }
            weekDays[index++] = 2;
            weekDays[index++] = 3;
            weekDays[index++] = 4;
            weekDays[index++] = 5;
            weekDays[index++] = 6;
            weekDays[index++] = 7;
            if (FIRST_DAY_OF_WEEK == 2) {
                weekDays[index++] = 1;
            }
        }
        return weekDays;
    }

    public static int getDaysInMonth(Date date) {
        int day;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, day);
        for (day = 1; calendar.get(5) == day; ++day) {
            calendar.add(5, 1);
        }
        return day - 1;
    }

    public static Date getNextMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int day = calendar.get(5);
        int month = calendar.get(2);
        calendar.set(5, 1);
        if (month < 11) {
            calendar.set(2, month + 1);
        } else {
            int year = calendar.get(1);
            calendar.set(1, year + 1);
            calendar.set(2, 0);
        }
        if (day > CalendarUtil.getDaysInMonth(calendar.getTime())) {
            calendar.set(5, CalendarUtil.getDaysInMonth(calendar.getTime()));
        } else {
            calendar.set(5, day);
        }
        return calendar.getTime();
    }

    public static Date getPreviousMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int day = calendar.get(5);
        int month = calendar.get(2);
        calendar.set(5, 1);
        if (month > 0) {
            calendar.set(2, month - 1);
        } else {
            int year = calendar.get(1);
            calendar.set(1, year - 1);
            calendar.set(2, 11);
        }
        if (day > CalendarUtil.getDaysInMonth(calendar.getTime())) {
            calendar.set(5, CalendarUtil.getDaysInMonth(calendar.getTime()));
        } else {
            calendar.set(5, day);
        }
        return calendar.getTime();
    }

    public static boolean isEqual(Date aDate1, Date aDate2) {
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar1.setTime(aDate1);
        calendar2.setTime(aDate2);
        int d1 = calendar1.get(5);
        int m1 = calendar1.get(2);
        int y1 = calendar1.get(1);
        int d2 = calendar2.get(5);
        int m2 = calendar2.get(2);
        int y2 = calendar2.get(1);
        return d1 == d2 && m1 == m2 && y1 == y2;
    }

    public static boolean isBetweenIgnoreTime(Date aDate, Date aDate1, Date aDate2) {
        Date date = CalendarUtil.clearTime(aDate);
        Date date1 = CalendarUtil.clearTime(aDate1);
        Date date2 = CalendarUtil.clearTime(aDate2);
        return CalendarUtil.isBetween(date, date1, date2);
    }

    public static boolean isBetween(Date aDate, Date aDate1, Date aDate2) {
        return !(!aDate1.equals(aDate) && !aDate1.before(aDate) || !aDate2.equals(aDate) && !aDate2.after(aDate));
    }

    public static boolean isBetween(Date aStartDate1, Date anEndDate1, Date aStartDate2, Date anEndDate2) {
        return !(!anEndDate1.equals(aStartDate2) && !anEndDate1.after(aStartDate2) || !aStartDate1.equals(anEndDate2) && !aStartDate1.before(anEndDate2));
    }

    public static int compareDates(Date aDate1, Date aDate2) {
        Calendar calendar1 = CalendarUtil.createCalendar(aDate1);
        Calendar calendar2 = CalendarUtil.createCalendar(aDate2);
        CalendarUtil.clearTime(calendar1);
        CalendarUtil.clearTime(calendar2);
        return calendar1.equals(calendar2) ? 0 : (calendar1.after(calendar2) ? 1 : -1);
    }

    public static Date[] getWeekRange(Date aDate) {
        Date[] range = new Date[2];
        Calendar calendar = CalendarUtil.createCalendar(aDate);
        CalendarUtil.clearTime(calendar);
        int dayOfWeek = calendar.get(7);
        int firstDayOfWeek = calendar.getFirstDayOfWeek();
        calendar.add(5, -(dayOfWeek - firstDayOfWeek));
        range[0] = calendar.getTime();
        calendar.add(5, 6);
        range[1] = calendar.getTime();
        return range;
    }

    public static Date[] getMonthRange(Date aDate) {
        Date[] range = new Date[2];
        Calendar calendar = CalendarUtil.createCalendar(aDate);
        CalendarUtil.clearTime(calendar);
        calendar.set(5, 1);
        range[0] = calendar.getTime();
        calendar.add(5, CalendarUtil.getDaysInMonth(calendar.getTime()) - 1);
        range[1] = calendar.getTime();
        return range;
    }

    public static Date[] getYearRange(Date aDate) {
        Date[] range = new Date[2];
        Calendar calendar = CalendarUtil.createCalendar(aDate);
        CalendarUtil.clearTime(calendar);
        calendar.set(5, 1);
        calendar.set(2, 0);
        range[0] = calendar.getTime();
        calendar.set(5, 31);
        calendar.set(2, 11);
        range[1] = calendar.getTime();
        return range;
    }

    public static int getEndQuarterMonthsAmount(int aQuarter) {
        int result = 3;
        if (aQuarter == 2) {
            result = 6;
        } else if (aQuarter == 3) {
            result = 9;
        } else if (aQuarter == 4) {
            result = 12;
        }
        return result;
    }

    public static Date incDay(Date aDate, int value) {
        Calendar result = Calendar.getInstance();
        result.setTime(aDate);
        result.add(6, value);
        return result.getTime();
    }

    public static Date incWeek(Date aDate, int value) {
        Calendar result = Calendar.getInstance();
        result.setTime(aDate);
        result.add(3, value);
        return result.getTime();
    }

    public static int getDaysDifference(Date aDate1, Date aDate2) {
        float result = (float)(aDate1.getTime() - aDate2.getTime()) / 8.64E7f;
        return Math.round(result);
    }

    public static int getHoursDifference(Date aDate1, Date aDate2) {
        float result = (float)(aDate1.getTime() - aDate2.getTime()) / 3600000.0f;
        return Math.round(result);
    }

    public static int getMinutesDifference(Date aDate1, Date aDate2) {
        float result = (float)(aDate1.getTime() - aDate2.getTime()) / 60000.0f;
        return Math.round(result);
    }

    public static int getSecondsDifference(Date aDate1, Date aDate2) {
        float result = (float)(aDate1.getTime() - aDate2.getTime()) / 1000.0f;
        return Math.round(result);
    }

    protected static Date clearHMSM(Date aDate) {
        Calendar c = Calendar.getInstance();
        c.setTime(aDate);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    protected static Date clearMSM(Date aDate) {
        Calendar c = Calendar.getInstance();
        c.setTime(aDate);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static int getDaysDifferenceInt(Date aDate1, Date aDate2) {
        return CalendarUtil.getDaysDifference(CalendarUtil.clearHMSM(aDate1), CalendarUtil.clearHMSM(aDate2));
    }

    public static int getHoursDifferenceInt(Date aDate1, Date aDate2) {
        return CalendarUtil.getHoursDifference(CalendarUtil.clearMSM(aDate1), CalendarUtil.clearMSM(aDate2));
    }

    public static String formatDateTime(Date aDate) {
        if (aDate == null) {
            return null;
        }
        return DATE_TIME_FORMAT.format(aDate);
    }

    public static String formatDate(Date aDate) {
        if (aDate == null) {
            return null;
        }
        return DATE_FORMAT.format(aDate);
    }

    public static String formatTime(Date aTime) {
        if (aTime == null) {
            return null;
        }
        return TIME_FORMAT.format(aTime);
    }

    public static String formatTimeHumanReadable(long aTime) {
        long sec = aTime / 1000L;
        long min = aTime / 60000L;
        long hours = aTime / 3600000L;
        long days = aTime / 86400000L;
        String result = aTime < 60000L ? FORMAT_SEC.format(new Object[]{new Long(sec)}) : (aTime < 3600000L ? FORMAT_MIN_SEC.format(new Object[]{new Long(min), new Long(sec - min * 60000L / 1000L)}) : (aTime < 86400000L ? FORMAT_HOUR_MIN.format(new Object[]{new Long(hours), new Long(min - hours * 3600000L / 60000L)}) : FORMAT_DAYS_HOUR_MIN.format(new Object[]{new Long(days), new Long(hours - days * 86400000L / 3600000L), new Long(min - hours * 3600000L / 60000L)})));
        return result;
    }

    public static Date getQuarterStartDate(Date aDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(aDate);
        calendar.set(5, 1);
        while (calendar.get(2) != 9 && calendar.get(2) != 6 && calendar.get(2) != 3 && calendar.get(2) != 0) {
            calendar.add(2, -1);
        }
        return calendar.getTime();
    }

    public static Calendar createCalendar(Date aDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(aDate);
        return calendar;
    }

    public static int getDayOfWeekdayEntry(Date aDate, int anEntry) {
        Calendar calendar = CalendarUtil.createCalendar(aDate);
        int monthYear = calendar.get(1) + calendar.get(2);
        calendar.set(5, 0);
        for (int i = 1; i <= anEntry; ++i) {
            calendar.add(5, 1);
            while (calendar.get(7) == 7 || calendar.get(7) == 1) {
                calendar.add(5, 1);
            }
            if (monthYear >= calendar.get(1) + calendar.get(2)) continue;
            calendar.add(5, -1);
            while (calendar.get(7) == 7 || calendar.get(7) == 1) {
                calendar.add(5, -1);
            }
            break;
        }
        return calendar.get(5);
    }

    public static int getLastDayOfWeekdayEntry(Date aDate) {
        Calendar calendar = CalendarUtil.createCalendar(aDate);
        calendar.set(5, CalendarUtil.getDaysInMonth(aDate));
        while (calendar.get(7) == 7 || calendar.get(7) == 1) {
            calendar.add(5, -1);
        }
        return calendar.get(5);
    }

    public static int getDayOfWeekendEntry(Date aDate, int anEntry) {
        Calendar calendar = CalendarUtil.createCalendar(aDate);
        int monthYear = calendar.get(1) + calendar.get(2);
        calendar.set(5, 0);
        for (int i = 1; i <= anEntry; ++i) {
            calendar.add(5, 1);
            while (calendar.get(7) != 7 && calendar.get(7) != 1) {
                calendar.add(5, 1);
            }
            if (monthYear >= calendar.get(1) + calendar.get(2)) continue;
            calendar.add(5, -1);
            while (calendar.get(7) != 7 && calendar.get(7) != 1) {
                calendar.add(5, -1);
            }
            break;
        }
        return calendar.get(5);
    }

    public static int getLastDayOfWeekendEntry(Date aDate) {
        Calendar calendar = CalendarUtil.createCalendar(aDate);
        calendar.set(5, CalendarUtil.getDaysInMonth(aDate));
        while (calendar.get(7) != 1) {
            calendar.add(5, -1);
        }
        return calendar.get(5);
    }

    public static int getDayOfWeekEntry(Date aDate, int aWeek, int anEntry) {
        Calendar calendar = CalendarUtil.createCalendar(aDate);
        int monthYear = calendar.get(1) + calendar.get(2);
        calendar.set(5, 0);
        for (int i = 1; i <= anEntry; ++i) {
            calendar.add(5, 1);
            while (calendar.get(7) != aWeek) {
                calendar.add(5, 1);
            }
            if (monthYear >= calendar.get(1) + calendar.get(2)) continue;
            calendar.add(5, -1);
            while (calendar.get(7) != aWeek) {
                calendar.add(5, -1);
            }
            break;
        }
        return calendar.get(5);
    }

    public static int getLastDayOfWeekEntry(Date aDate, int aWeek) {
        Calendar calendar = CalendarUtil.createCalendar(aDate);
        calendar.set(5, CalendarUtil.getDaysInMonth(aDate));
        while (calendar.get(7) != aWeek) {
            calendar.add(5, -1);
        }
        return calendar.get(5);
    }

    public static void fillTime(Calendar aDate, Calendar aTime) {
        aDate.set(11, aTime.get(11));
        aDate.set(12, aTime.get(12));
        aDate.set(13, aTime.get(13));
    }

    public static Calendar fillTime(Date aDate, Date aTime) {
        Calendar calendarDate = CalendarUtil.createCalendar(aDate);
        CalendarUtil.fillTime(calendarDate, CalendarUtil.createCalendar(aTime));
        return calendarDate;
    }

    public static Calendar getWithoutTime(Calendar aCalendar) {
        CalendarUtil.clearTime(aCalendar);
        return aCalendar;
    }

    public static Date clearTime(Date aDate) {
        Calendar calendar = CalendarUtil.createCalendar(aDate);
        CalendarUtil.clearTime(calendar);
        return calendar.getTime();
    }

    public static void clearTime(Calendar aCalendar) {
        aCalendar.set(9, 0);
        aCalendar.set(14, 0);
        aCalendar.set(13, 0);
        aCalendar.set(12, 0);
        aCalendar.set(11, 0);
        aCalendar.set(10, 0);
    }

    public static Date getCurrentDate() {
        Calendar calendar = CalendarUtil.createCalendar(new Date());
        CalendarUtil.clearTime(calendar);
        return calendar.getTime();
    }

    public static Calendar getWeekStart(Calendar aDate) {
        Calendar result = (Calendar)aDate.clone();
        int day = aDate.getFirstDayOfWeek();
        while (result.get(7) != day) {
            result.add(7, -1);
        }
        return result;
    }

    public static Calendar getFirstDateOfWeekWithinMonth(Calendar aDate) {
        Calendar calendar = (Calendar)aDate.clone();
        int week = calendar.getFirstDayOfWeek();
        int month = calendar.get(2);
        while (week != calendar.get(7)) {
            calendar.add(5, -1);
            if (month == calendar.get(2)) continue;
            calendar.add(5, 1);
            break;
        }
        return calendar;
    }

    public static Calendar getLastDateOfWeekWithinMonth(Calendar aDate) {
        Calendar calendar = (Calendar)aDate.clone();
        int week = calendar.get(3);
        int month = calendar.get(2);
        do {
            calendar.add(5, 1);
        } while (month == calendar.get(2) && week == calendar.get(3));
        calendar.add(5, -1);
        return calendar;
    }

    public static Calendar getFirstDayOfMonth(Calendar aDate) {
        Calendar calendar = (Calendar)aDate.clone();
        calendar.set(5, 1);
        return calendar;
    }

    public static Calendar getLastDayOfMonth(Calendar aDate) {
        Calendar calendar = (Calendar)aDate.clone();
        calendar.set(5, CalendarUtil.getDaysInMonth(aDate.getTime()));
        return calendar;
    }

    public static Calendar[] getMonthPeriod(int aMonth, int aYear) {
        Calendar[] period = new Calendar[2];
        period[0] = Calendar.getInstance();
        period[0].set(1, aYear);
        period[0].set(5, 1);
        period[0].set(2, aMonth);
        period[1] = CalendarUtil.getLastDayOfMonth(period[0]);
        CalendarUtil.clearTime(period[0]);
        CalendarUtil.clearTime(period[1]);
        return period;
    }

    public static int getQuarter(Calendar aCalendar) {
        int result = 1;
        int month = aCalendar.get(2);
        if (month == 3 || month == 4 || month == 5) {
            result = 2;
        } else if (month == 6 || month == 7 || month == 8) {
            result = 3;
        } else if (month == 9 || month == 10 || month == 11) {
            result = 4;
        }
        return result;
    }

    public static Calendar[] getQuarterPeriod(int aQuarter, int aYear) {
        Calendar[] period = new Calendar[]{Calendar.getInstance(), Calendar.getInstance()};
        period[0].set(1, aYear);
        period[0].set(5, 1);
        period[1].set(1, aYear);
        period[1].set(5, 1);
        switch (aQuarter) {
            case 1: {
                period[0].set(2, 0);
                period[1].set(2, 2);
                break;
            }
            case 2: {
                period[0].set(2, 3);
                period[1].set(2, 5);
                break;
            }
            case 3: {
                period[0].set(2, 6);
                period[1].set(2, 8);
                break;
            }
            case 4: {
                period[0].set(2, 9);
                period[1].set(2, 11);
            }
        }
        period[1].set(5, CalendarUtil.getDaysInMonth(period[1].getTime()));
        CalendarUtil.clearTime(period[0]);
        CalendarUtil.clearTime(period[1]);
        return period;
    }

    public static void updateTime(Date aFrom, Date aTo) {
        Calendar from = Calendar.getInstance();
        from.setTime(aFrom);
        Calendar to = Calendar.getInstance();
        to.setTime(aTo);
        to.set(9, from.get(9));
        to.set(14, 0);
        to.set(13, 0);
        to.set(12, from.get(12));
        to.set(10, from.get(10));
        aTo.setTime(to.getTimeInMillis());
    }

    public static void updateTimeWSeconds(Date aFrom, Date aTo) {
        Calendar from = Calendar.getInstance();
        from.setTime(aFrom);
        Calendar to = Calendar.getInstance();
        to.setTime(aTo);
        to.set(9, from.get(9));
        to.set(14, from.get(14));
        to.set(13, from.get(13));
        to.set(12, from.get(12));
        to.set(10, from.get(10));
        aTo.setTime(to.getTimeInMillis());
    }

    public static long getTimeOffset(Calendar aCalendar) {
        return (aCalendar.get(15) + aCalendar.get(16)) / 60000;
    }

    public static Date changeTimeZone(Date aDate, String aTimeZone) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(aDate);
        calendar.setTimeZone(TimeZone.getTimeZone(aTimeZone));
        calendar.add(14, calendar.get(15));
        return calendar.getTime();
    }

    public static Date changeTimeZone(Date aDate, String aFromTimeZone, String aToTimeZone) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(aFromTimeZone));
        calendar.setTime(aDate);
        calendar.add(14, calendar.get(15));
        calendar.setTimeZone(TimeZone.getTimeZone(aToTimeZone));
        calendar.add(14, calendar.get(15));
        return calendar.getTime();
    }

    public static Date fromGMT0(Date aDate) {
        Calendar calendar = CalendarUtil.createCalendar(aDate);
        calendar.add(14, calendar.get(15));
        return calendar.getTime();
    }

    public static Date toGMT0(Date aDate) {
        Calendar calendar = CalendarUtil.createCalendar(aDate);
        calendar.add(14, -calendar.get(15));
        return calendar.getTime();
    }

    public static void main(String[] args) {
        System.out.println(CalendarUtil.changeTimeZone(new Date(), "GMT+4"));
    }
}

