/*
 * Decompiled with CFR 0.152.
 */
package dev.net;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.HashMap;

public class NetworkDiscoveryPacket
implements Externalizable {
    protected String fHostID;
    protected long fTimestamp;
    protected byte fType = 0;
    public static final byte TYPE_REQUEST = 0;
    public static final byte TYPE_RESPONSE = 1;
    protected String fSignature;
    protected HashMap fAttributes = new HashMap();
    public static final String ATTR_PORT = "port";

    public NetworkDiscoveryPacket() {
    }

    public NetworkDiscoveryPacket(String aSignature, String aHostID, long aTimestamp, byte aType) {
        this.fType = 0;
        this.fSignature = aSignature;
        this.fHostID = aHostID;
        this.fTimestamp = aTimestamp;
        this.fType = aType;
    }

    public HashMap getAttributes() {
        return this.fAttributes;
    }

    public String getHostID() {
        return this.fHostID;
    }

    public long getTimestamp() {
        return this.fTimestamp;
    }

    public String getSignature() {
        return this.fSignature;
    }

    public byte getType() {
        return this.fType;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        NetworkDiscoveryPacket.writeString(out, this.fSignature);
        out.writeByte(this.fType);
        NetworkDiscoveryPacket.writeString(out, this.fHostID);
        out.writeLong(this.fTimestamp);
        out.writeInt(this.fAttributes.size());
        if (this.fAttributes.size() > 0) {
            out.writeObject(this.fAttributes);
        }
    }

    protected static void writeString(ObjectOutput out, String str) throws IOException {
        out.writeInt(str.length());
        out.writeBytes(str);
    }

    protected static String readString(ObjectInput in) throws IOException {
        if (in.available() > 0) {
            int length = in.readInt();
            byte[] bytes = new byte[length];
            in.readFully(bytes);
            return new String(bytes);
        }
        return null;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fSignature = NetworkDiscoveryPacket.readString(in);
        this.fType = in.readByte();
        this.fHostID = NetworkDiscoveryPacket.readString(in);
        this.fTimestamp = in.readLong();
        int size = in.readInt();
        if (size > 0) {
            this.fAttributes = (HashMap)in.readObject();
        }
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(bos);
        this.writeExternal(os);
        os.flush();
        return bos.toByteArray();
    }

    public void fromByteArray(byte[] aBytes, int offset, int length) throws ClassNotFoundException, IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(aBytes, offset, length);
        ObjectInputStream is = new ObjectInputStream(bis);
        this.readExternal(is);
    }
}

