/*
 * Decompiled with CFR 0.152.
 */
package dev.net;

import dev.lang.BitTools;
import dev.net.NetworkDiscoveryListener;
import dev.net.NetworkDiscoveryPacket;
import dev.util.StringUtils;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class NetworkDiscovery {
    public static final int SOCKET_PORT_NUMBER = 1972;
    public static final int SOCKET_TIME_TO_LIVE = 2;
    public static final String SOCKET_GROUP_NAME = "224.0.0.1";
    public static final int SOCKET_BUFFER_SIZE = 1024;
    public static final int SOCKET_TIMEOUT = 0;
    public static String SIGNTATURE = "*** Network-Discovery ***";
    protected int fSocketPortNumber = 1972;
    protected int fSocketTimeToLive = 2;
    protected String fSocketGroupName = "224.0.0.1";
    protected int fSocketBufferSize = 1024;
    protected int fSocketTimeout = 0;
    protected String fHostID;
    protected long fTimestamp = System.currentTimeMillis();
    protected String fSignature = SIGNTATURE;
    protected MulticastSocket fMulticastSocket;
    protected Thread fRunnerTread;
    protected boolean fRunning = false;
    public static final int MODE_CLIENT = 1;
    public static final int MODE_SERVER = 2;
    protected int fMode = 3;
    protected Set fDiscoveredAddresses = new HashSet();
    protected InetAddress fGroup;
    protected boolean fVerbose = false;
    public static final int POLICY_SAME_HOST = 1;
    public static final int POLICY_DIFFERENT_HOST = 2;
    public static final int POLICY_ANY_HOST = 3;
    protected int fCheckHostPolicy = 3;
    transient Vector fNetworkDiscoveryListeners;

    public NetworkDiscovery() throws UnknownHostException {
        this(null, 3);
    }

    public NetworkDiscovery(int aMode) throws UnknownHostException {
        this(null, aMode);
    }

    public NetworkDiscovery(String aHostID, int aMode) throws UnknownHostException {
        if (aHostID == null) {
            InetAddress localHost = InetAddress.getLocalHost();
            this.fHostID = localHost.getHostName();
            if (this.fHostID == null) {
                this.fHostID = localHost.getHostAddress();
            }
        } else {
            this.fHostID = aHostID;
        }
        this.fMode = aMode;
    }

    public int getSocketTimeout() {
        return this.fSocketTimeout;
    }

    public void setSocketTimeout(int aSocketTimeout) {
        this.fSocketTimeout = aSocketTimeout;
    }

    public int getSocketBufferSize() {
        return this.fSocketBufferSize;
    }

    public void setSocketBufferSize(int aSocketBufferSize) {
        this.fSocketBufferSize = aSocketBufferSize;
    }

    public String getSocketGroupName() {
        return this.fSocketGroupName;
    }

    public void setSocketGroupName(String aSocketGroupName) {
        this.fSocketGroupName = aSocketGroupName;
        this.fGroup = null;
    }

    public int getSocketTimeToLive() {
        return this.fSocketTimeToLive;
    }

    public void setSocketTimeToLive(int aSocketTimeToLive) {
        this.fSocketTimeToLive = aSocketTimeToLive;
    }

    public int getSocketPortNumber() {
        return this.fSocketPortNumber;
    }

    public void setSocketPortNumber(int aSocketPortNumber) {
        this.fSocketPortNumber = aSocketPortNumber;
    }

    public synchronized void start() {
        if (this.fRunning) {
            return;
        }
        this.fDiscoveredAddresses.clear();
        this.createMulticastSocket();
        this.fRunnerTread = new Thread(new Runnable(){

            public void run() {
                try {
                    int size = NetworkDiscovery.this.fMulticastSocket.getReceiveBufferSize();
                    DatagramPacket datagramPacket = new DatagramPacket(new byte[size], size);
                    NetworkDiscovery.this.fRunning = true;
                    try {
                        while (NetworkDiscovery.this.fRunning) {
                            NetworkDiscovery.this.fMulticastSocket.receive(datagramPacket);
                            NetworkDiscovery.this.processDatagramPacket(datagramPacket);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    NetworkDiscovery.this.stop();
                }
                catch (Exception ex) {
                    NetworkDiscovery.this.error(ex);
                }
                NetworkDiscovery.this.fireNetworkDiscoveryFinished();
            }
        });
        this.fRunnerTread.start();
        this.fireNetworkDiscoveryStarted();
        if (this.isClient()) {
            this.send(this.createRequest());
        }
    }

    public boolean isClient() {
        return BitTools.checkBit(this.fMode, 1);
    }

    public boolean isServer() {
        return BitTools.checkBit(this.fMode, 2);
    }

    private void error(Throwable ex) {
        if (this.isVerbose()) {
            ex.printStackTrace();
        }
    }

    public synchronized void stop() {
        if (!this.fRunning) {
            return;
        }
        this.fRunning = false;
        if (this.fRunnerTread.isAlive()) {
            this.fRunnerTread.interrupt();
        }
        this.releaseMulticastSocket();
    }

    protected boolean isRunning() {
        return this.fRunning;
    }

    public Set getDiscoveredAddresses() {
        return this.fDiscoveredAddresses;
    }

    protected void send(NetworkDiscoveryPacket aPacket) {
        if (this.fMulticastSocket == null) {
            throw new IllegalStateException("Network discovery is not started");
        }
        try {
            byte[] bytes = aPacket.toByteArray();
            aPacket.fromByteArray(bytes, 0, bytes.length);
            DatagramPacket datagramPacket = new DatagramPacket(bytes, bytes.length, this.getGroup(), this.getSocketPortNumber());
            this.fMulticastSocket.send(datagramPacket);
        }
        catch (Throwable ex) {
            this.error(ex);
        }
    }

    protected synchronized void createMulticastSocket() {
        try {
            this.fMulticastSocket = new MulticastSocket(this.getSocketPortNumber());
            this.fMulticastSocket.setTimeToLive(this.getSocketTimeToLive());
            this.fMulticastSocket.setSendBufferSize(this.getSocketBufferSize());
            this.fMulticastSocket.setSoTimeout(this.getSocketTimeout());
            this.fMulticastSocket.joinGroup(this.getGroup());
        }
        catch (Throwable ex) {
            this.error(ex);
        }
    }

    protected InetAddress getGroup() throws UnknownHostException {
        if (this.fGroup == null) {
            this.fGroup = InetAddress.getByName(this.getSocketGroupName());
        }
        return this.fGroup;
    }

    protected synchronized void releaseMulticastSocket() {
        try {
            this.fMulticastSocket.leaveGroup(this.getGroup());
            this.fMulticastSocket.close();
            this.fMulticastSocket = null;
        }
        catch (Throwable ex) {
            this.error(ex);
        }
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(boolean aVerbose) {
        this.fVerbose = aVerbose;
    }

    protected void processDatagramPacket(DatagramPacket aDatagramPacket) {
        try {
            NetworkDiscoveryPacket packet = new NetworkDiscoveryPacket();
            packet.fromByteArray(aDatagramPacket.getData(), aDatagramPacket.getOffset(), aDatagramPacket.getLength());
            if (packet.getType() == 0) {
                if (this.isServer() && this.checkRequest(packet)) {
                    this.send(this.createResponce());
                }
            } else if (packet.getType() == 1 && this.isClient() && this.checkResponce(packet)) {
                InetAddress address = aDatagramPacket.getAddress();
                this.fDiscoveredAddresses.add(address);
                this.fireAddressDiscovered(address, packet);
            }
        }
        catch (Throwable ex) {
            this.error(ex);
        }
    }

    public int getCheckHostPolicy() {
        return this.fCheckHostPolicy;
    }

    public void setCheckHostPolicy(int aCheckHostPolicy) {
        this.fCheckHostPolicy = aCheckHostPolicy;
    }

    protected boolean checkResponce(NetworkDiscoveryPacket aPacket) {
        return this.acceptsResponce(aPacket) && this.checkHost(aPacket) && aPacket.getTimestamp() != this.fTimestamp;
    }

    protected boolean checkRequest(NetworkDiscoveryPacket aPacket) {
        return this.acceptsRequest(aPacket);
    }

    protected boolean checkHost(NetworkDiscoveryPacket aPacket) {
        boolean result = true;
        switch (this.fCheckHostPolicy) {
            case 1: {
                result = StringUtils.equals(aPacket.getHostID(), this.fHostID);
                break;
            }
            case 2: {
                result = !StringUtils.equals(aPacket.getHostID(), this.fHostID);
            }
        }
        return result;
    }

    protected NetworkDiscoveryPacket createResponce() {
        return new NetworkDiscoveryPacket(this.fSignature, this.fHostID, this.fTimestamp, 1);
    }

    protected boolean acceptsResponce(NetworkDiscoveryPacket aPacket) {
        return this.fSignature.equals(aPacket.getSignature());
    }

    protected boolean acceptsRequest(NetworkDiscoveryPacket aPacket) {
        return this.fSignature.equals(aPacket.getSignature());
    }

    protected NetworkDiscoveryPacket createRequest() {
        return new NetworkDiscoveryPacket(this.fSignature, this.fHostID, this.fTimestamp, 0);
    }

    public String getSignature() {
        return this.fSignature;
    }

    public void setSignature(String aSignature) {
        this.fSignature = aSignature;
    }

    public static void main(String[] args) {
        try {
            NetworkDiscovery networkDiscovery = new NetworkDiscovery();
            networkDiscovery.start();
            Thread.currentThread();
            Thread.sleep(5000L);
            networkDiscovery.stop();
            networkDiscovery.getDiscoveredAddresses().toString();
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public synchronized void addNetworkDiscoveryListener(NetworkDiscoveryListener l) {
        Vector v;
        Vector vector = v = this.fNetworkDiscoveryListeners == null ? new Vector(2) : (Vector)this.fNetworkDiscoveryListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.fNetworkDiscoveryListeners = v;
        }
    }

    public synchronized void removeNetworkDiscoveryListener(NetworkDiscoveryListener l) {
        if (this.fNetworkDiscoveryListeners != null && this.fNetworkDiscoveryListeners.contains(l)) {
            Vector v = (Vector)this.fNetworkDiscoveryListeners.clone();
            v.removeElement(l);
            this.fNetworkDiscoveryListeners = v;
        }
    }

    protected void fireNetworkDiscoveryStarted() {
        if (this.fNetworkDiscoveryListeners != null) {
            Vector listeners = this.fNetworkDiscoveryListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((NetworkDiscoveryListener)listeners.elementAt(i)).networkDiscoveryStarted(this);
            }
        }
    }

    protected void fireNetworkDiscoveryFinished() {
        if (this.fNetworkDiscoveryListeners != null) {
            Vector listeners = this.fNetworkDiscoveryListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((NetworkDiscoveryListener)listeners.elementAt(i)).networkDiscoveryFinished(this);
            }
        }
    }

    protected void fireAddressDiscovered(InetAddress anAddress, NetworkDiscoveryPacket aPacket) {
        if (this.fNetworkDiscoveryListeners != null) {
            Vector listeners = this.fNetworkDiscoveryListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((NetworkDiscoveryListener)listeners.elementAt(i)).addressDiscovered(this, anAddress, aPacket);
            }
        }
    }
}

