/*
 * Decompiled with CFR 0.152.
 */
package dev.net;

import dev.util.StringUtils;
import java.util.prefs.Preferences;

public class HttpProxy {
    public static final String PROPERTY_USE_PROXY = "useProxy";
    public static final String PROPERTY_HTTP_PROXY_SET = "http.proxySet";
    public static final String PROPERTY_HTTP_PROXY_HOST = "http.proxyHost";
    public static final String PROPERTY_HHTP_PROXY_PORT = "http.proxyPort";
    public static final String PROPERTY_HTTP_PROXY_USER = "http.proxyUser";
    public static final String PROPERTY_HTTP_PROXY_PASSWORD = "http.proxyPassword";
    protected boolean enabled = false;
    protected String host;
    protected String port;
    protected String user;
    protected String password;

    public static void applyFromPreferences(Preferences aPreferences) {
        if (!new HttpProxy().fromSystemProperties()) {
            HttpProxy httpProxy = new HttpProxy();
            httpProxy.fromPreferences(aPreferences);
            if (httpProxy.isEnabled()) {
                httpProxy.toSystemProperties();
            }
        }
    }

    protected void setSystemProperty(String aName, String aValue) {
        if (!StringUtils.noValue(aValue)) {
            System.setProperty(aName, aValue);
        } else {
            System.clearProperty(aName);
        }
    }

    protected void putPreference(Preferences aPreferences, String aName, String aValue) {
        if (aPreferences != null) {
            if (aValue != null) {
                aPreferences.put(aName, aValue);
            } else {
                aPreferences.remove(aName);
            }
        }
    }

    public boolean fromSystemProperties() {
        this.enabled = "true".equals(System.getProperty(PROPERTY_HTTP_PROXY_SET)) || !StringUtils.noValue(System.getProperty(PROPERTY_HTTP_PROXY_HOST));
        this.host = this.enabled ? System.getProperty(PROPERTY_HTTP_PROXY_HOST) : null;
        this.port = this.enabled ? System.getProperty(PROPERTY_HHTP_PROXY_PORT) : null;
        this.user = this.enabled ? System.getProperty(PROPERTY_HTTP_PROXY_USER) : null;
        this.password = this.enabled ? System.getProperty(PROPERTY_HTTP_PROXY_PASSWORD) : null;
        return this.enabled;
    }

    public void toSystemProperties() {
        this.setSystemProperty(PROPERTY_HTTP_PROXY_SET, this.enabled ? "true" : null);
        this.setSystemProperty(PROPERTY_HTTP_PROXY_HOST, this.host);
        this.setSystemProperty(PROPERTY_HHTP_PROXY_PORT, this.port);
        this.setSystemProperty(PROPERTY_HTTP_PROXY_USER, this.user);
        this.setSystemProperty(PROPERTY_HTTP_PROXY_PASSWORD, this.password);
    }

    public void fromPreferences(Preferences aPreferences) {
        this.enabled = aPreferences.get(PROPERTY_USE_PROXY, Boolean.toString(false)).equals(Boolean.toString(true));
        this.host = this.enabled ? aPreferences.get(PROPERTY_HTTP_PROXY_HOST, null) : null;
        this.port = this.enabled ? aPreferences.get(PROPERTY_HHTP_PROXY_PORT, null) : null;
        this.user = this.enabled ? aPreferences.get(PROPERTY_HTTP_PROXY_USER, null) : null;
        this.password = this.enabled ? aPreferences.get(PROPERTY_HTTP_PROXY_PASSWORD, null) : null;
    }

    public void toPreferences(Preferences aPreferences) {
        this.putPreference(aPreferences, PROPERTY_USE_PROXY, this.enabled ? "true" : "false");
        this.putPreference(aPreferences, PROPERTY_HTTP_PROXY_HOST, this.host);
        this.putPreference(aPreferences, PROPERTY_HHTP_PROXY_PORT, this.port);
        this.putPreference(aPreferences, PROPERTY_HTTP_PROXY_USER, this.user);
        this.putPreference(aPreferences, PROPERTY_HTTP_PROXY_PASSWORD, this.password);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getHost() {
        return this.host;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }
}

