/*
 * Decompiled with CFR 0.152.
 */
package dev.gui.wizard;

import dev.gui.DividerLabel;
import dev.gui.FakeOwnerFrame;
import dev.gui.OkCancelHelpDialog;
import dev.gui.ResourceUtils;
import dev.gui.wizard.ProgressWizardPane;
import dev.gui.wizard.WizardPane;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class WizardDialog
extends OkCancelHelpDialog {
    static ResourceBundle res = ResourceBundle.getBundle("dev.gui.wizard.Res");
    public static final String PROPERTY_TOPIC_ID = "topicID";
    protected JButton btnBack = new JButton();
    protected JButton btnNext = new JButton();
    protected JPanel pnlContent = new JPanel();
    protected DividerLabel lblDivider = new DividerLabel();
    protected JLabel lblWizardImage = new JLabel();
    JPanel pnlWizardPanes = new JPanel();
    CardLayout fWizardPanesLayout = new CardLayout();
    public static final ImageIcon ICON_WIZARD = ResourceUtils.loadImageIcon(WizardDialog.class, "res/Wizard.png");
    public static final String NEXT_PANE_NONE = "-none-";
    protected boolean fIsNextOperation = false;
    protected ComponentAdapter fComponentAdapter = new ComponentAdapter(){

        public void componentShown(ComponentEvent e) {
            WizardPane prevActive = WizardDialog.this.fActiveWizardPane;
            WizardDialog.this.fActiveWizardPane = (WizardPane)e.getComponent();
            WizardDialog.this.fActiveWizardPane.activate(prevActive != null && WizardDialog.this.fIsNextOperation ? prevActive.getName() : null);
            WizardDialog.this.fIsNextOperation = false;
            WizardDialog.this.updateSize();
            WizardDialog.this.update();
        }
    };
    protected WizardPane fActiveWizardPane;

    public WizardDialog() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public WizardDialog(Frame owner) {
        super(owner, true);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public WizardDialog(Frame owner, String title) {
        super(owner, title, true);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public WizardDialog(Dialog owner) {
        super(owner, true);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public WizardDialog(Dialog owner, String title) {
        super(owner, title, true);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Icon getWizardIcon() {
        return this.lblWizardImage.getIcon();
    }

    public void setWizardIcon(Icon icon) {
        this.lblWizardImage.setIcon(icon);
    }

    public boolean isWizardIconVisible() {
        return this.lblWizardImage.isVisible();
    }

    public void setWizardIconVisible(boolean aValue) {
        this.lblWizardImage.setVisible(aValue);
    }

    private void jbInit() throws Exception {
        this.lblWizardImage.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.lblWizardImage.setIcon(ICON_WIZARD);
        this.lblWizardImage.setVerticalAlignment(1);
        this.pnlContent.setLayout(new BorderLayout());
        this.btnBack.setMnemonic(res.getString("btnBack_M").charAt(0));
        this.btnBack.setText(res.getString("btnBack_Text"));
        this.btnBack.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.btnBack_actionPerformed(e);
            }
        });
        this.btnNext.setMnemonic(res.getString("btnNext_M").charAt(0));
        this.btnNext.setText(res.getString("btnNext_Text"));
        this.btnNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.btnNext_actionPerformed(e);
            }
        });
        this.btnOk.setText(res.getString("btnOk_Text"));
        this.btnOk.setMnemonic(res.getString("btnOk_M").charAt(0));
        this.pnlContent.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.pnlWizardPanes.setLayout(this.fWizardPanesLayout);
        this.pnlButtons.add((Component)this.btnBack, new GridBagConstraints(9, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.pnlButtons.add((Component)this.btnNext, new GridBagConstraints(10, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.pnlContent, "Center");
        this.pnlContent.add((Component)this.lblDivider, "Last");
        this.pnlContent.add((Component)this.lblWizardImage, "Before");
        this.pnlContent.add((Component)this.pnlWizardPanes, "Center");
    }

    public static void main(String[] args) {
        new WizardDialog().executeModal();
    }

    void btnBack_actionPerformed(ActionEvent e) {
        this.back();
    }

    void btnNext_actionPerformed(ActionEvent e) {
        this.next();
    }

    public void next() {
        if (this.canNext()) {
            String nextPaneName = this.doNext();
            if (nextPaneName != null) {
                if (!NEXT_PANE_NONE.equals(nextPaneName)) {
                    this.fIsNextOperation = true;
                    this.fWizardPanesLayout.show(this.pnlWizardPanes, nextPaneName);
                }
            } else {
                this.fWizardPanesLayout.next(this.pnlWizardPanes);
            }
        }
    }

    protected String doNext() {
        return this.fActiveWizardPane.next();
    }

    public void back() {
        if (this.canBack()) {
            String backPaneName = this.doBack();
            if (backPaneName != null) {
                this.fWizardPanesLayout.show(this.pnlWizardPanes, backPaneName);
            } else {
                this.fWizardPanesLayout.previous(this.pnlWizardPanes);
            }
        }
    }

    protected void first() {
        this.fWizardPanesLayout.first(this.pnlWizardPanes);
    }

    protected void updateSize() {
        this.pack();
    }

    protected String doBack() {
        return this.fActiveWizardPane.back();
    }

    protected void onButtonOkActionPerformed(ActionEvent e) {
        this.finish();
    }

    public void finish() {
        if (this.canFinish()) {
            this.setModalResult(this.doFinish());
            if (this.getModalResult() == 1 || this.getModalResult() == 2) {
                this.setVisible(false);
            }
        }
    }

    protected String getMessageTitle() {
        String result = res.getString("Error");
        for (Container p = this.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof Dialog)) continue;
            result = ((Dialog)p).getTitle();
            break;
        }
        return result;
    }

    protected void error(String aMessage) {
        JOptionPane.showMessageDialog(this, aMessage, this.getMessageTitle(), 0);
    }

    protected int doFinish() {
        return this.fActiveWizardPane.finish();
    }

    public void update() {
        this.btnBack.setEnabled(this.canBack());
        this.btnNext.setEnabled(this.canNext());
        this.btnOk.setEnabled(this.canFinish());
    }

    protected boolean canBack() {
        return this.fActiveWizardPane != null && this.fActiveWizardPane.canBack() && this.getWizardPaneIndex(this.fActiveWizardPane) > 0;
    }

    protected boolean canNext() {
        return this.fActiveWizardPane != null && this.fActiveWizardPane.canNext() && (this.getWizardPaneIndex(this.fActiveWizardPane) < this.getWizardPaneCount() - 1 || this.fActiveWizardPane.getNextPaneName() != null);
    }

    protected boolean canFinish() {
        return this.fActiveWizardPane != null && this.fActiveWizardPane.canFinish();
    }

    public void addWizardPane(WizardPane aWizardPane) {
        aWizardPane.addComponentListener(this.fComponentAdapter);
        aWizardPane.setWizardDialog(this);
        aWizardPane.setVisible(false);
        this.pnlWizardPanes.add((Component)aWizardPane, aWizardPane.getName());
    }

    public void removeWizardPane(WizardPane aWizardPane) {
        this.pnlWizardPanes.remove(aWizardPane);
        aWizardPane.removeComponentListener(this.fComponentAdapter);
    }

    public int getWizardPaneCount() {
        return this.pnlWizardPanes.getComponentCount();
    }

    public WizardPane getWizardPane(int anIndex) {
        return (WizardPane)this.pnlWizardPanes.getComponent(anIndex);
    }

    public int getWizardPaneIndex(WizardPane aWizardPane) {
        int result = -1;
        Component[] components = this.pnlWizardPanes.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] != aWizardPane) continue;
            result = i;
            break;
        }
        return result;
    }

    public WizardPane getActiveWizardPane() {
        return this.fActiveWizardPane;
    }

    protected void setActiveWizardPane(WizardPane aActiveWizardPane) {
        if (this.fActiveWizardPane != aActiveWizardPane) {
            this.fWizardPanesLayout.show(this.pnlWizardPanes, aActiveWizardPane.getName());
        } else if (this.fActiveWizardPane != null) {
            this.fActiveWizardPane.activate(null);
        }
    }

    protected boolean hasActiveWizardPane() {
        boolean result = false;
        int count = this.getWizardPaneCount();
        for (int i = 0; i < count; ++i) {
            if (!this.getWizardPane(i).isVisible()) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean executeModal() {
        this.setModal(true);
        if (!this.hasActiveWizardPane()) {
            this.first();
        }
        this.pack();
        this.centerOnOwner();
        this.setVisible(true);
        return this.getModalResult() == 1;
    }

    protected void doCancel() {
        if (this.getActiveWizardPane() instanceof ProgressWizardPane && ((ProgressWizardPane)this.getActiveWizardPane()).cancel()) {
            super.doCancel();
        } else {
            super.doCancel();
        }
    }

    public void setVisible(boolean aVisible) {
        Window ownerFrame = this.getOwner();
        if (ownerFrame instanceof FakeOwnerFrame && !ownerFrame.isVisible() && aVisible) {
            ((FakeOwnerFrame)ownerFrame).showFrame(this.getTitle());
        }
        super.setVisible(aVisible);
        if (ownerFrame instanceof FakeOwnerFrame && ownerFrame.isVisible() && !aVisible) {
            ((FakeOwnerFrame)ownerFrame).hideFrame();
        }
    }
}

