/*
 * Decompiled with CFR 0.152.
 */
package dev.gui.wizard;

import dev.gui.FlowLayoutEx;
import dev.gui.LafColor;
import dev.gui.ResourceUtils;
import dev.gui.wizard.WizardDialog;
import dev.gui.wizard.WizardPane;
import dev.gui.wizard.WizardPaneHeader;
import dev.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public abstract class ProgressWizardPane
extends WizardPane {
    static ResourceBundle res = ResourceBundle.getBundle("dev.gui.wizard.Res");
    protected WizardPaneHeader pnlWizardHeader = new WizardPaneHeader();
    protected JPanel pnlOperations = new JPanel();
    protected FlowLayoutEx fOperationsLayout = new FlowLayoutEx(0, 0, 5);
    protected JPanel pnlFill = new JPanel();
    protected HashMap fOperationsMap = new HashMap();
    protected List fOperations = new ArrayList();
    public static final ImageIcon ICON_READY = ResourceUtils.loadImageIcon(ProgressWizardPane.class, "res/ready.png");
    public static final ImageIcon ICON_COMPLETED = ResourceUtils.loadImageIcon(ProgressWizardPane.class, "res/completed.png");
    public static final ImageIcon ICON_FAILED = ResourceUtils.loadImageIcon(ProgressWizardPane.class, "res/failed.png");
    public static final ImageIcon ICON_IN_PROGRESS = ResourceUtils.loadImageIcon(ProgressWizardPane.class, "res/throbber.gif");

    public boolean canFinish() {
        return false;
    }

    public int finish() {
        return 0;
    }

    public boolean canBack() {
        return false;
    }

    public boolean canNext() {
        return false;
    }

    public boolean canCancel() {
        return true;
    }

    protected String getCancelPrompt() {
        return res.getString("Cancel_Prompt");
    }

    public boolean cancel() {
        boolean result;
        String prompt = this.getCancelPrompt();
        boolean bl = prompt != null ? WizardDialog.prompt(this, prompt) == 0 : (result = true);
        if (result) {
            result = this.stop();
        }
        return result;
    }

    public void activate(String aBackPaneName) {
        super.activate(aBackPaneName);
        this.start();
    }

    public boolean start() {
        this.setOperationStatus(1);
        return true;
    }

    public abstract boolean stop();

    public List getOperations() {
        return Collections.unmodifiableList(this.fOperations);
    }

    public void addOperation(Operation anOperation, int anIndex) {
        OperationPane label = new OperationPane();
        label.setVisible(anOperation.isVisible());
        this.fOperationsMap.put(anOperation, label);
        anOperation.addPropertyChangeListener(this);
        this.fOperationsMap.put(anOperation, label);
        this.fOperations.add(anIndex, anOperation);
        this.pnlOperations.add((Component)label, anIndex);
        this.updateLabel(anOperation);
    }

    protected void updateLabel(Operation anOperation) {
        this.getLabel(anOperation).setOperation(anOperation);
    }

    public void addOperation(Operation anOperation) {
        this.addOperation(anOperation, this.fOperations.size());
    }

    public void removeOperation(Operation anOperation) {
        if (this.fOperationsMap.containsKey(anOperation)) {
            JLabel label = (JLabel)this.fOperationsMap.remove(anOperation);
            this.fOperations.remove(anOperation);
            anOperation.removePropertyChangeListener(this);
            this.pnlOperations.remove(label);
        }
    }

    public OperationPane getLabel(Operation anOperation) {
        return (OperationPane)this.fOperationsMap.get(anOperation);
    }

    public void propertyChange(final PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getSource() instanceof Operation) {
            final Operation operation = (Operation)evt.getSource();
            if (SwingUtilities.isEventDispatchThread()) {
                if (evt.getPropertyName().equals("visible")) {
                    this.getLabel(operation).setVisible(Boolean.TRUE.equals(evt.getNewValue()));
                    this.pnlOperations.revalidate();
                } else {
                    this.updateLabel(operation);
                    this.pnlOperations.revalidate();
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (evt.getPropertyName().equals("visible")) {
                            ProgressWizardPane.this.getLabel(operation).setVisible(Boolean.TRUE.equals(evt.getNewValue()));
                            ProgressWizardPane.this.pnlOperations.revalidate();
                        } else {
                            ProgressWizardPane.this.updateLabel(operation);
                            ProgressWizardPane.this.pnlOperations.revalidate();
                        }
                    }
                });
            }
        }
    }

    public void setOperationStatus(int aStatus) {
        for (Operation operation : this.fOperations) {
            operation.setStatus(aStatus);
        }
    }

    protected static ImageIcon getOperationStatusIcon(int aStatus) {
        ImageIcon result = null;
        switch (aStatus) {
            case 1: {
                result = ICON_READY;
                break;
            }
            case 2: {
                result = ICON_IN_PROGRESS;
                break;
            }
            case 3: {
                result = ICON_COMPLETED;
                break;
            }
            case 4: {
                result = ICON_FAILED;
            }
        }
        return result;
    }

    protected String getOperationStatusText(int aStatus) {
        String result = null;
        switch (aStatus) {
            case 1: {
                result = "READY";
                break;
            }
            case 2: {
                result = "RUNNING...";
                break;
            }
            case 3: {
                result = "COMPLETED";
                break;
            }
            case 4: {
                result = "FAILED";
            }
        }
        return result;
    }

    public ProgressWizardPane() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.fOperationsLayout.setOrientation(1);
        this.fOperationsLayout.setRetainComponentsWidth(true);
        this.pnlOperations.setLayout(this.fOperationsLayout);
        this.pnlFill.setMinimumSize(new Dimension(0, 0));
        this.pnlFill.setPreferredSize(new Dimension(0, 0));
        this.add((Component)this.pnlWizardHeader, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.pnlOperations, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.add((Component)this.pnlFill, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    public static class Operation {
        public static final String PROPERTY_STATUS = "status";
        public static final String PROPERTY_NAME = "name";
        public static final String PROPERTY_DESCRIPTION = "description";
        public static final String PROPERTY_STATUS_TEXT = "statusText";
        public static final String PROPERTY_VISIBLE = "visible";
        public static final String PROPERTY_MESSAGE = "message";
        public static final int STATUS_READY = 1;
        public static final int STATUS_IN_PROGRESS = 2;
        public static final int STATUS_COMPLETED = 3;
        public static final int STATUS_FAILED = 4;
        protected PropertyChangeSupport fPropertyChangeSupport = new PropertyChangeSupport(this);
        protected int fStatus = 1;
        protected String fName;
        protected String fDescription;
        protected String fStatusText;
        protected boolean fVisible = true;
        protected String fMessage;

        public Operation() {
        }

        public Operation(String aName, String aDescription) {
            this.fName = aName;
            this.fDescription = aDescription;
        }

        protected synchronized void addPropertyChangeListener(PropertyChangeListener l) {
            this.fPropertyChangeSupport.addPropertyChangeListener(l);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
            this.fPropertyChangeSupport.removePropertyChangeListener(listener);
        }

        public String getDescription() {
            return this.fDescription;
        }

        public void setDescription(String aDescription) {
            if (!StringUtils.equals(this.fDescription, aDescription)) {
                String oldValue = this.fDescription;
                this.fDescription = aDescription;
                this.fPropertyChangeSupport.firePropertyChange(PROPERTY_DESCRIPTION, oldValue, this.fDescription);
            }
        }

        public String getMessage() {
            return this.fMessage;
        }

        public void setMessage(String aMessage) {
            if (!StringUtils.equals(this.fMessage, aMessage)) {
                String oldValue = this.fMessage;
                this.fMessage = aMessage;
                this.fPropertyChangeSupport.firePropertyChange(PROPERTY_MESSAGE, oldValue, this.fMessage);
            }
        }

        public String getName() {
            return this.fName;
        }

        public void setName(String aName) {
            if (!StringUtils.equals(this.fName, aName)) {
                String oldValue = this.fName;
                this.fName = aName;
                this.fPropertyChangeSupport.firePropertyChange(PROPERTY_NAME, oldValue, this.fName);
            }
        }

        public int getStatus() {
            return this.fStatus;
        }

        public void setStatus(int aStatus) {
            if (this.fStatus != aStatus) {
                int oldValue = this.fStatus;
                this.fStatus = aStatus;
                this.fPropertyChangeSupport.firePropertyChange(PROPERTY_STATUS, oldValue, this.fStatus);
            }
        }

        public String getStatusText() {
            return this.fStatusText;
        }

        public void setStatusText(String aStatusText) {
            if (!StringUtils.equals(this.fStatusText, aStatusText)) {
                String oldValue = this.fStatusText;
                this.fStatusText = aStatusText;
                this.fPropertyChangeSupport.firePropertyChange(PROPERTY_STATUS_TEXT, oldValue, this.fStatusText);
            }
        }

        public boolean isVisible() {
            return this.fVisible;
        }

        public void setVisible(boolean aVisible) {
            if (this.fVisible != aVisible) {
                this.fVisible = aVisible;
                this.fPropertyChangeSupport.firePropertyChange(PROPERTY_VISIBLE, !this.fVisible, this.fVisible);
            }
        }
    }

    public static class OperationPane
    extends JPanel {
        GridBagLayout gridBagLayout1 = new GridBagLayout();
        JLabel lblStatus = new JLabel();
        JLabel lblStatusText = new JLabel();
        JLabel lblMessage = new JLabel(){

            public Dimension getPreferredSize() {
                Dimension result = super.getPreferredSize();
                result.height = Math.min(result.height, 64);
                return result;
            }

            public Dimension getMinimumSize() {
                Dimension result = super.getMinimumSize();
                result.height = Math.min(result.height, 64);
                return result;
            }
        };
        protected Operation fOperation;

        public OperationPane() {
            try {
                this.jbInit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private void jbInit() throws Exception {
            this.setLayout(this.gridBagLayout1);
            this.lblMessage.setVisible(false);
            this.lblMessage.setBorder(new CompoundBorder(new LineBorder(new LafColor("Label.background", -0.8f)), new EmptyBorder(1, 2, 1, 2)));
            this.lblMessage.setOpaque(true);
            this.lblMessage.setVerticalAlignment(1);
            this.lblMessage.setBackground(new LafColor("Label.background", 0.95f));
            this.add((Component)this.lblStatus, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.lblStatusText, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)this.lblMessage, new GridBagConstraints(0, 1, 2, 1, 0.1, 0.0, 21, 2, new Insets(2, 0, 0, 0), 0, 0));
        }

        public void setOperation(Operation anOperation) {
            this.fOperation = anOperation;
            if (this.fOperation != null) {
                this.setStatus(anOperation.getName());
                this.setStatusIcon(ProgressWizardPane.getOperationStatusIcon(anOperation.getStatus()));
                this.setStatusText(anOperation.getStatusText());
                this.setDescription(anOperation.getDescription());
                this.setMessage(anOperation.getMessage());
                switch (this.fOperation.getStatus()) {
                    case 1: 
                    case 3: {
                        this.lblStatusText.setForeground(UIManager.getColor("Label.foreground"));
                        break;
                    }
                    case 2: {
                        this.lblStatusText.setForeground(Color.DARK_GRAY);
                        break;
                    }
                    case 4: {
                        this.lblStatusText.setForeground(Color.RED);
                    }
                }
            }
        }

        public String getStatus() {
            return this.lblStatus.getText();
        }

        public void setStatus(String aStatus) {
            this.lblStatus.setText(aStatus);
        }

        public Icon getStatusIcon() {
            return this.lblStatus.getIcon();
        }

        public void setStatusIcon(Icon anIcon) {
            this.lblStatus.setIcon(anIcon);
        }

        public String getStatusText() {
            return this.lblStatusText.getText();
        }

        public void setStatusText(String aStatusText) {
            this.lblStatusText.setText(!StringUtils.noValue(aStatusText) ? "[" + aStatusText + "]" : null);
            this.lblStatusText.setToolTipText(aStatusText);
        }

        public String getDescription() {
            return this.lblStatus.getToolTipText();
        }

        public void setDescription(String aDescription) {
            this.lblStatus.setToolTipText(aDescription);
        }

        public String getMessage() {
            return this.lblMessage.getText();
        }

        public void setMessage(String aMessage) {
            this.lblMessage.setText(aMessage);
            this.lblMessage.setVisible(!StringUtils.noValue(aMessage));
        }
    }
}

