/*
 * Decompiled with CFR 0.152.
 */
package dev.gui.wizard;

import dev.gui.ExternalBrowser;
import dev.gui.HyperlinkSupport;
import dev.gui.wizard.WizardDialog;
import dev.gui.wizard.WizardPane;
import dev.gui.wizard.WizardPaneHeader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class MessageWizardPane
extends WizardPane
implements ActionListener {
    static ResourceBundle res = ResourceBundle.getBundle("dev.gui.wizard.Res");
    public static final String NAME = "MessageWizardPane";
    WizardPaneHeader fWizardPaneHeader = new WizardPaneHeader();
    JLabel lblMessage = new JLabel(){

        public Dimension getPreferredSize() {
            Dimension result = super.getPreferredSize();
            result.width = 200;
            return result;
        }
    };
    protected HyperlinkSupport fHyperlinkSupport = new HyperlinkSupport(this.lblMessage, new HyperlinkListener(){

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                ExternalBrowser.callBrowser(e.getURL(), (Component)MessageWizardPane.this);
            }
        }
    });
    JPanel pnlFill = new JPanel();
    protected String fMessage;
    protected String fHeaderName;
    protected String fHeaderDescription;
    protected JCheckBox chkConfirmation = new JCheckBox();
    JLabel lblIcon = new JLabel();
    protected String fBackConfirmation;

    public MessageWizardPane() {
        this.setName(NAME);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.chkConfirmation.setVisible(false);
        this.chkConfirmation.setText("");
        this.chkConfirmation.addActionListener(this);
        this.fWizardPaneHeader.setDescriptionText("Description");
        this.fWizardPaneHeader.setNameText("Name");
        this.pnlFill.setMinimumSize(new Dimension(0, 0));
        this.pnlFill.setPreferredSize(new Dimension(0, 0));
        this.lblMessage.setText("");
        this.lblIcon.setText("");
        this.add((Component)this.fWizardPaneHeader, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.lblMessage, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(15, 5, 0, 5), 0, 0));
        this.add((Component)this.pnlFill, new GridBagConstraints(0, 21, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.chkConfirmation, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 21, 2, new Insets(15, 5, 0, 0), 0, 0));
        this.add((Component)this.lblIcon, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(15, 5, 0, 5), 0, 0));
    }

    public String getMessage() {
        return this.fMessage;
    }

    public void setMessage(String aMessage) {
        this.fMessage = aMessage;
        this.lblMessage.setText(this.fMessage);
    }

    public String getHeaderDescription() {
        return this.fWizardPaneHeader.getDescriptionText();
    }

    public void setHeaderDescription(String aHeaderDescription) {
        this.fWizardPaneHeader.setDescriptionText(aHeaderDescription);
    }

    public String getHeaderName() {
        return this.fWizardPaneHeader.getNameText();
    }

    public void setHeaderName(String aHeaderName) {
        this.fWizardPaneHeader.setNameText(aHeaderName);
    }

    public boolean canNext() {
        boolean result;
        boolean bl = result = this.fNextPaneName != null;
        if (result && this.isNeedConfirmation()) {
            result = this.chkConfirmation.isSelected();
        }
        return result;
    }

    public String next() {
        return this.fNextPaneName;
    }

    public String back() {
        String result = super.back();
        if (this.fBackConfirmation != null && WizardDialog.prompt(this, this.fBackConfirmation) != 0) {
            result = "-none-";
        }
        return result;
    }

    public Icon getMessageIcon() {
        return this.lblIcon.getIcon();
    }

    public void setMessageIcon(Icon anIcon) {
        this.lblIcon.setIcon(anIcon);
    }

    public boolean isNeedConfirmation() {
        return this.chkConfirmation.isVisible();
    }

    public void setNeedConfirmation(boolean aValue) {
        this.chkConfirmation.setVisible(aValue);
        if (aValue) {
            this.chkConfirmation.setSelected(false);
        }
        this.update();
    }

    public String getConfirmation() {
        return this.chkConfirmation.getText();
    }

    public void setConfirmation(String aText) {
        this.chkConfirmation.setText(aText);
    }

    public String getBackConfirmation() {
        return this.fBackConfirmation;
    }

    public void setBackConfirmation(String aBackConfirmation) {
        this.fBackConfirmation = aBackConfirmation;
    }

    public boolean canFinish() {
        return false;
    }

    public int finish() {
        return 0;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.chkConfirmation) {
            this.update();
        }
    }
}

