/*
 * Decompiled with CFR 0.152.
 */
package dev.gui.wizard;

import dev.gui.JPasswordFieldEx;
import dev.gui.JTextFieldEx;
import dev.gui.wizard.WizardPane;
import dev.gui.wizard.WizardPaneHeader;
import dev.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;

public class InternetConnectionWizardPane
extends WizardPane {
    static ResourceBundle res = ResourceBundle.getBundle("dev.gui.wizard.Res");
    public static final String NAME = "InternetConnectionWizardPane";
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    WizardPaneHeader wizardPaneHeader1 = new WizardPaneHeader();
    JRadioButton rbtnProxy = new JRadioButton();
    JLabel lblHttpProxyHost = new JLabel();
    JTextFieldEx edtHttpProxyHost = new JTextFieldEx();
    JLabel lblHttpProxyPort = new JLabel();
    JTextFieldEx edtHttpProxyPort = new JTextFieldEx(){

        public Dimension getPreferredSize() {
            Dimension result = super.getPreferredSize();
            result.width = 40;
            return result;
        }
    };
    JRadioButton rbtnDirect = new JRadioButton();
    ButtonGroup fButtonGroup = new ButtonGroup();
    JPanel pnlFill = new JPanel();
    public static final String PROPERTY_USE_PROXY = "useProxy";
    public static final String PROPERTY_HTTP_PROXY_SET = "http.proxySet";
    public static final String PROPERTY_HTTP_PROXY_HOST = "http.proxyHost";
    public static final String PROPERTY_HHTP_PROXY_PORT = "http.proxyPort";
    public static final String PROPERTY_HTTP_PROXY_USER = "http.proxyUser";
    public static final String PROPERTY_HTTP_PROXY_PASSWORD = "http.proxyPassword";
    protected Preferences fPreferences;
    protected boolean fActivated = false;
    JLabel lblHttpProxyUser = new JLabel();
    JTextFieldEx edtHttpProxyUser = new JTextFieldEx();
    JLabel lblHttpProxyPassword = new JLabel();
    JPasswordFieldEx edtHttpProxyPassword = new JPasswordFieldEx();

    public InternetConnectionWizardPane() {
        this.setName(NAME);
        try {
            this.jbInit();
            this.putClientProperty("topicID", "licensing_assistant/connection");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.wizardPaneHeader1.setDescriptionText(res.getString("wizardPaneHeader_DescriptionText"));
        this.wizardPaneHeader1.setNameText(res.getString("wizardPaneHeader_NameText"));
        this.rbtnProxy.setMnemonic('P');
        this.rbtnProxy.setText(res.getString("rbtnProxy_Text"));
        this.rbtnProxy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InternetConnectionWizardPane.this.rbtnProxy_actionPerformed(e);
            }
        });
        this.lblHttpProxyHost.setEnabled(false);
        this.lblHttpProxyHost.setDisplayedMnemonic(res.getString("lblHttpProxyHost_M").charAt(0));
        this.lblHttpProxyHost.setLabelFor(this.edtHttpProxyHost);
        this.lblHttpProxyHost.setText(res.getString("lblHttpProxyHost_Text"));
        this.lblHttpProxyPort.setEnabled(false);
        this.lblHttpProxyPort.setDisplayedMnemonic(res.getString("lblHttpProxyPort_M").charAt(0));
        this.lblHttpProxyPort.setLabelFor(this.edtHttpProxyPort);
        this.lblHttpProxyPort.setText(res.getString("lblHttpProxyPort_Text"));
        this.rbtnDirect.setMnemonic('D');
        this.rbtnDirect.setSelected(true);
        this.rbtnDirect.setText(res.getString("rbtnDirect_Text"));
        this.rbtnDirect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InternetConnectionWizardPane.this.rbtnDirect_actionPerformed(e);
            }
        });
        this.edtHttpProxyHost.setEnabled(false);
        this.edtHttpProxyHost.setText("");
        this.edtHttpProxyPort.setEnabled(false);
        this.edtHttpProxyPort.setText("0");
        this.pnlFill.setMinimumSize(new Dimension(0, 0));
        this.lblHttpProxyUser.setEnabled(false);
        this.lblHttpProxyUser.setDisplayedMnemonic('U');
        this.lblHttpProxyUser.setLabelFor(this.edtHttpProxyUser);
        this.lblHttpProxyUser.setText("User:");
        this.edtHttpProxyUser.setEnabled(false);
        this.edtHttpProxyUser.setPreferredWidth(150);
        this.edtHttpProxyUser.setMinimumWidth(150);
        this.lblHttpProxyPassword.setEnabled(false);
        this.lblHttpProxyPassword.setDisplayedMnemonic('W');
        this.lblHttpProxyPassword.setLabelFor(this.edtHttpProxyPassword);
        this.lblHttpProxyPassword.setText("Password:");
        this.edtHttpProxyPassword.setEnabled(false);
        this.edtHttpProxyPassword.setPreferredWidth(150);
        this.edtHttpProxyPassword.setMinimumWidth(150);
        this.add((Component)this.wizardPaneHeader1, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.rbtnProxy, new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.lblHttpProxyHost, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 15, 0, 0), 0, 0));
        this.add((Component)this.edtHttpProxyHost, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.rbtnDirect, new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 21, 0, new Insets(15, 5, 0, 0), 0, 0));
        this.add((Component)this.lblHttpProxyPort, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.edtHttpProxyPort, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.fButtonGroup.add(this.rbtnDirect);
        this.fButtonGroup.add(this.rbtnProxy);
        this.add((Component)this.pnlFill, new GridBagConstraints(1, 20, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.edtHttpProxyUser, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.lblHttpProxyUser, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 15, 0, 0), 0, 0));
        this.add((Component)this.lblHttpProxyPassword, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 15, 0, 0), 0, 0));
        this.add((Component)this.edtHttpProxyPassword, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 0, 0), 0, 0));
    }

    protected void enableProxy() {
        boolean e = this.rbtnProxy.isSelected();
        this.lblHttpProxyPort.setEnabled(e);
        this.edtHttpProxyPort.setEnabled(e);
        this.lblHttpProxyHost.setEnabled(e);
        this.edtHttpProxyHost.setEnabled(e);
        this.lblHttpProxyUser.setEnabled(e);
        this.edtHttpProxyUser.setEnabled(e);
        this.lblHttpProxyPassword.setEnabled(e);
        this.edtHttpProxyPassword.setEnabled(e);
    }

    public boolean checkValid() {
        boolean result = true;
        if (this.rbtnProxy.isSelected()) {
            if ("".equals(this.edtHttpProxyHost.getText())) {
                this.error(res.getString("Proxy_Host_Invalid"));
                this.edtHttpProxyHost.requestFocus();
                result = false;
            } else if ("".equals(this.edtHttpProxyPort.getText())) {
                this.error(res.getString("Proxy_Port_Invalid"));
                this.edtHttpProxyPort.requestFocus();
                result = false;
            }
        }
        return result;
    }

    public boolean canNext() {
        return false;
    }

    public int finish() {
        return this.checkValid() && this.saveConnectionParams() ? 1 : 0;
    }

    public String next() {
        return this.checkValid() && this.saveConnectionParams() ? this.fNextPaneName : "-none-";
    }

    public boolean canFinish() {
        return true;
    }

    public Preferences getPreferences() {
        return this.fPreferences;
    }

    public void setPreferences(Preferences aPreferences) {
        this.fPreferences = aPreferences;
    }

    protected boolean saveConnectionParams() {
        boolean isUseProxy = this.rbtnProxy.isSelected();
        String httpProxyHost = isUseProxy ? this.edtHttpProxyHost.getText() : null;
        String httpProxyPort = isUseProxy ? this.edtHttpProxyPort.getText() : null;
        String httpProxyUser = isUseProxy ? this.edtHttpProxyUser.getText() : null;
        String httpProxyPassword = isUseProxy ? new String(this.edtHttpProxyPassword.getPassword()) : null;
        this.setSystemProperty(PROPERTY_HTTP_PROXY_SET, isUseProxy ? "true" : null);
        this.setSystemProperty(PROPERTY_HTTP_PROXY_HOST, httpProxyHost);
        this.setSystemProperty(PROPERTY_HHTP_PROXY_PORT, httpProxyPort);
        this.setSystemProperty(PROPERTY_HTTP_PROXY_USER, httpProxyUser);
        this.setSystemProperty(PROPERTY_HTTP_PROXY_PASSWORD, httpProxyPassword);
        this.putPreference(PROPERTY_USE_PROXY, Boolean.toString(this.rbtnProxy.isSelected()));
        this.putPreference(PROPERTY_HTTP_PROXY_HOST, httpProxyHost);
        this.putPreference(PROPERTY_HHTP_PROXY_PORT, httpProxyPort);
        this.putPreference(PROPERTY_HTTP_PROXY_USER, httpProxyUser);
        this.putPreference(PROPERTY_HTTP_PROXY_PASSWORD, httpProxyPassword);
        return true;
    }

    protected void setSystemProperty(String aName, String aValue) {
        if (!StringUtils.noValue(aValue)) {
            System.setProperty(aName, aValue);
        } else {
            System.clearProperty(aName);
        }
    }

    protected void putPreference(String aName, String aValue) {
        Preferences preferences = this.getPreferences();
        if (preferences != null) {
            if (aValue != null) {
                preferences.put(aName, aValue);
            } else {
                preferences.remove(aName);
            }
        }
    }

    public void activate(String aBackPaneName) {
        super.activate(aBackPaneName);
        if (!this.fromSystemProperties()) {
            this.fromPreferences();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (InternetConnectionWizardPane.this.rbtnDirect.isSelected()) {
                    InternetConnectionWizardPane.this.rbtnDirect.requestFocus();
                } else if (InternetConnectionWizardPane.this.rbtnProxy.isSelected()) {
                    InternetConnectionWizardPane.this.edtHttpProxyHost.requestFocus();
                }
            }
        });
        this.fActivated = true;
    }

    private boolean fromSystemProperties() {
        boolean useProxy;
        boolean result = false;
        boolean bl = useProxy = "true".equals(System.getProperty(PROPERTY_HTTP_PROXY_SET)) || !StringUtils.noValue(System.getProperty(PROPERTY_HTTP_PROXY_HOST));
        if (useProxy) {
            result = true;
            this.rbtnProxy.doClick();
            this.edtHttpProxyHost.setText(System.getProperty(PROPERTY_HTTP_PROXY_HOST));
            this.edtHttpProxyPort.setText(System.getProperty(PROPERTY_HHTP_PROXY_PORT));
            this.edtHttpProxyUser.setText(System.getProperty(PROPERTY_HTTP_PROXY_USER));
            this.edtHttpProxyPassword.setText(System.getProperty(PROPERTY_HTTP_PROXY_PASSWORD));
        }
        return result;
    }

    private void fromPreferences() {
        Preferences preferences = this.getPreferences();
        if (preferences != null) {
            boolean useProxy = preferences.get(PROPERTY_USE_PROXY, Boolean.toString(false)).equals(Boolean.toString(true));
            if (useProxy) {
                this.rbtnProxy.doClick();
            }
            this.edtHttpProxyHost.setText(useProxy ? preferences.get(PROPERTY_HTTP_PROXY_HOST, null) : null);
            this.edtHttpProxyPort.setText(useProxy ? preferences.get(PROPERTY_HHTP_PROXY_PORT, null) : null);
            this.edtHttpProxyUser.setText(useProxy ? preferences.get(PROPERTY_HTTP_PROXY_USER, null) : null);
            this.edtHttpProxyPassword.setText(useProxy ? preferences.get(PROPERTY_HTTP_PROXY_PASSWORD, null) : null);
        }
    }

    void rbtnDirect_actionPerformed(ActionEvent e) {
        this.enableProxy();
    }

    void rbtnProxy_actionPerformed(ActionEvent e) {
        this.enableProxy();
    }
}

