/*
 * Decompiled with CFR 0.152.
 */
package dev.gui.wizard;

import dev.gui.JScrollPaneEx;
import dev.gui.wizard.CheckBoxFormComponentDef;
import dev.gui.wizard.DividerFormComponentDef;
import dev.gui.wizard.FormComponent;
import dev.gui.wizard.FormComponentDef;
import dev.gui.wizard.TextFieldFormComponentDef;
import dev.gui.wizard.WizardDialog;
import dev.gui.wizard.WizardPane;
import dev.gui.wizard.WizardPaneHeader;
import dev.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class FormWizardPane
extends WizardPane {
    protected JPanel pnlContent = new JPanel();
    protected JPanel pnlFillY = new JPanel();
    protected JScrollPaneEx scrContent = new JScrollPaneEx(this.pnlContent);
    protected List fFormComponents = new ArrayList();
    protected List fFormComponentDefs = new ArrayList();
    protected Map fVariableContext = new HashMap();
    protected int fPreferredWidth = -1;
    protected boolean fNeedAddPropertyChangeListener = true;

    public FormWizardPane() {
        super(new GridBagLayout());
        this.scrContent.setRetainBorder(false);
        this.scrContent.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.scrContent, new GridBagConstraints(0, 40, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlContent.setLayout(new GridBagLayout());
        this.pnlFillY.setMinimumSize(new Dimension(0, 0));
        this.pnlContent.add((Component)this.pnlFillY, new GridBagConstraints(0, 40, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    public JPanel getContentPane() {
        return this.pnlContent;
    }

    public boolean canFinish() {
        return true;
    }

    public int finish() {
        this.checkValid();
        return 0;
    }

    public void activate(String aBackPaneName) {
        super.activate(aBackPaneName);
        if (!this.fFormComponents.isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Iterator iterator = FormWizardPane.this.fFormComponents.iterator();
                    while (iterator.hasNext() && !((FormComponent)iterator.next()).requestFocus()) {
                    }
                }
            });
        }
    }

    public boolean checkValid() {
        boolean result = true;
        Iterator iterator = this.fFormComponents.iterator();
        while (result && iterator.hasNext()) {
            FormComponent formComponent = (FormComponent)iterator.next();
            result = formComponent.checkValid();
            if (result) continue;
            this.error("'" + formComponent.getFormComponentDef().getName() + "' should be specified.");
            formComponent.requestFocus();
        }
        return result;
    }

    public void createFormComponents() {
        int row = 1;
        for (FormComponentDef formComponentDef : this.fFormComponentDefs) {
            FormComponent formComponent = formComponentDef.createFormComponent();
            row += formComponent.createFormComponents(this, row);
            this.fFormComponents.add(formComponent);
        }
    }

    public void releaseFormComponents() {
        for (FormComponent formComponent : this.fFormComponents) {
            formComponent.releaseFormComponents(this);
            this.fFormComponents.remove(formComponent);
        }
    }

    public void addFormComponentDefs(List aFormComponentDefs) {
        this.fFormComponentDefs.addAll(aFormComponentDefs);
    }

    public void addFormComponentDef(FormComponentDef aFormComponentDef) {
        this.fFormComponentDefs.add(aFormComponentDef);
    }

    public void removeFormComponentDef(FormComponentDef aFormComponentDef) {
        this.fFormComponentDefs.remove(aFormComponentDef);
    }

    public void removeAllFormComponentDefs() {
        this.releaseFormComponents();
        this.fFormComponentDefs.clear();
    }

    public Map getValues() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (FormComponent formComponent : this.fFormComponents) {
            if (formComponent.getFormComponentDef().getID() == null) continue;
            result.put(formComponent.getFormComponentDef().getID(), formComponent.getValue());
        }
        return result;
    }

    public void setValues(Map aValues) {
        for (FormComponent formComponent : this.fFormComponents) {
            formComponent.setValue((String)aValues.get(formComponent.getFormComponentDef().getID()));
        }
    }

    public Map getVariableContext() {
        return this.fVariableContext;
    }

    public void setVariableContext(Map aVariableContext) {
        this.fVariableContext = aVariableContext;
    }

    public String expandMacro(String aMacro) {
        return aMacro != null ? StringUtils.expandMacro(aMacro, this.getVariableContext()) : null;
    }

    public String[] expandMacro(String[] aMacro) {
        String[] result;
        String[] stringArray = result = aMacro != null ? new String[aMacro.length] : null;
        if (result != null) {
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.expandMacro(aMacro[i]);
            }
        }
        return result;
    }

    public Dimension getPreferredSize() {
        Dimension result = super.getPreferredSize();
        if (this.fPreferredWidth != -1) {
            result.width = this.fPreferredWidth;
        }
        return result;
    }

    public int getPreferredWidth() {
        return this.fPreferredWidth;
    }

    public void setPreferredWidth(int aPreferredWidth) {
        this.fPreferredWidth = aPreferredWidth;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("focusOwner".equals(propertyName) || "permanentFocusOwner".equals(propertyName)) {
            this.ensureComponentVisible((Component)evt.getNewValue());
        }
    }

    protected void ensureComponentVisible(Component aFocusOwner) {
        if (SwingUtilities.getAncestorOfClass(FormWizardPane.class, aFocusOwner) != null) {
            this.scrContent.getViewport().scrollRectToVisible(SwingUtilities.convertRectangle(aFocusOwner.getParent(), aFocusOwner.getBounds(), this.scrContent.getViewport()));
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.fNeedAddPropertyChangeListener) {
            FocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this);
        }
        this.fNeedAddPropertyChangeListener = false;
    }

    public void removeNotify() {
        FocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this);
        this.fNeedAddPropertyChangeListener = true;
        super.removeNotify();
    }

    public static void showWizardPreview(Component anOwner, String aTitle, String aName, String aDescription, List aFormComponentDefs, Map aVariableContext) {
        FormWizardPane.showWizardPreview(anOwner, aTitle, aName, aDescription, null, aFormComponentDefs, aVariableContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showWizardPreview(Component anOwner, String aTitle, String aName, String aDescription, Icon aWizardIcon, List aFormComponentDefs, Map aVariableContext) {
        Window w = SwingUtilities.getWindowAncestor(anOwner);
        WizardDialog wizardDialog = w instanceof Frame ? new WizardDialog((Frame)w) : (w instanceof Dialog ? new WizardDialog((Dialog)w) : new WizardDialog());
        try {
            wizardDialog.setTitle(aTitle);
            if (aWizardIcon != null) {
                wizardDialog.setWizardIcon(aWizardIcon);
            }
            FormWizardPane pane = new FormWizardPane();
            pane.setVariableContext(aVariableContext);
            pane.setName("preview");
            WizardPaneHeader header = new WizardPaneHeader();
            header.setNameText(pane.expandMacro(aName));
            header.setDescriptionText(pane.expandMacro(aDescription));
            pane.add((Component)header, new GridBagConstraints(0, 0, 11, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            pane.setPreferredSize(new Dimension(350, 300));
            pane.addFormComponentDefs(aFormComponentDefs);
            pane.createFormComponents();
            wizardDialog.addWizardPane(pane);
            wizardDialog.setActiveWizardPane(pane);
            wizardDialog.executeModal();
        }
        finally {
            wizardDialog.dispose();
        }
    }

    public static void main(String[] args) {
        ArrayList<FormComponentDef> list = new ArrayList<FormComponentDef>();
        list.add(new DividerFormComponentDef("Just Label"));
        list.add(new TextFieldFormComponentDef("_name", "Name", "", null, true, "(###)"));
        list.add(new CheckBoxFormComponentDef("_contact_me", "Contact me a", "a", true));
        list.add(new TextFieldFormComponentDef("_descr", "Description", "", null, false));
        list.add(new TextFieldFormComponentDef("_descr1", "Description1", "", null, false));
        list.add(new TextFieldFormComponentDef("_descr2", "Description2", "", null, false));
        list.add(new TextFieldFormComponentDef("_descr3", "Description3", "", null, false));
        list.add(new TextFieldFormComponentDef("_descr4", "Description4", "", null, false));
        list.add(new TextFieldFormComponentDef("_descr5", "Description5", "", null, false));
        list.add(new TextFieldFormComponentDef("_descr6", "Description6", "", null, false));
        list.add(new TextFieldFormComponentDef("_descr7", "Description7", "", null, false));
        list.add(new TextFieldFormComponentDef("_descr8", "Description8", "", null, false));
        list.add(new TextFieldFormComponentDef("_descr9", "Description9", "", null, false));
        FormWizardPane.showWizardPreview(new JFrame(), "Custom Form Preview", "Test", "Test", list, null);
        System.exit(0);
    }
}

