/*
 * Decompiled with CFR 0.152.
 */
package dev.gui.wizard;

import dev.gui.wizard.CheckBoxFormComponentDef;
import dev.gui.wizard.FormComponent;
import dev.gui.wizard.FormComponentDef;
import dev.gui.wizard.FormWizardPane;
import dev.util.StringUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JCheckBox;

public class CheckBoxFormComponent
implements FormComponent {
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    protected JCheckBox fCheckBox;
    protected CheckBoxFormComponentDef fFormComponentDef;

    public CheckBoxFormComponent(CheckBoxFormComponentDef aCheckBoxFormComponentDef) {
        this.fFormComponentDef = aCheckBoxFormComponentDef;
    }

    public FormComponentDef getFormComponentDef() {
        return this.fFormComponentDef;
    }

    public String getValue() {
        return this.fCheckBox.isSelected() ? TRUE : FALSE;
    }

    public void setValue(String aValue) {
        this.fCheckBox.setSelected(TRUE.equals(aValue));
    }

    public boolean checkValid() {
        return true;
    }

    public boolean requestFocus() {
        this.fCheckBox.requestFocus();
        return true;
    }

    public int createFormComponents(FormWizardPane aContainer, int aRow) {
        this.fCheckBox = new JCheckBox(aContainer.expandMacro(this.fFormComponentDef.getName()));
        String toolTipText = aContainer.expandMacro(this.fFormComponentDef.getDescription());
        this.fCheckBox.setToolTipText(!StringUtils.noValue(toolTipText) ? toolTipText : null);
        this.fCheckBox.setSelected(TRUE.equals(this.fFormComponentDef.getDefaultValue()));
        Insets insets = (Insets)this.fFormComponentDef.getInsets().clone();
        insets.top += 5;
        aContainer.getContentPane().add((Component)this.fCheckBox, new GridBagConstraints(0, aRow, 11, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        return 1;
    }

    public void releaseFormComponents(FormWizardPane aContainer) {
        aContainer.getContentPane().remove(this.fCheckBox);
        this.fCheckBox = null;
    }
}

