/*
 * Decompiled with CFR 0.152.
 */
package dev.gui.pane;

import dev.gui.UIUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class HeaderPane
extends JPanel {
    public static final int STYLE_GRADIENT = 1;
    public static final int STYLE_3D = 2;
    public static final int STYLE_GRADIENT_V = 3;
    protected int fStyle = 1;
    String fName;
    String fDescription;
    JLabel lblName = new JLabel(){

        public void setFont(Font font) {
            super.setFont(new FontUIResource(font.deriveFont(1, font.getSize() + 2)));
        }
    };
    JLabel lblDescription = new JLabel(){

        public void setFont(Font font) {
            super.setFont(new FontUIResource(font.deriveFont(0)));
        }
    };
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public HeaderPane() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public int getStyle() {
        return this.fStyle;
    }

    public void setStyle(int aStyle) {
        if (this.fStyle != aStyle) {
            this.fStyle = aStyle;
            if (this.isShowing()) {
                this.repaint();
            }
        }
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Paint paint = g2d.getPaint();
        Rectangle r = this.getBounds();
        if (this.fStyle == 1) {
            g2d.setPaint(UIUtils.getHeaderPaint(this, UIManager.getColor("control"), r.getSize()));
            g2d.fill(new Rectangle(0, 1, r.width - 2, r.height - 2));
        } else if (this.fStyle == 3) {
            g2d.setPaint(UIUtils.getHeaderPaintV(UIManager.getColor("control"), r.getSize()));
            g2d.fill(new Rectangle(0, 1, r.width - 2, r.height - 2));
        } else if (this.fStyle == 2) {
            g2d.setPaint(UIUtils.getToolbarPaint(UIManager.getColor("control"), r.getSize()));
            g2d.fill(new Rectangle(0, 1, r.width - 2, r.height - 2));
        }
        g2d.setPaint(paint);
        super.paint(g);
    }

    public boolean isDescriptionVisible() {
        return this.lblDescription.isVisible();
    }

    public void setDescriptionVisible(boolean aFlag) {
        this.lblDescription.setVisible(aFlag);
    }

    public String getDescriptionText() {
        return this.lblDescription.getText();
    }

    public void setDescriptionText(String aDescription) {
        this.lblDescription.setText(aDescription);
    }

    public String getNameText() {
        return this.lblName.getText();
    }

    public void setNameText(String aName) {
        this.lblName.setText(aName);
    }

    public Icon getNameIcon() {
        return this.lblName.getIcon();
    }

    public void setNameIcon(Icon icon) {
        this.lblName.setIcon(icon);
    }

    private void jbInit() throws Exception {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.setMinimumSize(new Dimension(0, 0));
        this.add((Component)this.lblName, new GridBagConstraints(0, 0, 1, 1, 100.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.lblDescription, new GridBagConstraints(0, 1, 1, 1, 100.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
    }
}

