/*
 * Decompiled with CFR 0.152.
 */
package dev.gui.net;

import dev.gui.Throbber;
import dev.net.NetworkDiscovery;
import dev.net.NetworkDiscoveryListener;
import dev.net.NetworkDiscoveryPacket;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.net.InetAddress;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class NetworkDiscoveryProgress
extends JPanel
implements NetworkDiscoveryListener {
    Throbber fThrobber = new Throbber();
    JLabel lblStatus = new JLabel();
    protected static final MessageFormat FMT_FINDING = new MessageFormat("Searching... Found:  {0}");
    protected static final MessageFormat FMT_FOUND = new MessageFormat("Found: {0}");
    protected int fCount = 0;
    protected MessageFormat fFindingFormat = FMT_FINDING;
    protected MessageFormat fFoundFormat = FMT_FOUND;

    public NetworkDiscoveryProgress() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.lblStatus.setText("Progress");
        this.fThrobber.setBorder(new EmptyBorder(0, 0, 0, 5));
        this.fThrobber.setPreferredSize(new Dimension(20, 15));
        this.fThrobber.setTicksNumber(12);
        this.fThrobber.setFillBounds(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.fThrobber, "Before");
        this.add((Component)this.lblStatus, "Center");
        this.fThrobber.setVisible(false);
    }

    public MessageFormat getFindingFormat() {
        return this.fFindingFormat;
    }

    public void setFindingFormat(MessageFormat aFindingFormat) {
        this.fFindingFormat = aFindingFormat;
    }

    public MessageFormat getFoundFormat() {
        return this.fFoundFormat;
    }

    public void setFoundFormat(MessageFormat aFoundFormat) {
        this.fFoundFormat = aFoundFormat;
    }

    public void networkDiscoveryStarted(NetworkDiscovery aNetworkDiscovery) {
        this.fCount = 0;
        this.fThrobber.setVisible(true);
        this.fThrobber.start();
        this.updateProgress();
    }

    public void networkDiscoveryFinished(NetworkDiscovery aNetworkDiscovery) {
        this.fThrobber.stop();
        this.fThrobber.setVisible(false);
        this.updateProgress();
    }

    public void addressDiscovered(NetworkDiscovery aNetworkDiscovery, InetAddress anAddress, NetworkDiscoveryPacket aPacket) {
        ++this.fCount;
        this.updateProgress();
    }

    protected void updateProgress() {
        if (this.fThrobber.isRunning()) {
            this.lblStatus.setText(this.fFindingFormat != null ? this.fFindingFormat.format(new Object[]{new Integer(this.fCount)}) : null);
        } else {
            this.lblStatus.setText(this.fFoundFormat != null ? this.fFoundFormat.format(new Object[]{new Integer(this.fCount)}) : null);
        }
    }
}

