/*
 * Decompiled with CFR 0.152.
 */
package dev.gui.net;

import dev.gui.DelayedInvoker;
import dev.gui.JComboBoxEx;
import dev.net.NetworkDiscovery;
import dev.net.NetworkDiscoveryListener;
import dev.net.NetworkDiscoveryPacket;
import dev.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;

public class NetworkDiscoveryCombobox
extends JComboBoxEx
implements NetworkDiscoveryListener {
    protected NetworkDiscovery fNetworkDiscovery;
    protected DelayedInvoker fStopDelayedInvoker = new DelayedInvoker(7000, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            NetworkDiscoveryCombobox.this.stop();
        }
    });
    protected boolean fSelectFirstAddress = false;

    public NetworkDiscovery getNetworkDiscovery() {
        return this.fNetworkDiscovery;
    }

    public void setNetworkDiscovery(NetworkDiscovery aNetworkDiscovery) {
        if (this.fNetworkDiscovery != null) {
            this.fNetworkDiscovery.removeNetworkDiscoveryListener(this);
        }
        this.fNetworkDiscovery = aNetworkDiscovery;
        if (this.fNetworkDiscovery != null) {
            this.fNetworkDiscovery.addNetworkDiscoveryListener(this);
        }
    }

    public void start() {
        if (this.fNetworkDiscovery != null) {
            this.fNetworkDiscovery.start();
            this.fStopDelayedInvoker.start();
        }
    }

    public void stop() {
        if (this.fNetworkDiscovery != null) {
            this.fNetworkDiscovery.stop();
        }
        this.fStopDelayedInvoker.stop();
    }

    public void removeNotify() {
        this.stop();
        super.removeNotify();
    }

    public int getDiscoveryTimeout() {
        return this.fStopDelayedInvoker.getDelay();
    }

    public void setDiscoveryTimeout(int aTimeout) {
        this.fStopDelayedInvoker.setDelay(aTimeout);
        if (this.fStopDelayedInvoker.isRunning()) {
            this.fStopDelayedInvoker.takeUp(aTimeout);
        }
    }

    public void networkDiscoveryStarted(NetworkDiscovery aNetworkDiscovery) {
    }

    public void networkDiscoveryFinished(NetworkDiscovery aNetworkDiscovery) {
    }

    public boolean isSelectFirstAddress() {
        return this.fSelectFirstAddress;
    }

    public void setSelectFirstAddress(boolean aSelectFirstAddress) {
        this.fSelectFirstAddress = aSelectFirstAddress;
    }

    public void addressDiscovered(NetworkDiscovery aNetworkDiscovery, InetAddress anAddress, NetworkDiscoveryPacket aPacket) {
        String port;
        String name = anAddress.getHostName();
        if (name == null) {
            name = anAddress.getHostAddress();
        }
        if (!StringUtils.noValue(port = (String)aPacket.getAttributes().get("port"))) {
            name = name + ":" + port;
        }
        boolean needAdd = true;
        for (int i = 0; needAdd && i < this.getItemCount(); ++i) {
            needAdd = !name.equals(this.getItemAt(i));
        }
        if (needAdd) {
            this.addItem(name);
        }
        if (StringUtils.noValue((String)this.getSelectedItem()) && this.fSelectFirstAddress) {
            this.setSelectedItem(name);
        }
    }
}

