/*
 * Decompiled with CFR 0.152.
 */
package dev.gui.insight;

import dev.gui.ComponentPainterHolder;
import dev.gui.IconComponentPainter;
import dev.gui.InitializableComponentPainter;
import dev.gui.insight.TextInsightConsumer;
import dev.gui.insight.TextInsightDelegate;
import dev.gui.insight.TextInsightDelegateProxy;
import dev.lang.BitTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class TextInsightDelegateSupport
extends MouseAdapter
implements KeyListener,
TextInsightConsumer {
    protected JTextComponent fComponent;
    protected TextInsightDelegate fInsightDelegate;
    protected boolean fEnabled = false;
    protected Class fInsightDelegateClass = TextInsightDelegate.class;
    protected MarkComponentPainter fMarkComponentPainter = new MarkComponentPainter();

    public TextInsightDelegateSupport(JTextComponent aComponent) {
        this.fComponent = aComponent;
        this.fComponent.addMouseListener(this);
        this.fComponent.addKeyListener(this);
    }

    protected int getFlipHeight() {
        try {
            Rectangle r = this.fComponent.modelToView(this.fComponent.getCaretPosition());
            return r.height;
        }
        catch (BadLocationException ex) {
            return this.fComponent.getHeight();
        }
    }

    protected Point getInsightLocation() {
        try {
            Rectangle r = this.fComponent.modelToView(this.fComponent.getCaretPosition());
            Point result = r.getLocation();
            result.y += r.height;
            return result;
        }
        catch (BadLocationException ex) {
            return null;
        }
    }

    protected String[] doPrimaryAction() {
        return this.fInsightDelegate.doPrimaryAction(this.fComponent, this, this.getInsightLocation(), this.getFlipHeight());
    }

    protected String[] doSecondaryAction() {
        return this.fInsightDelegate.doSecondaryAction(this.fComponent, this, this.getInsightLocation(), this.getFlipHeight());
    }

    protected void processInsightResult(String[] aResult) {
        if (aResult != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < aResult.length; ++i) {
                stringBuffer.append(aResult[i]);
            }
            this.fComponent.replaceSelection(stringBuffer.toString());
        }
    }

    public void consumePrimaryAction(String[] aValues) {
        if (aValues != null) {
            this.processInsightResult(aValues);
        }
    }

    public void consumeSecondaryAction(String[] aValues) {
        if (aValues != null) {
            this.processInsightResult(aValues);
        }
    }

    public TextInsightDelegate getInsightDelegate() {
        return this.fInsightDelegate;
    }

    public void setInsightDelegate(TextInsightDelegate aInsightDelegate) {
        if (this.fInsightDelegate != null && this.fComponent instanceof ComponentPainterHolder) {
            ((ComponentPainterHolder)((Object)this.fComponent)).removeComponentPainter(this.fMarkComponentPainter);
        }
        this.fInsightDelegate = aInsightDelegate;
        if (this.fInsightDelegate != null && this.fComponent instanceof ComponentPainterHolder) {
            ((ComponentPainterHolder)((Object)this.fComponent)).addComponentPainter(this.fMarkComponentPainter);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.fInsightDelegate != null && BitTools.checkBit(e.getModifiers(), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) {
            e.consume();
            this.processInsightResult(this.doPrimaryAction());
        }
    }

    public void keyReleased(KeyEvent e) {
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if (this.fInsightDelegate != null && e.getKeyCode() == 32 && BitTools.checkBit(e.getModifiers(), mask)) {
            e.consume();
            if (e.getModifiers() == (mask | 1)) {
                this.processInsightResult(this.doSecondaryAction());
            } else if (e.getModifiers() == mask) {
                this.processInsightResult(this.doPrimaryAction());
            }
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public void setEnabled(boolean aEnabled) {
        if (this.fEnabled != aEnabled) {
            this.fEnabled = aEnabled;
            if (this.fEnabled) {
                this.onAddNotify();
            } else {
                this.onRemoveNotify();
            }
        }
    }

    public Class getInsightDelegateClass() {
        return this.fInsightDelegateClass;
    }

    public void setInsightDelegateClass(Class aInsightDelegateClass) {
        this.fInsightDelegateClass = aInsightDelegateClass;
    }

    public void onAddNotify() {
        if (this.isEnabled()) {
            TextInsightDelegate delegate = null;
            for (Container parent = this.fComponent.getParent(); delegate == null && parent != null; parent = parent.getParent()) {
                if (this.fInsightDelegateClass.isAssignableFrom(parent.getClass())) {
                    delegate = (TextInsightDelegate)((Object)parent);
                    continue;
                }
                if (!TextInsightDelegateProxy.class.isAssignableFrom(parent.getClass()) || !this.fInsightDelegateClass.isAssignableFrom(((TextInsightDelegateProxy)((Object)parent)).getTextInsightDelegate().getClass())) continue;
                delegate = ((TextInsightDelegateProxy)((Object)parent)).getTextInsightDelegate();
            }
            this.setInsightDelegate(delegate);
        }
    }

    public void onRemoveNotify() {
        this.setInsightDelegate(null);
    }

    public static class MarkComponentPainter
    extends IconComponentPainter
    implements InitializableComponentPainter,
    FocusListener,
    Icon {
        public static final Color COLOR = new Color(0, 0, 255, 192);

        public MarkComponentPainter() {
            this.setIcon(this);
            this.fAlignment = 12;
        }

        public void init(Component aComponent) {
            aComponent.addFocusListener(this);
        }

        public void release(Component aComponent) {
            aComponent.removeFocusListener(this);
        }

        public void focusGained(FocusEvent e) {
            e.getComponent().repaint();
        }

        public void focusLost(FocusEvent e) {
            e.getComponent().repaint();
        }

        public int getIconHeight() {
            return 5;
        }

        public int getIconWidth() {
            return 5;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c.hasFocus()) {
                Graphics2D g2d = (Graphics2D)g;
                Object rendering = g2d.getRenderingHint(RenderingHints.KEY_RENDERING);
                Object anitaliasing = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(COLOR);
                g2d.fillPolygon(new int[]{5, 5, 0}, new int[]{0, 5, 5}, 3);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, rendering);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, anitaliasing);
            }
        }
    }
}

