/*
 * Decompiled with CFR 0.152.
 */
package dev.gui.field;

import dev.gui.GenericFileFilter;
import dev.gui.JTextFieldEx;
import dev.gui.field.ButtonField;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;

public class FileChooserField
extends ButtonField
implements DocumentListener {
    public static final String PROPERTY_DEFAULT_FOLDER = "defaultFolder";
    public static final String PROPERTY_VALUE = "value";
    protected String fDefaultFolder;
    protected JFileChooser fFileChooser;
    protected FileFilter[] fChoosableFileFilters;
    protected FileFilter fDefaultChoosableFileFilter;
    public boolean fUseNativeFileChooser = false;
    protected FileDialog fFileDialog;
    protected String fTitle;
    protected Timer fUpdateTimer = new Timer(1000, this);

    public FileChooserField() {
        this(new JTextFieldEx());
    }

    public void requestFocus() {
        if (this.fField != null) {
            this.fField.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        if (this.fField != null) {
            return this.fField.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    public FileChooserField(JComponent aFieldComponent) {
        super(aFieldComponent);
        this.addActionListener(this);
        this.fUpdateTimer.setRepeats(false);
    }

    protected void chooseFile() {
        String value = this.chooseFile(this.getValue());
        if (value != null) {
            this.setValue(value);
        }
    }

    public void setField(JComponent aField) {
        if (this.fField != null && this.fField instanceof JTextComponent) {
            ((JTextComponent)this.fField).getDocument().removeDocumentListener(this);
        }
        super.setField(aField);
        if (this.fField != null && this.fField instanceof JTextComponent) {
            ((JTextComponent)this.fField).getDocument().addDocumentListener(this);
        }
    }

    public File getFile() {
        String value = this.getValue();
        return value != null ? new File(value) : null;
    }

    public String getValue() {
        return ((JTextField)this.fField).getText();
    }

    public void setValue(String aValue) {
        JTextField textField = (JTextField)this.fField;
        String oldValue = textField.getText();
        textField.setText(aValue);
        this.firePropertyChange(PROPERTY_VALUE, oldValue, aValue);
    }

    public String getDefaultFolder() {
        return this.fDefaultFolder;
    }

    public void setDefaultFolder(String aDefaultFolder) {
        String oldValue = this.fDefaultFolder;
        this.fDefaultFolder = aDefaultFolder;
        this.firePropertyChange(PROPERTY_DEFAULT_FOLDER, oldValue, aDefaultFolder);
    }

    public void setFile(File aFile) {
        this.setValue(aFile != null ? aFile.getPath() : null);
    }

    public FileFilter getDefaultChoosableFileFilter() {
        return this.fDefaultChoosableFileFilter;
    }

    public void setDefaultChoosableFileFilter(FileFilter aDefaultChoosableFileFilter) {
        this.fDefaultChoosableFileFilter = aDefaultChoosableFileFilter;
    }

    public FileFilter[] getChoosableFileFilters() {
        return this.fChoosableFileFilters;
    }

    public void setChoosableFileFilters(String[][] aChoosableFileFilters) {
        FileFilter[] choosableFileFilters = new FileFilter[aChoosableFileFilters.length];
        for (int i = 0; i < aChoosableFileFilters.length; ++i) {
            choosableFileFilters[i] = new GenericFileFilter(aChoosableFileFilters[i][0], aChoosableFileFilters[i][1]);
        }
        this.setChoosableFileFilters(choosableFileFilters);
    }

    public void setChoosableFileFilters(FileFilter[] aChoosableFileFilters) {
        this.fChoosableFileFilters = aChoosableFileFilters;
        if (this.fFileChooser != null) {
            this.fFileChooser.resetChoosableFileFilters();
            for (int i = 0; this.fChoosableFileFilters != null && i < this.fChoosableFileFilters.length; ++i) {
                this.fFileChooser.addChoosableFileFilter(this.fChoosableFileFilters[i]);
            }
        }
    }

    public JFileChooser getFileChooser() {
        if (this.fFileChooser == null) {
            this.fFileChooser = new JFileChooser();
            for (int i = 0; this.fChoosableFileFilters != null && i < this.fChoosableFileFilters.length; ++i) {
                this.fFileChooser.addChoosableFileFilter(this.fChoosableFileFilters[i]);
            }
        }
        return this.fFileChooser;
    }

    public boolean isUseNativeFileChooser() {
        return this.fUseNativeFileChooser;
    }

    public void setUseNativeFileChooser(boolean aValue) {
        if (this.fUseNativeFileChooser != aValue) {
            this.fUseNativeFileChooser = aValue;
            this.fFileChooser = null;
            if (this.fFileDialog != null) {
                this.fFileDialog.dispose();
                this.fFileDialog = null;
            }
        }
    }

    public FileDialog getFileDialog() {
        Window w = SwingUtilities.getWindowAncestor(this);
        if (this.fFileDialog == null || this.fFileDialog.getOwner() != w) {
            if (this.fFileDialog != null) {
                this.fFileDialog.dispose();
                this.fFileDialog = null;
            }
            this.fFileDialog = w instanceof Frame ? new FileDialog((Frame)w, this.getTitle(), 0) : new FileDialog((Dialog)w, this.getTitle(), 0);
        }
        return this.fFileDialog;
    }

    protected boolean isAcceptAllFileFilter(FileFilter aFileFilter) {
        boolean result = true;
        for (int i = 0; i < this.fChoosableFileFilters.length; ++i) {
            if (!this.fChoosableFileFilters[i].equals(aFileFilter)) continue;
            result = false;
            break;
        }
        return result;
    }

    public String chooseFile(String aFileName) {
        return this.isUseNativeFileChooser() ? this.chooseFile_FileDialog(aFileName) : this.chooseFile_FileChooser(aFileName);
    }

    protected String chooseFile_FileDialog(String aFileName) {
        String result = null;
        FileDialog dialog = this.getFileDialog();
        dialog.applyComponentOrientation(this.getComponentOrientation());
        if (this.getChoosableFileFilters() != null && this.getChoosableFileFilters().length > 0 && this.getChoosableFileFilters()[0] instanceof FilenameFilter) {
            dialog.setFilenameFilter((FilenameFilter)((Object)this.getChoosableFileFilters()[0]));
        }
        if (aFileName == null || "".equals(aFileName)) {
            dialog.setFile(null);
            if (this.getDefaultFolder() != null) {
                dialog.setDirectory(this.getDefaultFolder());
            }
        } else {
            dialog.setFile(new File(aFileName).getName());
            dialog.setDirectory(new File(aFileName).getParent());
        }
        if (this.getTitle() != null) {
            dialog.setTitle(this.getTitle());
        }
        dialog.setVisible(true);
        if (dialog.getFile() != null) {
            result = new File(dialog.getDirectory(), dialog.getFile()).getAbsolutePath();
            this.setDefaultFolder(dialog.getDirectory());
        }
        return result;
    }

    protected String chooseFile_FileChooser(String aFileName) throws HeadlessException {
        String result = null;
        JFileChooser fileChooser = this.getFileChooser();
        fileChooser.updateUI();
        fileChooser.applyComponentOrientation(this.getComponentOrientation());
        if (this.getDefaultChoosableFileFilter() != null) {
            fileChooser.setFileFilter(this.getDefaultChoosableFileFilter());
        } else if (this.getChoosableFileFilters() != null && this.getChoosableFileFilters().length > 0) {
            fileChooser.setFileFilter(this.getChoosableFileFilters()[0]);
        }
        if (aFileName == null || "".equals(aFileName)) {
            fileChooser.setSelectedFile(null);
            if (this.getDefaultFolder() != null) {
                fileChooser.setCurrentDirectory(new File(this.getDefaultFolder()));
            }
        } else {
            fileChooser.setSelectedFile(new File(aFileName));
        }
        if (this.getTitle() != null) {
            fileChooser.setDialogTitle(this.getTitle());
        }
        if (fileChooser.showOpenDialog(this) == 0) {
            result = this.appendDefaultExtension(fileChooser.getSelectedFile(), fileChooser.getFileFilter()).getAbsolutePath();
            this.setDefaultFolder(fileChooser.getSelectedFile().getParent());
        }
        return result;
    }

    public String getTitle() {
        return this.fTitle;
    }

    public void setTitle(String aTitle) {
        this.fTitle = aTitle;
    }

    protected File appendDefaultExtension(File aFile, FileFilter aFileFilter) {
        File result = aFile;
        if (!result.isDirectory() && aFileFilter instanceof GenericFileFilter && result.getAbsolutePath().indexOf(".") == -1 && !this.isAcceptAllFileFilter(aFileFilter)) {
            result = new File(result.getAbsolutePath() + "." + ((GenericFileFilter)aFileFilter).getAcceptableExtensions()[0]);
        }
        return result;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this && e.getActionCommand().equals("buttonField")) {
            this.chooseFile();
        } else if (e.getSource() == this.fUpdateTimer) {
            this.firePropertyChange(PROPERTY_VALUE, null, this.getValue());
        } else {
            super.actionPerformed(e);
        }
    }

    public void removeNotify() {
        this.fUpdateTimer.stop();
        super.removeNotify();
    }

    public void insertUpdate(DocumentEvent e) {
        this.fUpdateTimer.restart();
    }

    public void removeUpdate(DocumentEvent e) {
        this.fUpdateTimer.restart();
    }

    public void changedUpdate(DocumentEvent e) {
        this.fUpdateTimer.restart();
    }
}

