/*
 * Decompiled with CFR 0.152.
 */
package dev.gui.field;

import dev.gui.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class ButtonField
extends JPanel
implements ActionListener {
    public static final String DEFAULT_BUTTON_TEXT = "...";
    public static final String DEFAULT_BUTTON_COMMAND = "buttonField";
    protected JButton fButton;
    protected JComponent fField;
    private transient Vector fActionListeners;
    public static final String BUTTON_ACTION_NAME = "button-action";
    protected Action fButtonAction = new AbstractAction("button-action"){

        public void actionPerformed(ActionEvent anEvent) {
            ButtonField.this.fireActionPerformed(new ActionEvent(ButtonField.this, 1001, ButtonField.DEFAULT_BUTTON_COMMAND));
        }
    };
    protected int fMinimumHeight = -1;
    protected int fMinimumWidth = -1;
    protected int fPreferredHeight = -1;
    protected int fPreferredWidth = -1;

    public ButtonField() {
        this((JComponent)null);
    }

    public ButtonField(JComponent aFieldComponent) {
        this.setLayout(new BorderLayout());
        this.setButton(new JButton(){

            public Dimension getPreferredSize() {
                Dimension result = super.getPreferredSize();
                if (UIUtils.isMac()) {
                    result.height = Math.min(result.height, 20);
                    if (ButtonField.DEFAULT_BUTTON_TEXT.equals(ButtonField.this.getButtonText())) {
                        result.width = result.height;
                    }
                }
                return result;
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        });
        this.setField(aFieldComponent);
    }

    public void setButton(JButton aButton) {
        if (aButton == null) {
            throw new IllegalArgumentException("Null button");
        }
        if (this.fButton != null) {
            this.remove(this.fButton);
            this.fButton.removeActionListener(this);
        }
        this.fButton = aButton;
        this.add((Component)this.fButton, "After");
        this.fButton.putClientProperty("JButton.buttonType", "bevel");
        this.fButton.setEnabled(false);
        this.fButton.setText(DEFAULT_BUTTON_TEXT);
        this.fButton.setMargin(new Insets(0, 2, 0, 2));
        this.fButton.addActionListener(this);
    }

    public JButton getButton() {
        return this.fButton;
    }

    public JComponent getField() {
        return this.fField;
    }

    public void setField(JComponent aField) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 3);
        if (this.fField != null) {
            UIUtils.unRregisterActionBinding(this.fField, keyStroke, this.fButtonAction);
            this.remove(this.fField);
        }
        this.fField = aField;
        if (aField != null) {
            UIUtils.registerActionBinding(this.fField, keyStroke, this.fButtonAction);
            this.add((Component)this.fField, "Center");
            this.repaint();
            this.revalidate();
        }
    }

    public String getToolTipText() {
        if (this.fField != null) {
            return this.fField.getToolTipText();
        }
        return super.getToolTipText();
    }

    public void setToolTipText(String aText) {
        if (this.fField != null) {
            this.fField.setToolTipText(aText);
        } else {
            super.setToolTipText(aText);
        }
    }

    public String getButtonText() {
        return this.fButton.getText();
    }

    public void setButtonText(String aText) {
        this.fButton.setText(aText);
        if (aText != null && aText.trim().length() > 0) {
            this.fButton.setIcon(null);
        }
    }

    public Icon getButtonIcon() {
        return this.fButton.getIcon();
    }

    public void setButtonIcon(Icon anIcon) {
        this.fButton.setIcon(anIcon);
        if (anIcon == null) {
            this.fButton.setText(DEFAULT_BUTTON_TEXT);
        } else {
            this.fButton.setText(null);
        }
    }

    public String getButtonToolTipText() {
        return this.fButton.getToolTipText();
    }

    public void setButtonToolTipText(String aText) {
        this.fButton.setToolTipText(aText);
    }

    public boolean isFieldEnabled() {
        return this.fField.isEnabled();
    }

    public void setFieldEnabled(boolean aValue) {
        this.fField.setEnabled(aValue);
    }

    public boolean isButtonEnabled() {
        return this.fButton.isEnabled();
    }

    public void setButtonEnabled(boolean aValue) {
        this.fButton.setEnabled(aValue);
    }

    public void setEnabled(boolean aValue) {
        if (this.fField != null) {
            this.fField.setEnabled(aValue);
        }
        this.fButton.setEnabled(aValue);
    }

    public void requestFocus() {
        if (this.fField != null && this.fField.isEnabled()) {
            this.fField.requestFocus();
        } else {
            this.fButton.requestFocus();
        }
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.fActionListeners != null && this.fActionListeners.contains(l)) {
            Vector v = (Vector)this.fActionListeners.clone();
            v.removeElement(l);
            this.fActionListeners = v;
        }
        this.fButton.setEnabled(!this.fActionListeners.isEmpty());
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector v;
        Vector vector = v = this.fActionListeners == null ? new Vector(2) : (Vector)this.fActionListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.fActionListeners = v;
        }
        this.fButton.setEnabled(!this.fActionListeners.isEmpty());
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.fActionListeners != null) {
            Vector listeners = this.fActionListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((ActionListener)listeners.elementAt(i)).actionPerformed(e);
            }
        }
    }

    public Dimension getMinimumSize() {
        Dimension result = super.getMinimumSize();
        if (this.fMinimumWidth != -1) {
            result.width = this.fMinimumWidth;
        }
        if (this.fMinimumHeight != -1) {
            result.height = this.fMinimumHeight;
        }
        return result;
    }

    public int getMinimumHeight() {
        return this.fMinimumHeight;
    }

    public void setMinimumHeight(int aMinimumHeight) {
        this.fMinimumHeight = aMinimumHeight;
    }

    public int getMinimumWidth() {
        return this.fMinimumWidth;
    }

    public void setMinimumWidth(int aMinimumWidth) {
        this.fMinimumWidth = aMinimumWidth;
    }

    public Dimension getPreferredSize() {
        Dimension result = super.getPreferredSize();
        if (this.fPreferredWidth != -1) {
            result.width = this.fPreferredWidth;
        }
        if (this.fPreferredHeight != -1) {
            result.height = this.fPreferredHeight;
        }
        return result;
    }

    public int getPreferredHeight() {
        return this.fPreferredHeight;
    }

    public void setPreferredHeight(int aPreferredHeight) {
        this.fPreferredHeight = aPreferredHeight;
    }

    public int getPreferredWidth() {
        return this.fPreferredWidth;
    }

    public void setPreferredWidth(int aPreferredWidth) {
        this.fPreferredWidth = aPreferredWidth;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.fButton) {
            this.fireActionPerformed(new ActionEvent(this, 1001, DEFAULT_BUTTON_COMMAND));
        }
    }
}

