/*
 * Decompiled with CFR 0.152.
 */
package dev.gui.combo;

import dev.gui.JComboBoxEx;
import dev.util.StringUtils;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.JDialog;

public class CountryCombobox
extends JComboBoxEx {
    protected static final String[] COUNTRY_LIST = new String[]{"Afghanistan", "Albania", "Algeria", "American Samoa", "Andorra", "Angola", "Anguilla", "Antartica", "Antigua & Barbuda", "Argentina", "Armenia", "Aruba", "Ascension Island", "Australia", "Austria", "Azerbaijan", "Bahamas", "Bahrain", "Bangladesh", "Barbados", "Belarus", "Belgium", "Belize", "Benin", "Bermuda", "Bhutan", "Bolivia", "Bosnia and Herzegovina", "Botswana", "Bouvet Island", "Brazil", "British Indian Ocean Territory", "Brunei Darussalam", "Bulgaria", "Burkina Faso", "Burundi", "Cambodia", "Cameroon", "Canada", "Cape Verde", "Cayman Islands", "Central African Republic", "Chad", "Chile", "China", "Christmas Island", "Cocos (Keeling) Islands", "Colombia", "Comoros", "Congo, Democratic Republic of the", "Congo, Republic of", "Cook Islands", "Costa Rica", "Cote d'Ivoire", "Croatia/Hrvatska", "Cyprus", "Czech Republic", "Denmark", "Djibouti", "Dominica", "Dominican Republic", "East Timor", "Ecuador", "Egypt", "El Salvador", "Equatorial Guinea", "Eritrea", "Estonia", "Ethiopia", "Falkland Islands (Malvina)", "Faroe Islands", "Fiji", "Finland", "France", "France (Metropolitan)", "French Guiana", "French Polynesia", "French Southern Territories", "Gabon", "Gambia", "Georgia", "Germany", "Ghana", "Gibraltar", "Great Britain", "Greece", "Greenland", "Grenada", "Guadeloupe", "Guam", "Guatemala", "Guernsey", "Guinea", "Guinea-Bissau", "Guyana", "Haiti", "Heard and McDonald Islands", "Holy See (City Vatican State)", "Honduras", "Hong Kong", "Hungary", "Iceland", "India", "Indonesia", "Ireland", "Isle of Man", "Israel", "Italy", "Jamaica", "Japan", "Jersey", "Jordan", "Kazakhstan", "Kenya", "Kiribati", "Korea, Republic of", "Kuwait", "Kyrgyzstan", "Lao People's Democratic Republic", "Latvia", "Lebanon", "Lesotho", "Liberia", "Liechtenstein", "Lithuania", "Luxembourg", "Macau", "Macedonia, Former Yugoslav Republic", "Madagascar", "Malawi", "Malaysia", "Maldives", "Mali", "Malta", "Marshall Islands", "Martinique", "Mauritania", "Mauritius", "Mayotte", "Mexico", "Micronesia", "Moldova", "Monaco", "Mongolia", "Montserrat", "Morocco", "Mozambique", "Namibia", "Nauru", "Nepal", "Netherlands", "Netherlands Antilles", "New Caledonia", "New Zealand", "Nicaragua", "Niger", "Nigeria", "Niue", "Norfolk Island", "Northern Mariana Islands", "Norway", "Not Determined", "Oman", "Pakistan", "Palau", "Panama", "Papua New Guinea", "Paraguay", "Peru", "Philippines", "Pitcairn Island", "Poland", "Portugal", "Puerto Rico", "Qatar", "Reunion Island", "Romania", "Russian Federation", "Rwanda", "Saint Kitts and Nevis", "Saint Lucia", "Saint Vincent and the Grenadines", "San Marino", "Sao Tome and Principe", "Saudi Arabia", "Senegal", "Seychelles", "Sierra Leone", "Singapore", "Slovak Republic", "Slovenia", "Solomon Islands", "Somalia", "South Africa", "South Georgia and the South Sandwich Islands", "Spain", "Sri Lanka", "St Pierre and Miquelon", "St. Helena", "Suriname", "Svalbard and Jan Mayen Islands", "Swaziland", "Sweden", "Switzerland", "Taiwan", "Tajikistan", "Tanzania", "Thailand", "Togo", "Tokelau", "Tonga", "Trinidad and Tobago", "Tunisia", "Turkey", "Turkmenistan", "Turks and Caicos Islands", "Tuvalu", "US Minor Outlying Islands", "Uganda", "Ukraine", "United Arab Emirates", "United Kingdom", "United States", "Uruguay", "Uzbekistan", "Vanuatu", "Venezuela", "Vietnam", "Virgin Island (British)", "Virgin Islands (USA)", "Wallis And Futuna Islands", "Western Sahara", "Western Samoa", "Yemen", "Yugoslavia", "Zambia", "Zimbabwe"};
    protected static final HashMap LOCALE_COUNTRY_MAP = new HashMap();

    public CountryCombobox() {
        super(COUNTRY_LIST);
        this.setEditable(false);
        this.setSelectedItem(this.getDefaultCountry());
    }

    public static void bind(Locale aLocale, String aCountry) {
        LOCALE_COUNTRY_MAP.put(aLocale.getCountry(), aCountry);
    }

    public String getDefaultCountry() {
        return (String)LOCALE_COUNTRY_MAP.get(Locale.getDefault().getCountry());
    }

    public String getSelectedCountry() {
        return (String)this.getSelectedItem();
    }

    public void setSelectedCountry(String aCountry) {
        this.setSelectedItem(aCountry);
        if (!StringUtils.equals((String)this.getSelectedItem(), aCountry)) {
            String country = (String)LOCALE_COUNTRY_MAP.get(aCountry);
            if (country != null) {
                this.setSelectedItem(country);
            } else {
                this.setSelectedItem(null);
            }
        }
    }

    public static void main(String[] args) {
        JDialog jDialog = new JDialog();
        jDialog.getContentPane().add(new CountryCombobox());
        jDialog.setModal(true);
        jDialog.pack();
        jDialog.setVisible(true);
    }

    static {
        CountryCombobox.bind(Locale.US, "United States");
        CountryCombobox.bind(Locale.UK, "United Kingdom");
        CountryCombobox.bind(Locale.GERMANY, "Germany");
        CountryCombobox.bind(Locale.FRANCE, "France");
        CountryCombobox.bind(Locale.ITALY, "Italy");
        CountryCombobox.bind(Locale.JAPAN, "Japan");
        CountryCombobox.bind(Locale.CANADA, "Canada");
    }
}

