/*
 * Decompiled with CFR 0.152.
 */
package dev.gui.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class IndicatorBorder
extends AbstractBorder {
    protected String fIndicator = "*";
    protected Color fColor = Color.red;
    protected static final int H_GAP = 2;

    public IndicatorBorder(String aIndicator) {
        this.fIndicator = aIndicator;
    }

    public IndicatorBorder() {
    }

    public Color getColor() {
        return this.fColor;
    }

    public void setColor(Color aColor) {
        this.fColor = aColor;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.fIndicator == null) {
            return;
        }
        Dimension size = this.getIndicatorSize(c);
        Color savColor = g.getColor();
        Font savFont = g.getFont();
        if (c.getParent() != null) {
            g.setColor(c.getParent().getBackground());
            int w = this.getBorderInsets((Component)c).right;
            g.fillRect(x + width - w, y, w, height);
        }
        g.setColor(c.isEnabled() ? this.fColor : SystemColor.controlShadow);
        g.setFont(c.getFont());
        g.drawString(this.fIndicator, x + width - 2 - size.width, y + height - (height - size.height) / 2);
        g.setColor(savColor);
        g.setFont(savFont);
    }

    public String getIndicator() {
        return this.fIndicator;
    }

    public void setIndicator(String aIndicator) {
        this.fIndicator = aIndicator;
    }

    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.bottom = 0;
        insets.top = 0;
        insets.left = 0;
        Dimension size = this.getIndicatorSize(c);
        insets.right = size.width + 4;
        return insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    protected Dimension getIndicatorSize(Component c) {
        FontMetrics fm = this.getFontMetrics(c);
        return this.fIndicator != null ? new Dimension(fm.charsWidth(this.fIndicator.toCharArray(), 0, this.fIndicator.length()), fm.getHeight()) : new Dimension();
    }

    protected FontMetrics getFontMetrics(Component c) {
        return c.getFontMetrics(c.getFont());
    }

    public static class CompoundBorder
    extends javax.swing.border.CompoundBorder
    implements UIResource {
        public CompoundBorder() {
        }

        public CompoundBorder(Border anOutsideBorder, Border anInsideBorder) {
            super(anOutsideBorder, anInsideBorder);
        }
    }
}

