/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.util.HashMap;

public class WaitStateSupport {
    protected Container fOwner;
    protected HashMap fComponentCursorMap = new HashMap();
    protected int fWaitState = 0;

    public WaitStateSupport(Container aOwner) {
        this.fOwner = aOwner;
    }

    public boolean isWaitState() {
        return this.fWaitState > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWaitState(boolean aWaitState) {
        if (aWaitState) {
            ++this.fWaitState;
        } else {
            if (this.fWaitState == 0) {
                throw new IllegalStateException("Component is already in no-waiting state");
            }
            --this.fWaitState;
        }
        if (this.fWaitState == 1 && aWaitState || this.fWaitState == 0 && !aWaitState) {
            Object object = this.fOwner.getTreeLock();
            synchronized (object) {
                this.setWaitState(this.fOwner, aWaitState);
            }
        }
        if (!this.isWaitState()) {
            this.fComponentCursorMap.clear();
        }
    }

    protected void setWaitState(Container aContainer, boolean aWaitState) {
        this.setWaitState((Component)aContainer, aWaitState);
        for (int i = 0; i < aContainer.getComponentCount(); ++i) {
            Component c = aContainer.getComponent(i);
            if (c instanceof Container) {
                this.setWaitState((Container)c, aWaitState);
                continue;
            }
            this.setWaitState(c, aWaitState);
        }
    }

    protected void setWaitState(Component aComponent, boolean aWaitState) {
        if (aWaitState) {
            this.fComponentCursorMap.put(aComponent, aComponent.isCursorSet() ? aComponent.getCursor() : null);
            aComponent.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            Cursor cursor = (Cursor)this.fComponentCursorMap.remove(aComponent);
            aComponent.setCursor(cursor);
        }
    }
}

