/*
 * Decompiled with CFR 0.152.
 */
package dev.gui;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import dev.gui.LafColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.RoundRectangle2D;
import java.security.AccessController;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import sun.security.action.GetPropertyAction;

public class UIUtils {
    public static Color BUTTON_SHADOW = new Color(29, 86, 177);
    public static Color BUTTON_DARK_SHADOW = new Color(9, 66, 157);
    public static Color BUTTON_HIGHLIGHT = new Color(49, 106, 197);
    public static Color BUTTON_LIGHT_HIGHLIGHT = new Color(59, 116, 207);
    public static Color BUTTON_SELECTED = new LafColor("Button.background", -0.75f);
    public static Color BUTTON_ROLLOVER_BG = new Color(198, 215, 243);
    public static Color BUTTON_SELECTED_BG = new LafColor("Button.background", -0.9f, new Color(208, 225, 225));
    public static Color BUTTON_PRESSED_BG = new Color(178, 195, 223);
    public static Color HYPERLINK = new Color(0, 0, 128);
    public static Color HYPERLINK_ROLLOVER = Color.BLUE;
    public static final double TOOLBAR_FACTOR_DARK = 0.9;
    public static final double TOOLBAR_FACTOR_LIGHT = 0.97;
    public static final double SEPARATOR_FACTOR_LIGHT = 0.4;
    public static final double HEADER_FACTOR_DARK = 0.97;
    public static final double HEADER_FACTOR_LIGHT = 0.99;
    public static final double HEADER_3D_FACTOR_DARK = 0.97;
    public static final double HEADER_3D_FACTOR_LIGHT = 0.995;
    public static final double BUTTON_FACTOR_DARK = 0.97;
    public static final double BUTTON_FACTOR_LIGHT = 0.97;

    public static String colorToHexString(Color aCoor) {
        return Integer.toHexString(aCoor.getRed()) + Integer.toHexString(aCoor.getGreen()) + Integer.toHexString(aCoor.getBlue());
    }

    public static Color getDarker(Color aColor, double aFactor) {
        return new Color(Math.max((int)((double)aColor.getRed() * aFactor), 0), Math.max((int)((double)aColor.getGreen() * aFactor), 0), Math.max((int)((double)aColor.getBlue() * aFactor), 0), aColor.getAlpha());
    }

    public static Color getBrighter(Color aColor, double aFactor) {
        if (aFactor == 1.0) {
            return aColor;
        }
        int r = aColor.getRed();
        int g = aColor.getGreen();
        int b = aColor.getBlue();
        int i = (int)(1.0 / (1.0 - aFactor));
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i, aColor.getAlpha());
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((double)r / aFactor), 255), Math.min((int)((double)g / aFactor), 255), Math.min((int)((double)b / aFactor), 255), aColor.getAlpha());
    }

    public static Paint getHorisontalPaint(Color aColor1, Color aColor2, Dimension aSize) {
        float delta = 0.45f * (float)aSize.height;
        float x1 = aSize.width / 2;
        float y1 = (float)(aSize.height / 2) - delta;
        float x2 = aSize.width / 2;
        float y2 = (float)(aSize.height / 2) + delta;
        return new GradientPaint(x1, y1, aColor1, x2, y2, aColor2);
    }

    public static Paint getGradientPanelPaint(Color aColor, Dimension aSize) {
        return UIUtils.getHeaderPaint(aColor, aSize);
    }

    public static Paint getToolbarPaint(Color aColor, Dimension aSize) {
        return UIUtils.isMac() || UIUtils.getPixelSize() < 16 ? aColor : UIUtils.getHorisontalPaint(UIUtils.getBrighter(aColor, 0.97), UIUtils.getDarker(aColor, 0.9), aSize);
    }

    public static Paint getStatusBarPaint(Color aColor, Dimension aSize) {
        return UIUtils.isMac() || UIUtils.getPixelSize() < 16 ? aColor : UIUtils.getHorisontalPaint(UIUtils.getBrighter(aColor, 0.97), UIUtils.getDarker(aColor, 0.9), aSize);
    }

    public static Paint getHeader3dPaint(Color aColor, Dimension aSize) {
        return UIUtils.isMac() || UIUtils.getPixelSize() < 16 ? aColor : UIUtils.getHorisontalPaint(UIUtils.getBrighter(aColor, 0.97), UIUtils.getDarker(aColor, 0.9), aSize);
    }

    public static Paint getSeparatorPaint(Color aColor, Dimension aSize) {
        if (UIUtils.isMac() || UIUtils.getPixelSize() < 16) {
            return aColor;
        }
        float x1 = aSize.width / 2;
        float y1 = 0.0f;
        float x2 = aSize.width / 2;
        float y2 = aSize.height / 2;
        return new GradientPaint(x1, y1, UIUtils.getBrighter(aColor, 0.4), x2, y2, aColor, true);
    }

    public static Paint getButtonPaint(Color aColor, Dimension aSize) {
        return UIUtils.isMac() || UIUtils.getPixelSize() < 16 ? aColor : UIUtils.getHorisontalPaint(UIUtils.getDarker(aColor, 0.97), UIUtils.getBrighter(aColor, 0.97), aSize);
    }

    public static Paint getHeader3DPaint(Color aColor, Dimension aSize) {
        return UIUtils.isMac() || UIUtils.getPixelSize() < 16 ? aColor : UIUtils.getHorisontalPaint(UIUtils.getBrighter(aColor, 0.995), UIUtils.getDarker(aColor, 0.97), aSize);
    }

    public static Paint getHeaderPaint(Color aColor, Dimension aSize) {
        return UIUtils.getHeaderPaint(null, aColor, aSize);
    }

    public static Paint getHeaderPaint(Component aComponent, Color aColor, Dimension aSize) {
        ComponentOrientation or;
        Color color = aColor;
        if (UIUtils.isMac()) {
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 96);
        }
        Color startColor = UIUtils.getDarker(color, 0.9f);
        Color endColor = color;
        ComponentOrientation componentOrientation = or = aComponent != null ? aComponent.getComponentOrientation() : ComponentOrientation.UNKNOWN;
        return UIUtils.getPixelSize() < 16 ? UIUtils.getDarker(color, 0.95f) : new GradientPaint(0.0f, aSize.height / 2, or != ComponentOrientation.RIGHT_TO_LEFT ? startColor : endColor, aSize.width, aSize.height / 2, or != ComponentOrientation.RIGHT_TO_LEFT ? endColor : startColor);
    }

    public static Paint getHeaderPaintV(Color aColor, Dimension aSize) {
        Color color = aColor;
        if (UIUtils.isMac()) {
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 96);
        }
        return UIUtils.getPixelSize() < 16 ? UIUtils.getDarker(color, 0.95f) : new GradientPaint(aSize.width / 2, 0.0f, UIUtils.getDarker(color, 0.92f), aSize.width / 2, aSize.height, color);
    }

    public static boolean isWinXPLookFeel() {
        boolean result = false;
        if (UIManager.getLookAndFeel() instanceof WindowsLookAndFeel) {
            Boolean themeActive = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
            if (themeActive == null) {
                themeActive = Boolean.FALSE;
            }
            result = themeActive != false && AccessController.doPrivileged(new GetPropertyAction("swing.noxp")) == null && !"com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName());
        }
        return result;
    }

    public static boolean isMac() {
        try {
            return System.getProperty("mrj.version") != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static int getPixelSize() {
        return Toolkit.getDefaultToolkit().getColorModel().getPixelSize();
    }

    public static void fillGlassRect(Graphics2D aGraphics, Color aColor, Rectangle aRect, int aRadius) {
        Object antialiasing = aGraphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object rendering = aGraphics.getRenderingHint(RenderingHints.KEY_RENDERING);
        aGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        aGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Shape clip = aGraphics.getClip();
        if (aRadius > 0) {
            aGraphics.clip(new RoundRectangle2D.Float(aRect.x, aRect.y, aRect.width, aRect.height, 2 * aRadius, 2 * aRadius));
        }
        Color upperColor = UIUtils.getBrighter(aColor, 0.92);
        Color lowerColor = UIUtils.getDarker(aColor, 0.95);
        Dimension d = aRect.getSize();
        aGraphics.setPaint(UIUtils.getHorisontalPaint(UIUtils.getDarker(lowerColor, 0.8), Color.WHITE, aRect.getSize()));
        aGraphics.fillRect(aRect.x, aRect.y + aRect.height / 2 - 4, aRect.width, aRect.height);
        aGraphics.setPaint(UIUtils.getHorisontalPaint(Color.WHITE, UIUtils.getDarker(upperColor, 0.8), aRect.getSize()));
        aGraphics.fillRoundRect(aRect.x, aRect.y - 10, aRect.width + 1, aRect.y + aRect.height / 2 + 10, 10, 10);
        aGraphics.setClip(clip);
        aGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing);
        aGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, rendering);
    }

    public static void fillGlossyRect(Graphics2D aGraphics, Color aColor, Rectangle aRect, int aRadius) {
        Object antialiasing = aGraphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object rendering = aGraphics.getRenderingHint(RenderingHints.KEY_RENDERING);
        aGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        aGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Shape clip = aGraphics.getClip();
        if (aRadius > 0) {
            aGraphics.clip(new RoundRectangle2D.Float(aRect.x, aRect.y, aRect.width, aRect.height, 2 * aRadius, 2 * aRadius));
        }
        Color lowerColor = UIUtils.getDarker(aColor, 0.99);
        aGraphics.setPaint(UIUtils.getHorisontalPaint(UIUtils.getBrighter(lowerColor, 0.35), UIUtils.getDarker(lowerColor, 0.85), aRect.getSize()));
        aGraphics.fillRect(aRect.x, aRect.y, aRect.width, aRect.height);
        aGraphics.setPaint(new Color(250, 255, 255, 24));
        aGraphics.fillRect(aRect.x, aRect.y, aRect.width, aRect.height / 2);
        aGraphics.setPaint(new Color(250, 255, 255, 4));
        aGraphics.fillRect(aRect.x, aRect.height / 2 - 1, aRect.width, 2);
        aGraphics.setClip(clip);
        aGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing);
        aGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, rendering);
    }

    public static void fillGlossyRect(Graphics2D aGraphics, Color aBottomColor, Color aTopColor, Rectangle aRect, int aRadius) {
        Object antialiasing = aGraphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object rendering = aGraphics.getRenderingHint(RenderingHints.KEY_RENDERING);
        aGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        aGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Shape clip = aGraphics.getClip();
        if (aRadius > 0) {
            aGraphics.clip(new RoundRectangle2D.Float(aRect.x, aRect.y, aRect.width, aRect.height, 2 * aRadius, 2 * aRadius));
        }
        aGraphics.setPaint(UIUtils.getHorisontalPaint(aTopColor, aBottomColor, aRect.getSize()));
        aGraphics.fillRect(aRect.x, aRect.y, aRect.width, aRect.height);
        aGraphics.setPaint(new Color(255, 255, 255, 32));
        aGraphics.fillRect(aRect.x, aRect.y, aRect.width, aRect.height / 2);
        aGraphics.setClip(clip);
        aGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing);
        aGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, rendering);
    }

    public static void fill3DRect(Graphics2D aGraphics, Color aColor, Rectangle aRect, int aRadius) {
        Object antialiasing = aGraphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object rendering = aGraphics.getRenderingHint(RenderingHints.KEY_RENDERING);
        aGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        aGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Shape clip = aGraphics.getClip();
        if (aRadius > 0) {
            aGraphics.clip(new RoundRectangle2D.Float(aRect.x, aRect.y, aRect.width, aRect.height, 2 * aRadius, 2 * aRadius));
        }
        aGraphics.setPaint(UIUtils.getHorisontalPaint(UIUtils.getBrighter(aColor, 0.97), UIUtils.getDarker(aColor, 0.9), aRect.getSize()));
        aGraphics.fill(aRect);
        aGraphics.setClip(clip);
        aGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing);
        aGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, rendering);
    }

    public static void registerActionBinding(JComponent aComponent, KeyStroke aKeyStroke, Action anAction) {
        String actionName = (String)anAction.getValue("Name");
        InputMap inputMap = aComponent.getInputMap(aComponent instanceof JTable ? 1 : 0);
        inputMap.put(aKeyStroke, actionName);
        aComponent.getActionMap().put(actionName, anAction);
    }

    public static void unRregisterActionBinding(JComponent aComponent, KeyStroke aKeyStroke, Action anAction) {
        String actionName = (String)anAction.getValue("Name");
        InputMap inputMap = aComponent.getInputMap(aComponent instanceof JTable ? 1 : 0);
        inputMap.remove(aKeyStroke);
        aComponent.getActionMap().remove(actionName);
    }

    public static boolean applyComponentOrientation(Container aContainer) {
        boolean result = false;
        ComponentOrientation or = ComponentOrientation.getOrientation(Locale.getDefault());
        if (or == ComponentOrientation.RIGHT_TO_LEFT && !"true".equals(System.getProperty("dev.gui.ignoreComponentOrientation", null))) {
            aContainer.applyComponentOrientation(or);
            result = true;
        }
        return result;
    }

    public static class ScrollPaneBorder
    extends AbstractBorder {
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.translate(x, y);
            g.setColor(UIManager.getColor("controlShadow"));
            g.drawRect(0, 0, width - 2, height - 2);
            g.setColor(UIManager.getColor("controlHighlight"));
            g.drawLine(1, height - 1, width - 1, height - 1);
            g.drawLine(width - 1, 1, width - 1, height - 1);
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = 1;
            insets.left = 1;
            insets.bottom = 2;
            insets.right = 2;
            return insets;
        }
    }
}

